/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.tableview2;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import javafx.scene.control.TableColumnBase;
import org.controlsfx.control.tableview2.FilteredTableColumn;

public class FilteredColumnPredicate<S, T>
implements Predicate<S> {
    private final List<? extends TableColumnBase> columns;

    public FilteredColumnPredicate(TableColumnBase<S, T> ... columns) {
        this(Arrays.asList(columns));
    }

    public FilteredColumnPredicate(List<? extends TableColumnBase> columns) {
        this.columns = Collections.unmodifiableList(columns);
    }

    @Override
    public boolean test(S s2) {
        for (TableColumnBase tableColumnBase : this.columns) {
            Object value;
            boolean result;
            FilteredTableColumn ftc;
            if (!(tableColumnBase instanceof FilteredTableColumn) || (ftc = (FilteredTableColumn)tableColumnBase).getPredicate() == null || !ftc.isFilterable() || (result = this.doFilter(ftc, value = tableColumnBase.getCellData(s2)))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = 7;
        hash = 59 * hash + (this.columns != null ? this.columns.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FilteredColumnPredicate other = (FilteredColumnPredicate)obj;
        return this.columns == other.columns || this.columns != null && this.columns.equals(other.columns);
    }

    private boolean doFilter(FilteredTableColumn<S, T> filter, T value) {
        Predicate<T> p = filter.getPredicate();
        return p == null || p.test(value);
    }

    public String toString() {
        return "FilteredColumnsPredicate [ columns: " + this.columns + "] ";
    }
}

