/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.actions;

import java.awt.event.ActionEvent;
import java.util.Comparator;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.jabref.gui.BasePanel;
import org.jabref.gui.JabRefFrame;
import org.jabref.gui.actions.MnemonicAwareAction;
import org.jabref.logic.l10n.Localization;

public class SortTabsAction
extends MnemonicAwareAction
implements Comparator<String> {
    private final JabRefFrame frame;

    public SortTabsAction(JabRefFrame frame) {
        this.putValue("Name", Localization.menuTitle("Sort tabs", new String[0]));
        this.putValue("ShortDescription", Localization.lang("Rearrange tabs alphabetically by title", new String[0]));
        this.frame = frame;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        TreeMap<String, BasePanel> map = new TreeMap<String, BasePanel>(this);
        for (BasePanel basePanel : this.frame.getBasePanelList()) {
            map.put(basePanel.getTabTitle(), basePanel);
        }
        this.frame.getTabbedPane().removeAll();
        for (Map.Entry entry : map.entrySet()) {
            this.frame.addTab((BasePanel)entry.getValue(), false);
        }
    }

    @Override
    public int compare(String o1, String o2) {
        return o1.toLowerCase(Locale.ROOT).compareTo(o2.toLowerCase(Locale.ROOT));
    }
}

