/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.entryeditor;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.RowConstraints;
import javax.swing.undo.UndoManager;
import org.jabref.Globals;
import org.jabref.gui.FXDialogService;
import org.jabref.gui.GUIGlobals;
import org.jabref.gui.autocompleter.SuggestionProviders;
import org.jabref.gui.entryeditor.EntryEditorTab;
import org.jabref.gui.fieldeditors.FieldEditorFX;
import org.jabref.gui.fieldeditors.FieldEditors;
import org.jabref.gui.fieldeditors.FieldNameLabel;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.EntryTypes;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.EntryType;
import org.jabref.model.entry.FieldProperty;
import org.jabref.model.entry.InternalBibtexFields;

abstract class FieldsEditorTab
extends EntryEditorTab {
    private final Map<String, FieldEditorFX> editors = new LinkedHashMap<String, FieldEditorFX>();
    private final boolean isCompressed;
    private final SuggestionProviders suggestionProviders;
    private FieldEditorFX activeField;
    private final BibDatabaseContext databaseContext;
    private UndoManager undoManager;
    private Collection<String> fields;

    public FieldsEditorTab(boolean compressed, BibDatabaseContext databaseContext, SuggestionProviders suggestionProviders, UndoManager undoManager) {
        this.isCompressed = compressed;
        this.databaseContext = databaseContext;
        this.suggestionProviders = suggestionProviders;
        this.undoManager = undoManager;
    }

    private static void addColumn(GridPane gridPane, int columnIndex, List<Label> nodes) {
        gridPane.addColumn(columnIndex, nodes.toArray(new Node[nodes.size()]));
    }

    private static void addColumn(GridPane gridPane, int columnIndex, Stream<Parent> nodes) {
        gridPane.addColumn(columnIndex, (Node[])nodes.toArray(Node[]::new));
    }

    private String convertToHex(Color color) {
        return String.format("#%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue());
    }

    private Region setupPanel(BibEntry entry, boolean compressed, SuggestionProviders suggestionProviders, UndoManager undoManager) {
        this.editors.clear();
        EntryType entryType = EntryTypes.getTypeOrDefault(entry.getType(), this.databaseContext.getMode());
        this.fields = this.determineFieldsToShow(entry, entryType);
        ArrayList<Label> labels = new ArrayList<Label>();
        for (String fieldName : this.fields) {
            FieldEditorFX fieldEditor = FieldEditors.getForField(fieldName, Globals.TASK_EXECUTOR, new FXDialogService(), Globals.journalAbbreviationLoader, Globals.prefs.getJournalAbbreviationPreferences(), Globals.prefs, this.databaseContext, entry.getType(), suggestionProviders, undoManager);
            fieldEditor.bindToEntry(entry);
            this.editors.put(fieldName, fieldEditor);
            labels.add(new FieldNameLabel(fieldName));
        }
        GridPane gridPane = new GridPane();
        gridPane.getStyleClass().add((Object)"editorPane");
        ColumnConstraints columnExpand = new ColumnConstraints();
        columnExpand.setHgrow(Priority.ALWAYS);
        ColumnConstraints columnDoNotContract = new ColumnConstraints();
        columnDoNotContract.setMinWidth(Double.NEGATIVE_INFINITY);
        if (compressed) {
            int rows = (int)Math.ceil((double)this.fields.size() / 2.0);
            FieldsEditorTab.addColumn(gridPane, 0, labels.subList(0, rows));
            FieldsEditorTab.addColumn(gridPane, 3, labels.subList(rows, labels.size()));
            FieldsEditorTab.addColumn(gridPane, 1, this.editors.values().stream().map(FieldEditorFX::getNode).limit(rows));
            FieldsEditorTab.addColumn(gridPane, 4, this.editors.values().stream().map(FieldEditorFX::getNode).skip(rows));
            gridPane.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{columnDoNotContract, columnExpand, new ColumnConstraints(10.0), columnDoNotContract, columnExpand});
            this.setCompressedRowLayout(gridPane, rows);
        } else {
            int rows = this.fields.size();
            FieldsEditorTab.addColumn(gridPane, 0, labels);
            FieldsEditorTab.addColumn(gridPane, 1, this.editors.values().stream().map(FieldEditorFX::getNode));
            gridPane.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{columnDoNotContract, columnExpand});
            this.setRegularRowLayout(gridPane, rows);
        }
        if (GUIGlobals.currentFont != null) {
            gridPane.setStyle("text-area-background: " + this.convertToHex(GUIGlobals.validFieldBackgroundColor) + ";text-area-foreground: " + this.convertToHex(GUIGlobals.editorTextColor) + ";text-area-highlight: " + this.convertToHex(GUIGlobals.activeBackgroundColor) + ";");
        }
        ScrollPane scrollPane = new ScrollPane();
        scrollPane.setHbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        scrollPane.setVbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
        scrollPane.setContent((Node)gridPane);
        scrollPane.setFitToWidth(true);
        scrollPane.setFitToHeight(true);
        return scrollPane;
    }

    private void setRegularRowLayout(GridPane gridPane, int rows) {
        ArrayList<RowConstraints> constraints = new ArrayList<RowConstraints>(rows);
        for (String field2 : this.fields) {
            RowConstraints rowExpand = new RowConstraints();
            rowExpand.setVgrow(Priority.ALWAYS);
            rowExpand.setValignment(VPos.TOP);
            if (rows == 0) {
                rowExpand.setPercentHeight(100.0);
            } else {
                rowExpand.setPercentHeight((double)(100 / rows) * this.editors.get(field2).getWeight());
            }
            constraints.add(rowExpand);
        }
        gridPane.getRowConstraints().addAll(constraints);
    }

    private void setCompressedRowLayout(GridPane gridPane, int rows) {
        RowConstraints rowExpand = new RowConstraints();
        rowExpand.setVgrow(Priority.ALWAYS);
        rowExpand.setValignment(VPos.TOP);
        if (rows == 0) {
            rowExpand.setPercentHeight(100.0);
        } else {
            rowExpand.setPercentHeight((double)(100 / rows));
        }
        for (int i = 0; i < rows; ++i) {
            gridPane.getRowConstraints().add((Object)rowExpand);
        }
    }

    private String getPrompt(String field2) {
        Set<FieldProperty> fieldProperties = InternalBibtexFields.getFieldProperties(field2);
        if (fieldProperties.contains((Object)FieldProperty.PERSON_NAMES)) {
            return String.format("%1$s and %1$s and others", Localization.lang("Firstname Lastname", new String[0]));
        }
        if (fieldProperties.contains((Object)FieldProperty.DOI)) {
            return "10.ORGANISATION/ID";
        }
        if (fieldProperties.contains((Object)FieldProperty.DATE)) {
            return "YYYY-MM-DD";
        }
        switch (field2) {
            case "year": {
                return "YYYY";
            }
            case "month": {
                return "MM or #mmm#";
            }
            case "url": {
                return "https://";
            }
        }
        return "";
    }

    public void requestFocus(String fieldName) {
        if (this.editors.containsKey(fieldName)) {
            this.activeField = this.editors.get(fieldName);
            this.activeField.requestFocus();
        }
    }

    @Override
    public boolean shouldShow(BibEntry entry) {
        EntryType entryType = EntryTypes.getTypeOrDefault(entry.getType(), this.databaseContext.getMode());
        return !this.determineFieldsToShow(entry, entryType).isEmpty();
    }

    @Override
    public void handleFocus() {
        if (this.activeField != null) {
            this.activeField.requestFocus();
        }
    }

    @Override
    protected void bindToEntry(BibEntry entry) {
        Region panel = this.setupPanel(entry, this.isCompressed, this.suggestionProviders, this.undoManager);
        this.setContent((Node)panel);
    }

    protected abstract Collection<String> determineFieldsToShow(BibEntry var1, EntryType var2);

    public Collection<String> getShownFields() {
        return this.fields;
    }
}

