/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.fieldeditors;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import org.jabref.gui.autocompleter.AutoCompleteSuggestionProvider;
import org.jabref.gui.fieldeditors.MapBasedEditorViewModel;
import org.jabref.logic.integrity.FieldCheckers;
import org.jabref.logic.l10n.Localization;

public class PaginationEditorViewModel
extends MapBasedEditorViewModel<String> {
    private BiMap<String, String> itemMap = HashBiMap.create(7);

    public PaginationEditorViewModel(String fieldName, AutoCompleteSuggestionProvider<?> suggestionProvider, FieldCheckers fieldCheckers) {
        super(fieldName, suggestionProvider, fieldCheckers);
        this.itemMap.put("page", Localization.lang("Page", new String[0]));
        this.itemMap.put("column", Localization.lang("Column", new String[0]));
        this.itemMap.put("line", Localization.lang("Line", new String[0]));
        this.itemMap.put("verse", Localization.lang("Verse", new String[0]));
        this.itemMap.put("section", Localization.lang("Section", new String[0]));
        this.itemMap.put("paragraph", Localization.lang("Paragraph", new String[0]));
        this.itemMap.put("none", Localization.lang("None", new String[0]));
    }

    @Override
    protected BiMap<String, String> getItemMap() {
        return this.itemMap;
    }

    @Override
    public String convertToDisplayText(String object) {
        return object;
    }
}

