/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.fieldeditors.contextmenu;

import java.util.ArrayList;
import java.util.Objects;
import javafx.beans.property.StringProperty;
import javafx.scene.Node;
import javafx.scene.control.CustomMenuItem;
import javafx.scene.control.Label;
import javafx.scene.control.Menu;
import javafx.scene.control.Tooltip;
import org.jabref.Globals;
import org.jabref.logic.formatter.Formatters;
import org.jabref.logic.formatter.casechanger.ProtectTermsFormatter;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.cleanup.Formatter;

class CaseChangeMenu
extends Menu {
    public CaseChangeMenu(StringProperty text) {
        super(Localization.lang("Change case", new String[0]));
        Objects.requireNonNull(text);
        ArrayList<Formatter> caseChangers = new ArrayList<Formatter>();
        caseChangers.addAll(Formatters.getCaseChangers());
        caseChangers.add(new ProtectTermsFormatter(Globals.protectedTermsLoader));
        for (Formatter caseChanger : caseChangers) {
            CustomMenuItem menuItem = new CustomMenuItem((Node)new Label(caseChanger.getName()));
            Tooltip toolTip = new Tooltip(caseChanger.getDescription());
            Tooltip.install((Node)menuItem.getContent(), (Tooltip)toolTip);
            menuItem.setOnAction(event -> text.set((Object)caseChanger.format((String)text.get())));
            this.getItems().add((Object)menuItem);
        }
    }
}

