/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.fieldeditors.contextmenu;

import java.util.List;
import java.util.stream.Collectors;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.TextArea;
import javax.swing.SwingUtilities;
import org.jabref.Globals;
import org.jabref.JabRefGUI;
import org.jabref.gui.protectedterms.NewProtectedTermsFileDialog;
import org.jabref.logic.formatter.casechanger.ProtectTermsFormatter;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.protectedterms.ProtectedTermsList;
import org.jabref.logic.protectedterms.ProtectedTermsLoader;
import org.jabref.model.cleanup.Formatter;

class ProtectedTermsMenu
extends Menu {
    private static final Formatter FORMATTER = new ProtectTermsFormatter(Globals.protectedTermsLoader);
    private final Menu externalFiles;
    private final TextArea opener;

    public ProtectedTermsMenu(TextArea opener) {
        super(Localization.lang("Protect terms", new String[0]));
        this.opener = opener;
        MenuItem protectItem = new MenuItem(Localization.lang("Add {} around selected text", new String[0]));
        protectItem.setOnAction(event -> {
            String selectedText = opener.getSelectedText();
            if (selectedText != null && !selectedText.isEmpty()) {
                opener.replaceSelection("{" + selectedText + "}");
            }
        });
        MenuItem formatItem = new MenuItem(Localization.lang("Format field", new String[0]));
        formatItem.setOnAction(event -> opener.setText(FORMATTER.format(opener.getText())));
        this.externalFiles = new Menu(Localization.lang("Add selected text to list", new String[0]));
        this.updateFiles();
        this.getItems().add((Object)protectItem);
        this.getItems().add((Object)this.externalFiles);
        this.getItems().add((Object)new SeparatorMenuItem());
        this.getItems().add((Object)formatItem);
    }

    private void updateFiles() {
        this.externalFiles.getItems().clear();
        ProtectedTermsLoader loader = Globals.protectedTermsLoader;
        List nonInternal = loader.getProtectedTermsLists().stream().filter(list -> !list.isInternalList()).collect(Collectors.toList());
        for (ProtectedTermsList list2 : nonInternal) {
            MenuItem fileItem = new MenuItem(list2.getDescription());
            fileItem.setOnAction(event -> {
                String selectedText = this.opener.getSelectedText();
                if (selectedText != null && !selectedText.isEmpty()) {
                    list2.addProtectedTerm(selectedText);
                }
            });
            this.externalFiles.getItems().add((Object)fileItem);
        }
        this.externalFiles.getItems().add((Object)new SeparatorMenuItem());
        MenuItem addToNewFileItem = new MenuItem(Localization.lang("New", new String[0]) + "...");
        addToNewFileItem.setOnAction(event -> {
            NewProtectedTermsFileDialog dialog = new NewProtectedTermsFileDialog(JabRefGUI.getMainFrame(), loader);
            SwingUtilities.invokeLater(() -> {
                dialog.setVisible(true);
                if (dialog.isOKPressed()) {
                    Globals.prefs.setProtectedTermsPreferences(loader);
                    this.updateFiles();
                }
            });
        });
        this.externalFiles.getItems().add((Object)addToNewFileItem);
    }
}

