/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.exporter;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.jabref.logic.exporter.Exporter;
import org.jabref.logic.util.StandardFileType;
import org.jabref.logic.xmp.XmpPreferences;
import org.jabref.logic.xmp.XmpUtilWriter;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;

public class XmpExporter
extends Exporter {
    private static final String XMP_SPLIT_PATTERN = "split";
    private final XmpPreferences xmpPreferences;

    public XmpExporter(XmpPreferences xmpPreferences) {
        super("xmp", "Plain XMP", StandardFileType.XMP);
        this.xmpPreferences = xmpPreferences;
    }

    @Override
    public void export(BibDatabaseContext databaseContext, Path file, Charset encoding, List<BibEntry> entries) throws Exception {
        Objects.requireNonNull(databaseContext);
        Objects.requireNonNull(file);
        Objects.requireNonNull(entries);
        if (entries.isEmpty()) {
            return;
        }
        if (file.getFileName().toString().trim().equals(XMP_SPLIT_PATTERN)) {
            for (BibEntry entry : entries) {
                String suffix = entry.getId() + "_" + entry.getCiteKey() + ".xmp";
                Path entryFile = file.getParent() == null ? Paths.get(suffix, new String[0]) : Paths.get(file.getParent().toString() + "/" + suffix, new String[0]);
                this.writeBibToXmp(entryFile, Arrays.asList(entry), encoding);
            }
        } else {
            this.writeBibToXmp(file, entries, encoding);
        }
    }

    private void writeBibToXmp(Path file, List<BibEntry> entries, Charset encoding) throws IOException {
        String xmpContent = XmpUtilWriter.generateXmpStringWithoutXmpDeclaration(entries, this.xmpPreferences);
        try (BufferedWriter writer = Files.newBufferedWriter(file, encoding, new OpenOption[0]);){
            writer.write(xmpContent);
            writer.flush();
        }
    }
}

