/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.integrity;

import java.util.Collections;
import java.util.List;
import org.jabref.logic.integrity.IntegrityCheck;
import org.jabref.logic.integrity.IntegrityMessage;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.EntryTypes;
import org.jabref.model.entry.BibEntry;

public class BibTeXEntryTypeChecker
implements IntegrityCheck.Checker {
    @Override
    public List<IntegrityMessage> check(BibEntry entry) {
        if (EntryTypes.isExclusiveBiblatex(entry.getType())) {
            return Collections.singletonList(new IntegrityMessage(Localization.lang("Entry type %0 is only defined for Biblatex but not for BibTeX", entry.getType()), entry, "bibtexkey"));
        }
        return Collections.emptyList();
    }
}

