/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.l10n;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import org.jabref.logic.l10n.EncodingControl;
import org.jabref.logic.l10n.Languages;
import org.jabref.logic.l10n.LocalizationKey;
import org.jabref.logic.l10n.LocalizationKeyParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Localization {
    public static final String BIBTEX = "BibTeX";
    static final String RESOURCE_PREFIX = "l10n/JabRef";
    static final String MENU_RESOURCE_PREFIX = "l10n/Menu";
    private static final Logger LOGGER = LoggerFactory.getLogger(Localization.class);
    private static Locale locale;
    private static LocalizationBundle localizedMessages;
    private static LocalizationBundle localizedMenuTitles;

    private Localization() {
    }

    public static String lang(String key, String ... params) {
        if (localizedMessages == null) {
            LOGGER.error("Messages are not initialized before accessing " + key);
            Localization.setLanguage("en");
        }
        return Localization.lookup(localizedMessages, "message", key, params);
    }

    public static String menuTitle(String key, String ... params) {
        if (localizedMenuTitles == null) {
            LOGGER.error("Menu entries are not initialized");
            Localization.setLanguage("en");
        }
        return Localization.lookup(localizedMenuTitles, "menu item", key, params);
    }

    public static String menuTitleFX(String key, String ... params) {
        return Localization.menuTitle(key, params).replace("&", "");
    }

    public static void setLanguage(String language2) {
        Optional<Locale> knownLanguage = Languages.convertToSupportedLocale(language2);
        Locale defaultLocale = Locale.getDefault();
        if (!knownLanguage.isPresent()) {
            LOGGER.warn("Language " + language2 + " is not supported by JabRef (Default:" + defaultLocale + ")");
            Localization.setLanguage("en");
            return;
        }
        Locale langLocale = knownLanguage.get();
        if (locale != null && locale.equals(langLocale) && locale.equals(defaultLocale)) {
            return;
        }
        locale = langLocale;
        Locale.setDefault(locale);
        JComponent.setDefaultLocale(locale);
        try {
            Localization.createResourceBundles(locale);
        }
        catch (MissingResourceException ex) {
            LOGGER.warn("Could not find bundles for language " + locale + ", switching to full english language", ex);
            Localization.setLanguage("en");
        }
    }

    public static LocalizationBundle getMessages() {
        if (locale == null) {
            Localization.setLanguage("en");
        }
        return localizedMessages;
    }

    private static void createResourceBundles(Locale locale) {
        ResourceBundle messages = ResourceBundle.getBundle(RESOURCE_PREFIX, locale, new EncodingControl(StandardCharsets.UTF_8));
        ResourceBundle menuTitles = ResourceBundle.getBundle(MENU_RESOURCE_PREFIX, locale, new EncodingControl(StandardCharsets.UTF_8));
        Objects.requireNonNull(messages, "Could not load l10n/JabRef resource.");
        Objects.requireNonNull(menuTitles, "Could not load l10n/Menu resource.");
        localizedMenuTitles = new LocalizationBundle(Localization.createLookupMap(menuTitles));
        localizedMessages = new LocalizationBundle(Localization.createLookupMap(messages, localizedMenuTitles));
    }

    private static HashMap<String, String> createLookupMap(ResourceBundle baseBundle) {
        ArrayList<String> baseKeys = Collections.list(baseBundle.getKeys());
        return new HashMap<String, String>(baseKeys.stream().collect(Collectors.toMap(key -> new LocalizationKey((String)key).getTranslationValue(), key -> new LocalizationKey(baseBundle.getString((String)key)).getTranslationValue())));
    }

    private static HashMap<String, String> createLookupMap(ResourceBundle baseBundle, LocalizationBundle localizedMenuTitles) {
        ArrayList<String> baseKeys = Collections.list(baseBundle.getKeys());
        return new HashMap<String, String>(baseKeys.stream().collect(Collectors.toMap(key -> new LocalizationKey((String)key).getTranslationValue(), key -> {
            String menuTranslationValue = (String)localizedMenuTitles.lookup.get(key);
            String plainTranslationValue = new LocalizationKey(baseBundle.getString((String)key)).getTranslationValue();
            String translationValue = plainTranslationValue.contains("&") && plainTranslationValue.equals(menuTranslationValue) ? plainTranslationValue.replace("&", "") : plainTranslationValue;
            return translationValue;
        })));
    }

    private static String lookup(LocalizationBundle bundle, String idForErrorMessage, String key, String ... params) {
        String translation;
        Objects.requireNonNull(key);
        String string = translation = bundle.containsKey(key) ? bundle.getString(key) : "";
        if (translation.isEmpty()) {
            LOGGER.warn("Warning: could not get " + idForErrorMessage + " translation for \"" + key + "\" for locale " + Locale.getDefault());
            translation = key;
        }
        return new LocalizationKeyParams(translation, params).replacePlaceholders();
    }

    private static class LocalizationBundle
    extends ResourceBundle {
        private final HashMap<String, String> lookup;

        LocalizationBundle(HashMap<String, String> lookupMap) {
            this.lookup = lookupMap;
        }

        @Override
        public final Object handleGetObject(String key) {
            Objects.requireNonNull(key);
            return Optional.ofNullable(this.lookup.get(key)).orElse(key);
        }

        @Override
        public Enumeration<String> getKeys() {
            return Collections.enumeration(this.lookup.keySet());
        }

        @Override
        protected Set<String> handleKeySet() {
            return this.lookup.keySet();
        }

        @Override
        public boolean containsKey(String key) {
            return true;
        }
    }
}

