/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.remote.server;

import java.io.IOException;
import java.net.BindException;
import org.jabref.JabRefExecutorService;
import org.jabref.logic.remote.server.MessageHandler;
import org.jabref.logic.remote.server.RemoteListenerServerThread;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteListenerServerLifecycle
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteListenerServerLifecycle.class);
    private RemoteListenerServerThread remoteListenerServerThread;

    public void stop() {
        if (this.isOpen()) {
            this.remoteListenerServerThread.interrupt();
            this.remoteListenerServerThread = null;
            JabRefExecutorService.INSTANCE.stopRemoteThread();
        }
    }

    public void open(MessageHandler messageHandler, int port) {
        RemoteListenerServerThread result;
        if (this.isOpen()) {
            return;
        }
        try {
            result = new RemoteListenerServerThread(messageHandler, port);
        }
        catch (BindException e) {
            LOGGER.warn("Port is blocked", e);
            result = null;
        }
        catch (IOException e) {
            result = null;
        }
        this.remoteListenerServerThread = result;
    }

    public boolean isOpen() {
        return this.remoteListenerServerThread != null;
    }

    public void start() {
        if (this.isOpen() && this.isNotStartedBefore()) {
            JabRefExecutorService.INSTANCE.manageRemoteThread(this.remoteListenerServerThread);
        }
    }

    public boolean isNotStartedBefore() {
        return this.remoteListenerServerThread == null || this.remoteListenerServerThread.getState() == Thread.State.NEW;
    }

    public void openAndStart(MessageHandler messageHandler, int port) {
        this.open(messageHandler, port);
        this.start();
    }

    @Override
    public void close() {
        this.stop();
    }
}

