/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jabref.model.database.BibDatabaseMode;
import org.jabref.model.entry.BiblatexEntryTypes;
import org.jabref.model.entry.BibtexEntryTypes;
import org.jabref.model.entry.CustomEntryType;
import org.jabref.model.entry.EntryType;
import org.jabref.model.entry.IEEETranEntryTypes;

public class EntryTypes {
    public static final InternalEntryTypes BIBTEX = new InternalEntryTypes(BibtexEntryTypes.MISC, Arrays.asList(BibtexEntryTypes.ALL, IEEETranEntryTypes.ALL));
    public static final InternalEntryTypes BIBLATEX = new InternalEntryTypes(BiblatexEntryTypes.MISC, Arrays.asList(BiblatexEntryTypes.ALL));

    private EntryTypes() {
    }

    public static Optional<EntryType> getType(String name, BibDatabaseMode type) {
        return type == BibDatabaseMode.BIBLATEX ? BIBLATEX.getType(name) : BIBTEX.getType(name);
    }

    public static EntryType getTypeOrDefault(String name, BibDatabaseMode mode) {
        return mode == BibDatabaseMode.BIBLATEX ? BIBLATEX.getTypeOrDefault(name) : BIBTEX.getTypeOrDefault(name);
    }

    public static Optional<EntryType> getStandardType(String name, BibDatabaseMode mode) {
        return mode == BibDatabaseMode.BIBLATEX ? BIBLATEX.getStandardType(name) : BIBTEX.getStandardType(name);
    }

    public static void addOrModifyCustomEntryType(CustomEntryType customEntryType, BibDatabaseMode mode) {
        if (BibDatabaseMode.BIBLATEX == mode) {
            EntryTypes.BIBLATEX.addOrModifyEntryType(customEntryType);
        } else if (BibDatabaseMode.BIBTEX == mode) {
            EntryTypes.BIBTEX.addOrModifyEntryType(customEntryType);
        }
    }

    public static Set<String> getAllTypes(BibDatabaseMode type) {
        return type == BibDatabaseMode.BIBLATEX ? BIBLATEX.getAllTypes() : BIBTEX.getAllTypes();
    }

    public static Collection<EntryType> getAllValues(BibDatabaseMode type) {
        return type == BibDatabaseMode.BIBLATEX ? BIBLATEX.getAllValues() : BIBTEX.getAllValues();
    }

    public static List<EntryType> getAllCustomTypes(BibDatabaseMode mode) {
        Collection<EntryType> allTypes = EntryTypes.getAllValues(mode);
        if (mode == BibDatabaseMode.BIBTEX) {
            return allTypes.stream().filter(entryType -> !BibtexEntryTypes.getType(entryType.getName()).isPresent()).filter(entryType -> !IEEETranEntryTypes.getType(entryType.getName()).isPresent()).collect(Collectors.toList());
        }
        return allTypes.stream().filter(entryType -> !BiblatexEntryTypes.getType(entryType.getName()).isPresent()).collect(Collectors.toList());
    }

    public static List<EntryType> getAllModifiedStandardTypes(BibDatabaseMode mode) {
        if (mode == BibDatabaseMode.BIBTEX) {
            return EntryTypes.getAllModifiedStandardTypes(BIBTEX);
        }
        return EntryTypes.getAllModifiedStandardTypes(BIBLATEX);
    }

    private static List<EntryType> getAllModifiedStandardTypes(InternalEntryTypes internalTypes) {
        return internalTypes.getAllValues().stream().filter(type -> type instanceof CustomEntryType).filter(type -> internalTypes.getStandardType(type.getName()).isPresent()).collect(Collectors.toList());
    }

    public static void removeType(String name, BibDatabaseMode type) {
        if (type == BibDatabaseMode.BIBLATEX) {
            BIBLATEX.removeType(name);
        } else {
            BIBTEX.removeType(name);
        }
    }

    public static void removeAllCustomEntryTypes() {
        for (BibDatabaseMode type : BibDatabaseMode.values()) {
            for (String typeName : new HashSet<String>(EntryTypes.getAllTypes(type))) {
                EntryTypes.getType(typeName, type).ifPresent(entryType -> {
                    if (entryType instanceof CustomEntryType) {
                        EntryTypes.removeType(typeName, type);
                    }
                });
            }
        }
    }

    public static void loadCustomEntryTypes(List<CustomEntryType> customBibtexEntryTypes, List<CustomEntryType> customBiblatexEntryTypes) {
        for (CustomEntryType type : customBibtexEntryTypes) {
            EntryTypes.addOrModifyCustomEntryType(type, BibDatabaseMode.BIBTEX);
        }
        for (CustomEntryType type : customBiblatexEntryTypes) {
            EntryTypes.addOrModifyCustomEntryType(type, BibDatabaseMode.BIBLATEX);
        }
    }

    public static boolean isEqualNameAndFieldBased(EntryType type1, EntryType type2) {
        if (type1 == null && type2 == null) {
            return true;
        }
        if (type1 == null || type2 == null) {
            return false;
        }
        return type1.getName().equals(type2.getName()) && type1.getRequiredFields().equals(type2.getRequiredFields()) && type1.getOptionalFields().equals(type2.getOptionalFields()) && type1.getSecondaryOptionalFields().equals(type2.getSecondaryOptionalFields());
    }

    public static boolean isExclusiveBiblatex(String type) {
        return EntryTypes.filterEntryTypesNames(BiblatexEntryTypes.ALL, EntryTypes.isNotIncludedIn(BibtexEntryTypes.ALL)).contains(type.toLowerCase(Locale.ROOT));
    }

    private static List<String> filterEntryTypesNames(List<EntryType> types, Predicate<EntryType> predicate) {
        return types.stream().filter(predicate).map(type -> type.getName().toLowerCase(Locale.ROOT)).collect(Collectors.toList());
    }

    private static Predicate<EntryType> isNotIncludedIn(List<EntryType> collection) {
        return entry -> collection.stream().noneMatch(c -> c.getName().equalsIgnoreCase(entry.getName()));
    }

    private static class InternalEntryTypes {
        private final Map<String, EntryType> ALL_TYPES = new TreeMap<String, EntryType>();
        private final Map<String, EntryType> STANDARD_TYPES;
        private final EntryType defaultType;

        public InternalEntryTypes(EntryType defaultType, List<List<EntryType>> entryTypes) {
            this.defaultType = defaultType;
            for (List<EntryType> list : entryTypes) {
                for (EntryType type : list) {
                    this.ALL_TYPES.put(type.getName().toLowerCase(Locale.ROOT), type);
                }
            }
            this.STANDARD_TYPES = new TreeMap<String, EntryType>(this.ALL_TYPES);
        }

        public Optional<EntryType> getType(String name) {
            return Optional.ofNullable(this.ALL_TYPES.get(name.toLowerCase(Locale.ROOT)));
        }

        public EntryType getTypeOrDefault(String type) {
            return this.getType(type).orElse(this.defaultType);
        }

        public Optional<EntryType> getStandardType(String name) {
            return Optional.ofNullable(this.STANDARD_TYPES.get(name.toLowerCase(Locale.ROOT)));
        }

        private void addOrModifyEntryType(EntryType type) {
            this.ALL_TYPES.put(type.getName().toLowerCase(Locale.ROOT), type);
        }

        public Set<String> getAllTypes() {
            return this.ALL_TYPES.keySet();
        }

        public Collection<EntryType> getAllValues() {
            return this.ALL_TYPES.values();
        }

        public void removeType(String name) {
            String toLowerCase = name.toLowerCase(Locale.ROOT);
            if (!this.ALL_TYPES.get(toLowerCase).equals(this.STANDARD_TYPES.get(toLowerCase))) {
                this.ALL_TYPES.remove(toLowerCase);
                if (this.STANDARD_TYPES.containsKey(toLowerCase)) {
                    this.addOrModifyEntryType(this.STANDARD_TYPES.get(toLowerCase));
                }
            }
        }
    }
}

