/*
 * Decompiled with CFR 0.152.
 */
package org.reactfx.util;

import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.reactfx.util.Either;
import org.reactfx.util.Failure;
import org.reactfx.util.Success;

public interface Try<T>
extends Either<Throwable, T> {
    public static <T> Try<T> success(T value) {
        return new Success<T>(value);
    }

    public static <T> Try<T> failure(Throwable thrown) {
        return new Failure(thrown);
    }

    public static <T> Try<T> tryGet(Callable<? extends T> f) {
        try {
            return Try.success(f.call());
        }
        catch (Throwable t) {
            return Try.failure(t);
        }
    }

    default public boolean isSuccess() {
        return this.isRight();
    }

    default public boolean isFailure() {
        return this.isLeft();
    }

    default public T get() {
        return (T)this.getRight();
    }

    default public Throwable getFailure() {
        return (Throwable)this.getLeft();
    }

    default public Optional<T> toOptional() {
        return this.asRight();
    }

    default public void ifSuccess(Consumer<? super T> f) {
        this.ifRight(f);
    }

    default public void ifFailure(Consumer<? super Throwable> f) {
        this.ifLeft(f);
    }

    public T getOrElse(T var1);

    public T getOrElse(Supplier<T> var1);

    public Try<T> orElse(Try<T> var1);

    public Try<T> orElse(Supplier<Try<T>> var1);

    public Try<T> orElseTry(Callable<? extends T> var1);

    public Try<T> recover(Function<Throwable, Optional<T>> var1);

    public <U> Try<U> map(Function<? super T, ? extends U> var1);

    public <U> Try<U> flatMap(Function<? super T, Try<U>> var1);
}

