/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs.options;

import com.sun.electric.database.text.Setting;
import com.sun.electric.technology.Foundry;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.tool.io.output.GenerateVHDL;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.dialogs.PreferencesFrame;
import com.sun.electric.tool.user.dialogs.options.PreferencePanel;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class TechnologyTab
extends PreferencePanel {
    public static final int MOCMOS_SCMOSRULES = 0;
    public static final int MOCMOS_SUBMRULES = 1;
    public static final int MOCMOS_DEEPRULES = 2;
    private ArrayList<Object> extraTechTabs = new ArrayList();
    private JList schemPrimList;
    private DefaultListModel schemPrimModel;
    private Map<PrimitiveNode, String> schemPrimMap;
    private boolean changingVHDL = false;
    private Setting defaultTechnologySetting = User.getDefaultTechnologySetting();
    private Setting schematicTechnologySetting = User.getSchematicTechnologySetting();
    private Setting processLayoutTechnologySetting = User.getPSubstrateProcessLayoutTechnologySetting();
    private Technology mocmos = Technology.getMocmosTechnology();
    private Setting mocmosRuleSetSetting = this.mocmos.getSetting("MOCMOS Rule Set");
    private Setting mocmosNumMetalSetting = this.mocmos.getSetting("NumMetalLayers");
    private Setting mocmosSecondPolysiliconSetting = this.mocmos.getSetting("UseSecondPolysilicon");
    private Setting mocmosDisallowStackedViasSetting = this.mocmos.getSetting("DisallowStackedVias");
    private Setting mocmosAlternateActivePolyRulesSetting = this.mocmos.getSetting("UseAlternativeActivePolyRules");
    private Setting mocmosAnalogSetting = this.mocmos.getSetting("Analog");
    private JPanel cmos90Panel;
    private JLabel defaultTechLabel;
    private JComboBox defaultTechPulldown;
    private JPanel defaultsPanel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel59;
    private JSeparator jSeparator1;
    private ButtonGroup mocmosGroup;
    private JPanel mosisPanel;
    private JPanel preferences;
    private JPanel projectSettings;
    private JCheckBox rotateLayoutTransistors;
    private JCheckBox techMOCMOSAlternateContactRules;
    private JCheckBox techMOCMOSAnalog;
    private JRadioButton techMOCMOSDeepRules;
    private JCheckBox techMOCMOSDisallowStackedVias;
    private JRadioButton techMOCMOSSCMOSRules;
    private JCheckBox techMOCMOSSecondPoly;
    private JRadioButton techMOCMOSSubmicronRules;
    private JLabel techMetalLabel;
    private JComboBox techMetalLayers;
    private JComboBox technologyPopup;
    private JCheckBox technologyProcess;
    private JPanel tsmc180Panel;
    private JTextField vhdlName;
    private JTextField vhdlNegatedName;
    private JScrollPane vhdlPrimPane;

    public TechnologyTab(PreferencesFrame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        EDialog.makeTextFieldSelectAllOnTab(this.vhdlName);
        EDialog.makeTextFieldSelectAllOnTab(this.vhdlNegatedName);
    }

    @Override
    public JPanel getUserPreferencesPanel() {
        return this.preferences;
    }

    @Override
    public JPanel getProjectPreferencesPanel() {
        return this.projectSettings;
    }

    @Override
    public String getName() {
        return "Technology";
    }

    @Override
    public void init() {
        this.rotateLayoutTransistors.setSelected(User.isRotateLayoutTransistors());
        this.schemPrimModel = new DefaultListModel();
        this.schemPrimList = new JList(this.schemPrimModel);
        this.schemPrimList.setSelectionMode(0);
        this.vhdlPrimPane.setViewportView(this.schemPrimList);
        this.schemPrimList.clearSelection();
        this.schemPrimList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                TechnologyTab.this.schemClickPrim();
            }
        });
        this.schemPrimModel.clear();
        this.schemPrimMap = new HashMap<PrimitiveNode, String>();
        GenerateVHDL.VHDLPreferences vp = new GenerateVHDL.VHDLPreferences(false);
        Iterator<PrimitiveNode> it = Schematics.tech().getNodes();
        while (it.hasNext()) {
            PrimitiveNode np = it.next();
            if (np != Schematics.tech().andNode && np != Schematics.tech().orNode && np != Schematics.tech().xorNode && np != Schematics.tech().muxNode && np != Schematics.tech().bufferNode) continue;
            String str = vp.vhdlNames.get(np);
            this.schemPrimMap.put(np, str);
            this.schemPrimModel.addElement(this.makeLine(np, str));
        }
        this.schemPrimList.setSelectedIndex(0);
        this.vhdlName.getDocument().addDocumentListener(new SchemPrimDocumentListener(this));
        this.vhdlNegatedName.getDocument().addDocumentListener(new SchemPrimDocumentListener(this));
        this.schemClickPrim();
        int initialTechRules = this.getInt(this.mocmosRuleSetSetting);
        if (initialTechRules == 0) {
            this.techMOCMOSSCMOSRules.setSelected(true);
        } else if (initialTechRules == 1) {
            this.techMOCMOSSubmicronRules.setSelected(true);
        } else {
            this.techMOCMOSDeepRules.setSelected(true);
        }
        this.techMetalLayers.addItem("2 Layers");
        this.techMetalLayers.addItem("3 Layers");
        this.techMetalLayers.addItem("4 Layers");
        this.techMetalLayers.addItem("5 Layers");
        this.techMetalLayers.addItem("6 Layers");
        this.techMetalLayers.setSelectedIndex(this.getInt(this.mocmosNumMetalSetting) - 2);
        this.techMOCMOSSecondPoly.setSelected(this.getBoolean(this.mocmosSecondPolysiliconSetting));
        this.techMOCMOSDisallowStackedVias.setSelected(this.getBoolean(this.mocmosDisallowStackedViasSetting));
        this.techMOCMOSAlternateContactRules.setSelected(this.getBoolean(this.mocmosAlternateActivePolyRulesSetting));
        this.techMOCMOSAnalog.setSelected(this.getBoolean(this.mocmosAnalogSetting));
        Iterator<Technology> it2 = Technology.getTechnologies();
        while (it2.hasNext()) {
            Technology tech = it2.next();
            this.defaultTechPulldown.addItem(tech.getTechName());
            if (!tech.isScaleRelevant()) continue;
            this.technologyPopup.addItem(tech.getTechName());
        }
        this.defaultTechPulldown.setSelectedItem(this.getString(this.defaultTechnologySetting));
        this.technologyPopup.setSelectedItem(User.getSchematicTechnology().getTechName());
        this.technologyProcess.setSelected(this.processLayoutTechnologySetting.getBoolean());
        this.initExtraTab("com.sun.electric.plugins.tsmc.CMOS90Tab", this.cmos90Panel);
        this.initExtraTab("com.sun.electric.plugins.tsmc.TSMC180Tab", this.tsmc180Panel);
    }

    @Override
    public void term() {
        boolean redrawWindows = false;
        boolean redrawMenus = false;
        boolean currentRotateTransistors = this.rotateLayoutTransistors.isSelected();
        if (currentRotateTransistors != User.isRotateLayoutTransistors()) {
            User.setRotateLayoutTransistors(currentRotateTransistors);
            redrawMenus = true;
        }
        GenerateVHDL.VHDLPreferences vp = new GenerateVHDL.VHDLPreferences(false);
        for (int i = 0; i < this.schemPrimModel.size(); ++i) {
            String str = (String)this.schemPrimModel.get(i);
            int spacePos = str.indexOf(32);
            if (spacePos < 0) continue;
            String primName = str.substring(0, spacePos);
            PrimitiveNode np = Schematics.tech().findNodeProto(primName);
            if (np == null) continue;
            String newVHDLname = str.substring(spacePos + 3, str.length() - 1);
            vp.vhdlNames.put(np, newVHDLname);
        }
        this.putPrefs(vp);
        int currentNumMetals = this.techMetalLayers.getSelectedIndex() + 2;
        int currentRules = 0;
        if (this.techMOCMOSSubmicronRules.isSelected()) {
            currentRules = 1;
        } else if (this.techMOCMOSDeepRules.isSelected()) {
            currentRules = 2;
        }
        boolean secondPoly = this.techMOCMOSSecondPoly.isSelected();
        boolean alternateContactRules = this.techMOCMOSAlternateContactRules.isSelected();
        if (this.techMOCMOSAnalog.isSelected() && (currentRules == 2 || !secondPoly || alternateContactRules)) {
            JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "The Analog setting requires 2 polys, SCM or SUB rules and no alternate contact rules... making these changes with SUB rules");
            this.techMOCMOSSubmicronRules.setSelected(true);
            this.techMOCMOSSecondPoly.setSelected(true);
            this.techMOCMOSAlternateContactRules.setSelected(true);
            currentRules = 1;
            secondPoly = true;
            alternateContactRules = false;
        }
        switch (currentNumMetals) {
            case 2: 
            case 3: 
            case 4: {
                if (currentRules != 2) break;
                JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "Cannot use Deep rules if there are less than 5 layers of metal...using SubMicron rules.");
                currentRules = 1;
                break;
            }
            case 5: 
            case 6: {
                if (currentRules != 0) break;
                JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "Cannot use SCMOS rules if there are more than 4 layers of metal...using SubMicron rules.");
                currentRules = 1;
            }
        }
        this.setInt(this.mocmosNumMetalSetting, currentNumMetals);
        this.setInt(this.mocmosRuleSetSetting, currentRules);
        this.setBoolean(this.mocmosSecondPolysiliconSetting, secondPoly);
        this.setBoolean(this.mocmosDisallowStackedViasSetting, this.techMOCMOSDisallowStackedVias.isSelected());
        this.setBoolean(this.mocmosAlternateActivePolyRulesSetting, alternateContactRules);
        this.setBoolean(this.mocmosAnalogSetting, this.techMOCMOSAnalog.isSelected());
        String currentTechName = (String)this.technologyPopup.getSelectedItem();
        if (Technology.findTechnology(currentTechName) != null) {
            this.setString(this.schematicTechnologySetting, currentTechName);
        }
        this.setString(this.defaultTechnologySetting, (String)this.defaultTechPulldown.getSelectedItem());
        boolean currentV = this.technologyProcess.isSelected();
        if (currentV != this.processLayoutTechnologySetting.getBoolean()) {
            this.setBoolean(this.processLayoutTechnologySetting, currentV);
            Technology.getCurrent().setCachedRules(null);
        }
        for (Object extraTechTab : this.extraTechTabs) {
            try {
                extraTechTab.getClass().getMethod("term", new Class[0]).invoke(extraTechTab, new Object[0]);
            }
            catch (Exception e) {
                System.out.println("Exceptions while closing extra technologies: " + e.getMessage());
            }
        }
        if (redrawMenus) {
            Technology tech = Technology.getCurrent();
            Iterator<WindowFrame> it = WindowFrame.getWindows();
            while (it.hasNext()) {
                WindowFrame wf = it.next();
                wf.getPaletteTab().loadForTechnology(tech, wf);
            }
        }
        if (redrawWindows) {
            EditWindow.repaintAllContents();
        }
    }

    @Override
    public void reset() {
        if (User.isFactoryRotateLayoutTransistors() != User.isRotateLayoutTransistors()) {
            User.setRotateLayoutTransistors(User.isFactoryRotateLayoutTransistors());
        }
        this.putPrefs(new GenerateVHDL.VHDLPreferences(true));
        this.setString(this.schematicTechnologySetting, (String)this.schematicTechnologySetting.getFactoryValue());
        this.setString(this.defaultTechnologySetting, (String)this.defaultTechnologySetting.getFactoryValue());
        this.setBoolean(this.processLayoutTechnologySetting, (Boolean)this.processLayoutTechnologySetting.getFactoryValue());
        this.setInt(this.mocmosNumMetalSetting, (Integer)this.mocmosNumMetalSetting.getFactoryValue());
        this.setInt(this.mocmosRuleSetSetting, (Integer)this.mocmosRuleSetSetting.getFactoryValue());
        this.setBoolean(this.mocmosSecondPolysiliconSetting, (Boolean)this.mocmosSecondPolysiliconSetting.getFactoryValue());
        this.setBoolean(this.mocmosDisallowStackedViasSetting, (Boolean)this.mocmosDisallowStackedViasSetting.getFactoryValue());
        this.setBoolean(this.mocmosAlternateActivePolyRulesSetting, (Boolean)this.mocmosAlternateActivePolyRulesSetting.getFactoryValue());
        this.setBoolean(this.mocmosAnalogSetting, (Boolean)this.mocmosAnalogSetting.getFactoryValue());
        for (Object extraTechTab : this.extraTechTabs) {
            try {
                extraTechTab.getClass().getMethod("reset", new Class[0]).invoke(extraTechTab, new Object[0]);
            }
            catch (Exception e) {
                System.out.println("Exceptions while resetting extra technologies: " + e.getMessage());
            }
        }
    }

    private void initExtraTab(String className, JPanel panel) {
        try {
            Class<?> extraTechClass = Class.forName(className);
            Object extraTechTab = extraTechClass.getConstructor(TechnologyTab.class, JPanel.class).newInstance(this, panel);
            this.extraTechTabs.add(extraTechTab);
        }
        catch (Exception e) {
            this.projectSettings.remove(panel);
        }
    }

    private String makeLine(PrimitiveNode np, String vhdlName) {
        return np.getName() + "  (" + vhdlName + ")";
    }

    private void schemClickPrim() {
        this.changingVHDL = true;
        PrimitiveNode np = this.getSelectedPrim();
        if (np == null) {
            return;
        }
        String vhdlNames = this.schemPrimMap.get(np);
        int slashPos = vhdlNames.indexOf(47);
        if (slashPos < 0) {
            this.vhdlName.setText(vhdlNames);
            this.vhdlNegatedName.setText("");
        } else {
            this.vhdlName.setText(vhdlNames.substring(0, slashPos));
            this.vhdlNegatedName.setText(vhdlNames.substring(slashPos + 1));
        }
        this.changingVHDL = false;
    }

    private PrimitiveNode getSelectedPrim() {
        String str = (String)this.schemPrimList.getSelectedValue();
        int spacePos = str.indexOf(32);
        if (spacePos >= 0) {
            str = str.substring(0, spacePos);
        }
        PrimitiveNode np = Schematics.tech().findNodeProto(str);
        return np;
    }

    private void primVHDLChanged() {
        PrimitiveNode np;
        if (this.changingVHDL) {
            return;
        }
        String str = this.vhdlName.getText();
        String strNot = this.vhdlNegatedName.getText();
        String vhdl = "";
        if (str.length() > 0 || strNot.length() > 0) {
            vhdl = str + "/" + strNot;
        }
        if ((np = this.getSelectedPrim()) == null) {
            return;
        }
        this.schemPrimMap.put(np, vhdl);
        int index = this.schemPrimList.getSelectedIndex();
        this.schemPrimModel.set(index, this.makeLine(np, vhdl));
    }

    public Foundry.Type setFoundrySelected(Technology tech, JComboBox pulldown) {
        String selectedFoundry = this.getString(tech.getPrefFoundrySetting());
        Foundry.Type foundry = Foundry.Type.NONE;
        Iterator<Foundry> itF = tech.getFoundries();
        while (itF.hasNext()) {
            Foundry factory = itF.next();
            Foundry.Type type = factory.getType();
            pulldown.addItem(type);
            if (!selectedFoundry.equalsIgnoreCase(factory.getType().getName())) continue;
            foundry = type;
        }
        pulldown.setEnabled(foundry != Foundry.Type.NONE);
        pulldown.setSelectedItem(foundry);
        return foundry;
    }

    public boolean checkFoundry(Foundry.Type foundry, Technology tech) {
        if (foundry == null) {
            return false;
        }
        boolean changed = false;
        if (!foundry.getName().equalsIgnoreCase(this.getString(tech.getPrefFoundrySetting()))) {
            changed = true;
            String[] messages = new String[]{tech.getTechShortName() + " primitives in database might be resized according to values provided by " + foundry + ".", "If you do not resize now, arc widths might not be optimal for " + foundry + ".", "If you cancel the operation, the foundry will not be changed.", "Do you want to resize the database?"};
            Object[] options = new Object[]{"Yes", "No", "Cancel"};
            int val = JOptionPane.showOptionDialog(TopLevel.getCurrentJFrame(), messages, "Resize primitive Nodes and Arcs", -1, 2, null, options, options[0]);
            if (val != 2) {
                this.setString(tech.getPrefFoundrySetting(), foundry.getName());
            }
        }
        return changed;
    }

    private void initComponents() {
        this.mocmosGroup = new ButtonGroup();
        this.preferences = new JPanel();
        this.vhdlPrimPane = new JScrollPane();
        this.jLabel2 = new JLabel();
        this.vhdlName = new JTextField();
        this.jLabel3 = new JLabel();
        this.vhdlNegatedName = new JTextField();
        this.rotateLayoutTransistors = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.projectSettings = new JPanel();
        this.defaultsPanel = new JPanel();
        this.defaultTechLabel = new JLabel();
        this.defaultTechPulldown = new JComboBox();
        this.jLabel59 = new JLabel();
        this.technologyPopup = new JComboBox();
        this.technologyProcess = new JCheckBox();
        this.mosisPanel = new JPanel();
        this.techMetalLabel = new JLabel();
        this.techMetalLayers = new JComboBox();
        this.techMOCMOSSCMOSRules = new JRadioButton();
        this.techMOCMOSSubmicronRules = new JRadioButton();
        this.techMOCMOSDeepRules = new JRadioButton();
        this.techMOCMOSSecondPoly = new JCheckBox();
        this.techMOCMOSDisallowStackedVias = new JCheckBox();
        this.techMOCMOSAlternateContactRules = new JCheckBox();
        this.techMOCMOSAnalog = new JCheckBox();
        this.cmos90Panel = new JPanel();
        this.tsmc180Panel = new JPanel();
        this.setTitle("Edit Options");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                TechnologyTab.this.closeDialog(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.preferences.setLayout(new GridBagLayout());
        this.vhdlPrimPane.setMinimumSize(new Dimension(22, 70));
        this.vhdlPrimPane.setPreferredSize(new Dimension(22, 70));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.preferences.add((Component)this.vhdlPrimPane, gridBagConstraints);
        this.jLabel2.setText("VHDL for primitive:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.preferences.add((Component)this.jLabel2, gridBagConstraints);
        this.vhdlName.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.preferences.add((Component)this.vhdlName, gridBagConstraints);
        this.jLabel3.setText("VHDL for negated primitive:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 4, 4);
        this.preferences.add((Component)this.jLabel3, gridBagConstraints);
        this.vhdlNegatedName.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(2, 4, 4, 4);
        this.preferences.add((Component)this.vhdlNegatedName, gridBagConstraints);
        this.rotateLayoutTransistors.setText("Rotate layout transistors in menu");
        this.rotateLayoutTransistors.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 4, 4);
        this.preferences.add((Component)this.rotateLayoutTransistors, gridBagConstraints);
        this.jLabel1.setText("Schematic primitives:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.preferences.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.preferences.add((Component)this.jSeparator1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        this.getContentPane().add((Component)this.preferences, gridBagConstraints);
        this.projectSettings.setLayout(new GridBagLayout());
        this.defaultsPanel.setBorder(BorderFactory.createTitledBorder("Defaults"));
        this.defaultsPanel.setLayout(new GridBagLayout());
        this.defaultTechLabel.setText("Startup technology:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 2, 4);
        this.defaultsPanel.add((Component)this.defaultTechLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 2, 4);
        this.defaultsPanel.add((Component)this.defaultTechPulldown, gridBagConstraints);
        this.jLabel59.setText("Layout technology to use for Schematics:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.defaultsPanel.add((Component)this.jLabel59, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.defaultsPanel.add((Component)this.technologyPopup, gridBagConstraints);
        this.technologyProcess.setText("PSubstrate process in Layout Technology");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 4, 4, 4);
        this.defaultsPanel.add((Component)this.technologyProcess, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        this.projectSettings.add((Component)this.defaultsPanel, gridBagConstraints);
        this.mosisPanel.setBorder(BorderFactory.createTitledBorder("mocmos Technology"));
        this.mosisPanel.setLayout(new GridBagLayout());
        this.techMetalLabel.setText("Metal layers:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.mosisPanel.add((Component)this.techMetalLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.mosisPanel.add((Component)this.techMetalLayers, gridBagConstraints);
        this.mocmosGroup.add(this.techMOCMOSSCMOSRules);
        this.techMOCMOSSCMOSRules.setText("SCMOS rules (4 metal or less)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 1, 4);
        this.mosisPanel.add((Component)this.techMOCMOSSCMOSRules, gridBagConstraints);
        this.mocmosGroup.add(this.techMOCMOSSubmicronRules);
        this.techMOCMOSSubmicronRules.setText("Submicron rules");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 4, 1, 4);
        this.mosisPanel.add((Component)this.techMOCMOSSubmicronRules, gridBagConstraints);
        this.mocmosGroup.add(this.techMOCMOSDeepRules);
        this.techMOCMOSDeepRules.setText("Deep rules (5 metal or more)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 4, 4, 4);
        this.mosisPanel.add((Component)this.techMOCMOSDeepRules, gridBagConstraints);
        this.techMOCMOSSecondPoly.setText("Second Polysilicon Layer");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 1, 4);
        this.mosisPanel.add((Component)this.techMOCMOSSecondPoly, gridBagConstraints);
        this.techMOCMOSDisallowStackedVias.setText("Disallow stacked vias");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 4, 1, 4);
        this.mosisPanel.add((Component)this.techMOCMOSDisallowStackedVias, gridBagConstraints);
        this.techMOCMOSAlternateContactRules.setText("Alternate Active and Poly contact rules");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 4, 1, 4);
        this.mosisPanel.add((Component)this.techMOCMOSAlternateContactRules, gridBagConstraints);
        this.techMOCMOSAnalog.setText("Analog");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 4, 4, 4);
        this.mosisPanel.add((Component)this.techMOCMOSAnalog, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.anchor = 11;
        this.projectSettings.add((Component)this.mosisPanel, gridBagConstraints);
        this.cmos90Panel.setBorder(BorderFactory.createTitledBorder(""));
        this.cmos90Panel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        this.projectSettings.add((Component)this.cmos90Panel, gridBagConstraints);
        this.tsmc180Panel.setBorder(BorderFactory.createTitledBorder(""));
        this.tsmc180Panel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        this.projectSettings.add((Component)this.tsmc180Panel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.getContentPane().add((Component)this.projectSettings, gridBagConstraints);
        this.pack();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private static class SchemPrimDocumentListener
    implements DocumentListener {
        TechnologyTab dialog;

        SchemPrimDocumentListener(TechnologyTab dialog) {
            this.dialog = dialog;
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.dialog.primVHDLChanged();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.dialog.primVHDLChanged();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.dialog.primVHDLChanged();
        }
    }
}

