/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.servlet;

import com.google.inject.AbstractModule;
import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import com.google.inject.internal.Lists;
import com.google.inject.internal.Sets;
import com.google.inject.internal.UniqueAnnotations;
import com.google.inject.servlet.ServletDefinition;
import com.google.inject.servlet.ServletModule;
import com.google.inject.servlet.UriPatternType;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServlet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ServletsModuleBuilder
extends AbstractModule {
    private final List<ServletDefinition> servletDefinitions = Lists.newArrayList();

    ServletsModuleBuilder() {
    }

    @Override
    protected void configure() {
        HashSet<String> servletUris = Sets.newHashSet();
        for (ServletDefinition servletDefinition : this.servletDefinitions) {
            if (servletUris.contains(servletDefinition.getPattern())) {
                this.addError("More than one servlet was mapped to the same URI pattern: " + servletDefinition.getPattern(), new Object[0]);
                continue;
            }
            servletUris.add(servletDefinition.getPattern());
        }
        this.bind(Key.get(new TypeLiteral<List<ServletDefinition>>(){}, UniqueAnnotations.create())).toInstance(this.servletDefinitions);
    }

    public ServletModule.ServletKeyBindingBuilder serve(List<String> urlPatterns) {
        return new ServletKeyBindingBuilderImpl(urlPatterns, UriPatternType.SERVLET);
    }

    public ServletModule.ServletKeyBindingBuilder serveRegex(List<String> regexes) {
        return new ServletKeyBindingBuilderImpl(regexes, UriPatternType.REGEX);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ServletKeyBindingBuilderImpl
    implements ServletModule.ServletKeyBindingBuilder {
        private final List<String> uriPatterns;
        private final UriPatternType uriPatternType;

        private ServletKeyBindingBuilderImpl(List<String> uriPatterns, UriPatternType uriPatternType) {
            this.uriPatterns = uriPatterns;
            this.uriPatternType = uriPatternType;
        }

        @Override
        public void with(Class<? extends HttpServlet> servletKey) {
            this.with(Key.get(servletKey));
        }

        @Override
        public void with(Key<? extends HttpServlet> servletKey) {
            this.with(servletKey, new HashMap<String, String>());
        }

        @Override
        public void with(Class<? extends HttpServlet> servletKey, Map<String, String> contextParams) {
            this.with(Key.get(servletKey), contextParams);
        }

        @Override
        public void with(Key<? extends HttpServlet> servletKey, Map<String, String> contextParams) {
            for (String pattern : this.uriPatterns) {
                ServletsModuleBuilder.this.servletDefinitions.add(new ServletDefinition(pattern, servletKey, UriPatternType.get(this.uriPatternType, pattern), contextParams));
            }
        }
    }
}

