/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.google.jstestdriver.FileInfo;
import com.google.jstestdriver.FileLoader;
import com.google.jstestdriver.FileReader;
import com.google.jstestdriver.hooks.FileLoadPostProcessor;
import com.google.jstestdriver.util.StopWatch;
import java.io.File;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessingFileLoader
implements FileLoader {
    private final FileReader reader;
    private final Set<FileLoadPostProcessor> postprocessors;
    private final File basePath;
    private final StopWatch stopWatch;

    @Inject
    public ProcessingFileLoader(FileReader reader, Set<FileLoadPostProcessor> postprocessors, @Named(value="basePath") File basePath, StopWatch stopWatch) {
        this.reader = reader;
        this.postprocessors = postprocessors;
        this.basePath = basePath;
        this.stopWatch = stopWatch;
    }

    @Override
    public List<FileInfo> loadFiles(Collection<FileInfo> filesToLoad, boolean shouldReset) {
        LinkedList<FileInfo> processed = new LinkedList<FileInfo>();
        LinkedList<FileInfo> loaded = new LinkedList<FileInfo>();
        this.stopWatch.start("preProcessFiles", new Object[0]);
        LinkedList<FileInfo> preProcessedFiles = new LinkedList<FileInfo>(filesToLoad);
        this.stopWatch.stop("preProcessFiles", new Object[0]);
        this.stopWatch.start("loadFile", new Object[0]);
        for (FileInfo file : preProcessedFiles) {
            loaded.add(file.loadFile(this.reader, this.basePath));
        }
        this.stopWatch.stop("loadFile", new Object[0]);
        this.stopWatch.start("postProcessFile", new Object[0]);
        for (FileInfo file : loaded) {
            processed.add(this.postProcessFile(file));
        }
        this.stopWatch.stop("postProcessFile", new Object[0]);
        return processed;
    }

    private FileInfo postProcessFile(FileInfo processed) {
        for (FileLoadPostProcessor hook : this.postprocessors) {
            processed = hook.process(processed);
        }
        return processed;
    }
}

