/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.token;

import com.google.jstestdriver.token.ConcreteToken;
import com.google.jstestdriver.token.Token;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TokenEmitter
implements Iterator<Token> {
    private final BufferedInputStream stream;
    private final Token[] tokens;
    private Token currentToken = null;
    private TokenBuilder tokenBuilder = new TokenBuilder();

    public TokenEmitter(BufferedInputStream stream, Token[] tokens) {
        this.stream = stream;
        this.tokens = tokens;
    }

    @Override
    public Token next() {
        this.stream.mark(Integer.MAX_VALUE);
        if (this.currentToken != null) {
            Token nextToken = this.currentToken;
            this.currentToken = null;
            return nextToken;
        }
        try {
            Token nextToken;
            while (this.stream.available() > 0) {
                for (Token token : this.tokens) {
                    Token newToken = token.create(this.stream);
                    if (newToken == null) continue;
                    if (this.tokenBuilder.hasToken()) {
                        this.currentToken = newToken;
                        newToken = this.tokenBuilder.toToken();
                        this.tokenBuilder = new TokenBuilder();
                        return newToken;
                    }
                    return newToken;
                }
                this.tokenBuilder.append(this.stream.read());
                this.stream.mark(Integer.MAX_VALUE);
            }
            if (this.currentToken != null) {
                nextToken = this.currentToken;
                this.currentToken = null;
                return nextToken;
            }
            if (this.tokenBuilder.hasToken()) {
                nextToken = this.tokenBuilder.toToken();
                this.tokenBuilder = new TokenBuilder();
                return nextToken;
            }
            throw new IndexOutOfBoundsException();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean hasNext() {
        try {
            return this.stream.available() > 0 || this.currentToken != null || this.tokenBuilder.hasToken();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public static class TokenBuilder {
        private char[] buffer = new char[256];
        private int marker = 0;

        public void append(int read) {
            if (this.marker >= this.buffer.length) {
                char[] oldBuffer = this.buffer;
                this.buffer = new char[oldBuffer.length * 2];
                System.arraycopy(oldBuffer, 0, this.buffer, 0, this.marker);
            }
            this.buffer[this.marker++] = (char)read;
        }

        public boolean hasToken() {
            return this.marker > 0;
        }

        public Token toToken() {
            char[] out = new char[this.marker];
            System.arraycopy(this.buffer, 0, out, 0, this.marker);
            return new ConcreteToken(out);
        }
    }
}

