/* pgSnp.h was originally generated by the autoSql program, which also
 * generated pgSnp.c and pgSnp.sql.  This header links the database and
 * the RAM representation of objects. */

#ifndef PGSNP_H
#define PGSNP_H

#include "jksql.h"
#include "trackDb.h"
#include "bed.h"
#include "vcf.h"
#include "asParse.h"

#define PGSNP_NUM_COLS 8

struct pgSnp
/* personal genome SNP */
    {
    struct pgSnp *next;  /* Next in singly linked list. */
    char *chrom;	/* Chromosome */
    unsigned chromStart;	/* Start position in chrom */
    unsigned chromEnd;	/* End position in chrom */
    char *name;	/* alleles */
    int alleleCount;	/* number of alleles */
    char *alleleFreq;	/* comma separated list of frequency of each allele */
    char *alleleScores;	/* comma separated list of quality scores */
    unsigned short bin; /* A field to speed indexing */
    };

void pgSnpStaticLoad(char **row, struct pgSnp *ret);
/* Load a row from pgSnp table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct pgSnp *pgSnpLoad(char **row);
/* Load a pgSnp from row fetched with select * from pgSnp
 * from database.  Dispose of this with pgSnpFree(). */

struct pgSnp *pgSnpLoadAll(char *fileName);
/* Load all pgSnp from whitespace-separated file.
 * Dispose of this with pgSnpFreeList(). */

struct pgSnp *pgSnpLoadAllByChar(char *fileName, char chopper);
/* Load all pgSnp from chopper separated file.
 * Dispose of this with pgSnpFreeList(). */

#define pgSnpLoadAllByTab(a) pgSnpLoadAllByChar(a, '\t');
/* Load all pgSnp from tab separated file.
 * Dispose of this with pgSnpFreeList(). */

struct pgSnp *pgSnpLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all pgSnp from table that satisfy the query given.
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something =
 * anotherTable.something'.
 * Dispose of this with pgSnpFreeList(). */

void pgSnpSaveToDb(struct sqlConnection *conn, struct pgSnp *el, char *tableName, int updateSize);
/* Save pgSnp as a row to the table specified by tableName.
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. Note that strings must be escaped to allow insertion into the database.
 * For example "autosql's features include" --> "autosql\'s features include"
 * If worried about this use pgSnpSaveToDbEscaped() */

void pgSnpSaveToDbEscaped(struct sqlConnection *conn, struct pgSnp *el, char *tableName, int updateSize);
/* Save pgSnp as a row to the table specified by tableName.
 * As blob fields may be arbitrary size updateSize specifies the approx size.
 * of a string that would contain the entire query. Automatically
 * escapes all simple strings (not arrays of string) but may be slower than pgSnpSaveToDb().
 * For example automatically copies and converts:
 * "autosql's features include" --> "autosql\'s features include"
 * before inserting into database. */

struct pgSnp *pgSnpCommaIn(char **pS, struct pgSnp *ret);
/* Create a pgSnp out of a comma separated string.
 * This will fill in ret if non-null, otherwise will
 * return a new pgSnp */

void pgSnpFree(struct pgSnp **pEl);
/* Free a single dynamically allocated pgSnp such as created
 * with pgSnpLoad(). */

void pgSnpFreeList(struct pgSnp **pList);
/* Free a list of dynamically allocated pgSnp's */

void pgSnpOutput(struct pgSnp *el, FILE *f, char sep, char lastSep);
/* Print out pgSnp.  Separate fields with sep. Follow last field with lastSep. */

#define pgSnpTabOut(el,f) pgSnpOutput(el,f,'\t','\n');
/* Print out pgSnp as a line in a tab-separated file. */

#define pgSnpCommaOut(el,f) pgSnpOutput(el,f,',',',');
/* Print out pgSnp as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

struct pgCodon
/* codons covering region */
    {
    char *seq;
    int cdStart;
    int cdEnd;
    int firstCodon;
    int regStart; /* in coding sequence positions */
    int regEnd;
    };

struct pgCodon *fetchCodons (char *db, struct bed *gene, unsigned chrStart, unsigned chrEnd);
/* get codon sequence to compute aa changes */

void printSeqCodDisplay (char *db, struct pgSnp *item);
/* print the display of sequence changes for a coding variant */

void printPgDbLink(char *db, struct trackDb *tdb, struct pgSnp *item);
/* print the links to phenotype and other databases for pgSnps */

struct asObject *pgSnpAsObj();
// Return asObject describing fields of pgSnp

struct pgSnp *pgSnpLoadNoBin (char **row);
/* load struct from row without bin */

struct pgSnp *pgSnpLineFileLoad(char **row, struct lineFile *lf);
/* Load pgSnp from a lineFile line, with error checking. */
/* Requires comma separated zeroes for frequency and scores. */

struct pgSnp *pgSnpFromVcfRecord(struct vcfRecord *rec);
/* Convert VCF rec to pgSnp; don't free rec->file (vcfFile) until
 * you're done with pgSnp because pgSnp points to rec->chrom. */

#endif /* PGSNP_H */

