/* cytoBand.c was originally generated by the autoSql program, which also 
 * generated cytoBand.h and cytoBand.sql.  This module links the database and the RAM 
 * representation of objects. */

#include "common.h"
#include "jksql.h"
#include "cytoBand.h"


void cytoBandStaticLoad(char **row, struct cytoBand *ret)
/* Load a row from cytoBand table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->chrom = row[0];
ret->chromStart = sqlUnsigned(row[1]);
ret->chromEnd = sqlUnsigned(row[2]);
ret->name = row[3];
ret->gieStain = row[4];
}

struct cytoBand *cytoBandLoad(char **row)
/* Load a cytoBand from row fetched with select * from cytoBand
 * from database.  Dispose of this with cytoBandFree(). */
{
struct cytoBand *ret;

AllocVar(ret);
ret->chrom = cloneString(row[0]);
ret->chromStart = sqlUnsigned(row[1]);
ret->chromEnd = sqlUnsigned(row[2]);
ret->name = cloneString(row[3]);
ret->gieStain = cloneString(row[4]);
return ret;
}

struct cytoBand *cytoBandCommaIn(char **pS, struct cytoBand *ret)
/* Create a cytoBand out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new cytoBand */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->chrom = sqlStringComma(&s);
ret->chromStart = sqlUnsignedComma(&s);
ret->chromEnd = sqlUnsignedComma(&s);
ret->name = sqlStringComma(&s);
ret->gieStain = sqlStringComma(&s);
*pS = s;
return ret;
}

void cytoBandFree(struct cytoBand **pEl)
/* Free a single dynamically allocated cytoBand such as created
 * with cytoBandLoad(). */
{
struct cytoBand *el;

if ((el = *pEl) == NULL) return;
freeMem(el->chrom);
freeMem(el->name);
freeMem(el->gieStain);
freez(pEl);
}

void cytoBandFreeList(struct cytoBand **pList)
/* Free a list of dynamically allocated cytoBand's */
{
struct cytoBand *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    cytoBandFree(&el);
    }
*pList = NULL;
}

void cytoBandOutput(struct cytoBand *el, FILE *f, char sep, char lastSep) 
/* Print out cytoBand.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->chrom);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->chromStart);
fputc(sep,f);
fprintf(f, "%u", el->chromEnd);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->gieStain);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

