/* tagAlign.c was originally generated by the autoSql program, which also 
 * generated tagAlign.h and tagAlign.sql.  This module links the database and
 * the RAM representation of objects. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "tagAlign.h"


void tagAlignStaticLoad(char **row, struct tagAlign *ret)
/* Load a row from tagAlign table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->chrom = row[0];
ret->chromStart = sqlUnsigned(row[1]);
ret->chromEnd = sqlUnsigned(row[2]);
ret->sequence = row[3];
ret->score = sqlSigned(row[4]);
ret->strand = row[5][0];
}

struct tagAlign *tagAlignLoad(char **row)
/* Load a tagAlign from row fetched with select * from tagAlign
 * from database.  Dispose of this with tagAlignFree(). */
{
struct tagAlign *ret;

AllocVar(ret);
ret->chrom = cloneString(row[0]);
ret->chromStart = sqlUnsigned(row[1]);
ret->chromEnd = sqlUnsigned(row[2]);
ret->sequence = cloneString(row[3]);
ret->score = sqlSigned(row[4]);
ret->strand = row[5][0];
return ret;
}

struct tagAlign *tagAlignLoadAll(char *fileName) 
/* Load all tagAlign from a whitespace-separated file.
 * Dispose of this with tagAlignFreeList(). */
{
struct tagAlign *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[6];

while (lineFileRow(lf, row))
    {
    el = tagAlignLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct tagAlign *tagAlignLoadAllByChar(char *fileName, char chopper) 
/* Load all tagAlign from a chopper separated file.
 * Dispose of this with tagAlignFreeList(). */
{
struct tagAlign *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[6];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = tagAlignLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct tagAlign *tagAlignCommaIn(char **pS, struct tagAlign *ret)
/* Create a tagAlign out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new tagAlign */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->chrom = sqlStringComma(&s);
ret->chromStart = sqlUnsignedComma(&s);
ret->chromEnd = sqlUnsignedComma(&s);
ret->sequence = sqlStringComma(&s);
ret->score = sqlSignedComma(&s);
sqlFixedStringComma(&s, &(ret->strand), sizeof(ret->strand));
*pS = s;
return ret;
}

void tagAlignFree(struct tagAlign **pEl)
/* Free a single dynamically allocated tagAlign such as created
 * with tagAlignLoad(). */
{
struct tagAlign *el;

if ((el = *pEl) == NULL) return;
freeMem(el->chrom);
freeMem(el->sequence);
freez(pEl);
}

void tagAlignFreeList(struct tagAlign **pList)
/* Free a list of dynamically allocated tagAlign's */
{
struct tagAlign *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    tagAlignFree(&el);
    }
*pList = NULL;
}

void tagAlignOutput(struct tagAlign *el, FILE *f, char sep, char lastSep) 
/* Print out tagAlign.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->chrom);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->chromStart);
fputc(sep,f);
fprintf(f, "%u", el->chromEnd);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->sequence);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%d", el->score);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%c", el->strand);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

