/* estPair.c was originally generated by the autoSql program, which also 
 * generated estPair.h and estPair.sql.  This module links the database and
 * the RAM representation of objects. */

#include "common.h"
#include "linefile.h"
#include "jksql.h"
#include "estPair.h"


void estPairStaticLoad(char **row, struct estPair *ret)
/* Load a row from estPair table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->chrom = row[0];
ret->chromStart = sqlUnsigned(row[1]);
ret->chromEnd = sqlUnsigned(row[2]);
ret->mrnaClone = row[3];
ret->acc5 = row[4];
ret->start5 = sqlUnsigned(row[5]);
ret->end5 = sqlUnsigned(row[6]);
ret->acc3 = row[7];
ret->start3 = sqlUnsigned(row[8]);
ret->end3 = sqlUnsigned(row[9]);
}

struct estPair *estPairLoad(char **row)
/* Load a estPair from row fetched with select * from estPair
 * from database.  Dispose of this with estPairFree(). */
{
struct estPair *ret;

AllocVar(ret);
ret->chrom = cloneString(row[0]);
ret->chromStart = sqlUnsigned(row[1]);
ret->chromEnd = sqlUnsigned(row[2]);
ret->mrnaClone = cloneString(row[3]);
ret->acc5 = cloneString(row[4]);
ret->start5 = sqlUnsigned(row[5]);
ret->end5 = sqlUnsigned(row[6]);
ret->acc3 = cloneString(row[7]);
ret->start3 = sqlUnsigned(row[8]);
ret->end3 = sqlUnsigned(row[9]);
return ret;
}

struct estPair *estPairLoadAll(char *fileName) 
/* Load all estPair from a tab-separated file.
 * Dispose of this with estPairFreeList(). */
{
struct estPair *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[10];

while (lineFileRow(lf, row))
    {
    el = estPairLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct estPair *estPairCommaIn(char **pS, struct estPair *ret)
/* Create a estPair out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new estPair */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->chrom = sqlStringComma(&s);
ret->chromStart = sqlUnsignedComma(&s);
ret->chromEnd = sqlUnsignedComma(&s);
ret->mrnaClone = sqlStringComma(&s);
ret->acc5 = sqlStringComma(&s);
ret->start5 = sqlUnsignedComma(&s);
ret->end5 = sqlUnsignedComma(&s);
ret->acc3 = sqlStringComma(&s);
ret->start3 = sqlUnsignedComma(&s);
ret->end3 = sqlUnsignedComma(&s);
*pS = s;
return ret;
}

void estPairFree(struct estPair **pEl)
/* Free a single dynamically allocated estPair such as created
 * with estPairLoad(). */
{
struct estPair *el;

if ((el = *pEl) == NULL) return;
freeMem(el->chrom);
freeMem(el->mrnaClone);
freeMem(el->acc5);
freeMem(el->acc3);
freez(pEl);
}

void estPairFreeList(struct estPair **pList)
/* Free a list of dynamically allocated estPair's */
{
struct estPair *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    estPairFree(&el);
    }
*pList = NULL;
}

void estPairOutput(struct estPair *el, FILE *f, char sep, char lastSep) 
/* Print out estPair.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->chrom);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->chromStart);
fputc(sep,f);
fprintf(f, "%u", el->chromEnd);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->mrnaClone);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->acc5);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->start5);
fputc(sep,f);
fprintf(f, "%u", el->end5);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->acc3);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->start3);
fputc(sep,f);
fprintf(f, "%u", el->end3);
fputc(lastSep,f);
}

