# hgnc.sql was originally generated by the autoSql program, which also 
# generated hgnc.c and hgnc.h.  This creates the database representation of
# an object which can be loaded and saved from RAM in a fairly 
# automatic way.

#A cross-reference table between HUGO Gene Nomenclature Committee (HGNC) IDs and other database IDs.
CREATE TABLE hgnc (
    hgncId varchar(255) not null,	# HGNC ID
    symbol varchar(255) not null,	# Approved Symbol
    name varchar(255) not null,	# Approved Name
    status varchar(255) not null,	# Status
    locusType varchar(255) not null,	# Locus Type
    prvSymbols varchar(255) not null,	# Previous Symbols
    prvNames varchar(255) not null,	# Previous Names
    aliases varchar(255) not null,	# Aliases
    chrom varchar(255) not null,	# Chromosome
    dateApprv varchar(255) not null,	# Date Approved
    dateMod varchar(255) not null,	# Date Modified
    dateChange varchar(255) not null,	# Date Name Changed
    accession varchar(255) not null,	# Accession Numbers
    enzymeIds varchar(255) not null,	# Enzyme IDs
    entrezId varchar(255) not null,	# Entrez Gene ID
    MgdId varchar(255) not null,	# MGD ID
    miscIds varchar(255) not null,	# Misc IDs
    pubMed varchar(255) not null,	# Pubmed IDs
    refSeqIds varchar(255) not null,	# RefSeq IDs
    geneFamily varchar(255) not null,	# Gene Family Name
    gdbId varchar(255) not null,	# GDB ID (mapped data)
    entrezMapped varchar(255) not null,	# Entrez Gene ID (mapped data)
    omim varchar(255) not null,	# OMIM ID (mapped data)
    refSeqMapped varchar(255) not null,	# RefSeq (mapped data)
    uniProt varchar(255) not null,	# UniProt ID (mapped data)
              #Indices
    PRIMARY KEY(hgncId)
);
