/* tigrOperon.c was originally generated by the autoSql program, which also 
 * generated tigrOperon.h and tigrOperon.sql.  This module links the database and
 * the RAM representation of objects. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "tigrOperon.h"


struct tigrOperon *tigrOperonLoad(char **row)
/* Load a tigrOperon from row fetched with select * from tigrOperon
 * from database.  Dispose of this with tigrOperonFree(). */
{
struct tigrOperon *ret;

AllocVar(ret);
ret->size = sqlUnsigned(row[1]);
ret->name = cloneString(row[0]);
{
int sizeOne;
sqlStringDynamicArray(row[2], &ret->genes, &sizeOne);
assert(sizeOne == ret->size);
}
ret->info = cloneString(row[3]);
return ret;
}

struct tigrOperon *tigrOperonLoadAll(char *fileName) 
/* Load all tigrOperon from a whitespace-separated file.
 * Dispose of this with tigrOperonFreeList(). */
{
struct tigrOperon *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[4];

while (lineFileRow(lf, row))
    {
    el = tigrOperonLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct tigrOperon *tigrOperonLoadAllByChar(char *fileName, char chopper) 
/* Load all tigrOperon from a chopper separated file.
 * Dispose of this with tigrOperonFreeList(). */
{
struct tigrOperon *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[4];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = tigrOperonLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct tigrOperon *tigrOperonCommaIn(char **pS, struct tigrOperon *ret)
/* Create a tigrOperon out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new tigrOperon */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->name = sqlStringComma(&s);
ret->size = sqlUnsignedComma(&s);
{
int i;
s = sqlEatChar(s, '{');
AllocArray(ret->genes, ret->size);
for (i=0; i<ret->size; ++i)
    {
    ret->genes[i] = sqlStringComma(&s);
    }
s = sqlEatChar(s, '}');
s = sqlEatChar(s, ',');
}
ret->info = sqlStringComma(&s);
*pS = s;
return ret;
}

void tigrOperonFree(struct tigrOperon **pEl)
/* Free a single dynamically allocated tigrOperon such as created
 * with tigrOperonLoad(). */
{
struct tigrOperon *el;

if ((el = *pEl) == NULL) return;
freeMem(el->name);
/* All strings in genes are allocated at once, so only need to free first. */
if (el->genes != NULL)
    freeMem(el->genes[0]);
freeMem(el->genes);
freeMem(el->info);
freez(pEl);
}

void tigrOperonFreeList(struct tigrOperon **pList)
/* Free a list of dynamically allocated tigrOperon's */
{
struct tigrOperon *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    tigrOperonFree(&el);
    }
*pList = NULL;
}

void tigrOperonOutput(struct tigrOperon *el, FILE *f, char sep, char lastSep) 
/* Print out tigrOperon.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->size);
fputc(sep,f);
{
int i;
if (sep == ',') fputc('{',f);
for (i=0; i<el->size; ++i)
    {
    if (sep == ',') fputc('"',f);
    fprintf(f, "%s", el->genes[i]);
    if (sep == ',') fputc('"',f);
    fputc(',', f);
    }
if (sep == ',') fputc('}',f);
}
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->info);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

