/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.xmindresource;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.xmind.verify.ui.VerifyUI20141031;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Shell;
import org.xmind.core.internal.gallery.IGalleryGroup;
import org.xmind.core.marker.IMarkerGroup;
import org.xmind.core.style.IStyle;
import org.xmind.ui.internal.dialogs.DialogUtils;
import org.xmind.ui.internal.xmindresource.Messages;
import org.xmind.ui.internal.xmindresource.ResourceExportWizardConfirmPage2;
import org.xmind.ui.internal.xmindresource.ResourceExportWizardSelectionPage2;
import org.xmind.ui.internal.xmindresource.XMindResourceImpExpUtils;
import org.xmind.ui.mindmap.ITemplate;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.tabfolder.MTabFolder;
import org.xmind.ui.tabfolder.MTabItem;
import org.xmind.ui.wizards.AbstractExportWizard;
import org.xmind.ui.xmindresource.XMindResourcePlugin;

public class ResourceExportWizard2
extends AbstractExportWizard
implements IPageChangedListener {
    private static final String SECTION_NAME = "org.xmind.ui.xmindresource.ResourceExportWizad";
    private ResourceExportWizardSelectionPage2 selectionPage;
    private ResourceExportWizardConfirmPage2 confirmPage;

    public ResourceExportWizard2() {
        this.setWindowTitle(Messages.ResourceExportWizard_windowTitle);
        this.setDefaultPageImageDescriptor(MindMapUI.getImages().getWizBan("export_wiz.png"));
        this.setDialogSettings(XMindResourcePlugin.getDefault().getDialogSettings(SECTION_NAME));
        VerifyUI20141031.getUsageDataCollector().increase("ExportBundleCount");
    }

    public void addPages() {
        this.selectionPage = new ResourceExportWizardSelectionPage2();
        this.addPage((IWizardPage)this.selectionPage);
        this.confirmPage = new ResourceExportWizardConfirmPage2();
        this.addPage((IWizardPage)this.confirmPage);
    }

    public void showPageItem(int index) {
        MTabItem item;
        MTabFolder tabFolder;
        if (this.selectionPage != null && (tabFolder = this.selectionPage.getTabFolder()) != null && !tabFolder.isDisposed() && (item = tabFolder.getItem(index)) != null && !item.isDisposed()) {
            tabFolder.setSelection(item);
        }
    }

    public boolean canFinish() {
        return super.canFinish() && this.selectionPage != null && !this.selectionPage.getElementsToExport().isEmpty();
    }

    public boolean performFinish() {
        boolean[] b = new boolean[1];
        if (this.hasTargetPath()) {
            Shell shell = this.getShell();
            List<Object> elementsToExport = this.selectionPage.getElementsToExport();
            if (!elementsToExport.isEmpty()) {
                int status;
                int index;
                int result;
                String targetPath = this.getTargetPath();
                if (!targetPath.endsWith(".xrb") && (result = new MessageDialog(shell, Messages.ResourceExportWizard_Dialog_UncompatibleFormat_title, null, NLS.bind((String)Messages.ResourceExportWizard_Dialog_UncompatibleFormat_description, (Object)targetPath.substring(index = targetPath.indexOf(46)), (Object)".xrb"), 3, new String[]{Messages.ResourceExportWizard_Dialog_Yes_button, Messages.ResourceExportWizard_Dialog_No_button}, 0).open()) != 0) {
                    return b[0];
                }
                if (!this.isOverwriteWithoutPrompt() && new File(targetPath).exists() && !DialogUtils.confirmOverwrite((Shell)this.getShell(), (String)this.getTargetPath())) {
                    return false;
                }
                File parentFile = new File(targetPath).getParentFile();
                if (parentFile != null && !parentFile.isDirectory()) {
                    result = new MessageDialog(shell, Messages.ResourceExportWizard_Dialog_PathNotExist_title, null, NLS.bind((String)Messages.ResourceExportWizard_Dialog_PathNotExist_description, (Object)parentFile.getAbsolutePath()), 3, new String[]{Messages.ResourceExportWizard_Dialog_Yes_button, Messages.ResourceExportWizard_Dialog_No_button}, 0).open();
                    if (result == 0) {
                        parentFile.mkdirs();
                    } else {
                        return b[0];
                    }
                }
                if ((status = XMindResourceImpExpUtils.exportResourceBundle(elementsToExport, this.getTargetPath())) != 0) {
                    MessageDialog information = new MessageDialog(shell, Messages.ResourceExportWizard_Exception_Information_Title, null, Messages.ResourceExportWizard_WholeException_Information_description, 2, new String[]{Messages.ResourceExportWizard_Exception_Informtion_buntton}, 0);
                    information.setBlockOnOpen(false);
                    information.open();
                    b[0] = false;
                } else {
                    b[0] = true;
                    this.collectUserDataOfExportResouces();
                }
                String dir = new File(this.getTargetPath()).getParent();
                Program.launch((String)dir);
            }
        }
        return b[0];
    }

    private void collectUserDataOfExportResouces() {
        Map<Object, Image> confirmMap;
        if (this.selectionPage != null && (confirmMap = this.selectionPage.getElementsMapToExport()) != null) {
            Set<Object> elements = confirmMap.keySet();
            for (Object element : elements) {
                if (!(element instanceof ITemplate)) continue;
                VerifyUI20141031.getUsageDataCollector().increase("ExportTemplateCount");
                return;
            }
            for (Object element : elements) {
                if (!(element instanceof IStyle)) continue;
                VerifyUI20141031.getUsageDataCollector().increase("ExportThemeCount");
                return;
            }
            for (Object element : elements) {
                if (!(element instanceof IMarkerGroup)) continue;
                VerifyUI20141031.getUsageDataCollector().increase("ExportMarkerCount");
                return;
            }
            for (Object element : elements) {
                if (!(element instanceof IGalleryGroup)) continue;
                VerifyUI20141031.getUsageDataCollector().increase("ExportClipArtCount");
                return;
            }
        }
    }

    public void pageChanged(PageChangedEvent event) {
        if (this.selectionPage != null && this.confirmPage != null && event.getSelectedPage() == this.confirmPage) {
            this.confirmPage.setNeedConfirmSelectionMap(this.selectionPage.getElementsMapToExport());
        }
    }

    protected String getSuggestedFileName() {
        return String.valueOf(Messages.ResourceImportExportWizardPage_SuggestedName) + ".xrb";
    }
}

