/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.dom;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.zip.ZipOutputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xmind.core.Core;
import org.xmind.core.CoreException;
import org.xmind.core.IAdaptable;
import org.xmind.core.IChecksumStream;
import org.xmind.core.IEncryptionData;
import org.xmind.core.IFileEntry;
import org.xmind.core.IRevisionManager;
import org.xmind.core.internal.InternalCore;
import org.xmind.core.internal.dom.FileEntryImpl;
import org.xmind.core.internal.dom.ManifestImpl;
import org.xmind.core.internal.dom.MarkerSheetImpl;
import org.xmind.core.internal.dom.MetaImpl;
import org.xmind.core.internal.dom.StyleSheetImpl;
import org.xmind.core.internal.dom.WorkbookImpl;
import org.xmind.core.internal.security.Crypto;
import org.xmind.core.internal.zip.ZipStreamOutputTarget;
import org.xmind.core.io.DirectoryOutputTarget;
import org.xmind.core.io.ICloseableOutputTarget;
import org.xmind.core.io.IInputSource;
import org.xmind.core.io.IOutputTarget;
import org.xmind.core.util.DOMUtils;

@Deprecated
public class WorkbookSaver {
    private final WorkbookImpl workbook;
    private IOutputTarget lastTarget;
    private String file;
    private boolean skipRevisions = false;

    public WorkbookSaver(WorkbookImpl workbook, String file) {
        this.workbook = workbook;
        this.file = file;
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public void setSkipRevisions(boolean skipRevisions) {
        this.skipRevisions = skipRevisions;
    }

    public boolean isSkipRevisions() {
        return this.skipRevisions;
    }

    public synchronized void save() throws IOException, CoreException {
        this.doSave(this.lastTarget);
    }

    public synchronized void save(OutputStream output) throws IOException, CoreException {
        this.doSave(new ZipStreamOutputTarget(new ZipOutputStream(output)));
    }

    public synchronized void save(String file) throws IOException, CoreException {
        if (new File(file).isDirectory()) {
            this.doSave(new DirectoryOutputTarget(file));
        } else {
            FileOutputStream fout = new FileOutputStream(file);
            try {
                ZipOutputStream stream = new ZipOutputStream(fout);
                try {
                    this.doSave(new ZipStreamOutputTarget(stream));
                }
                finally {
                    stream.close();
                }
            }
            finally {
                fout.close();
            }
        }
        this.file = file;
    }

    public synchronized void save(IOutputTarget target) throws IOException, CoreException {
        this.doSave(target);
        this.lastTarget = target;
    }

    private synchronized void doSave(IOutputTarget target) throws IOException, CoreException {
        if (target == null) {
            throw new FileNotFoundException("No target to save.");
        }
        if (InternalCore.DEBUG_WORKBOOK_SAVE) {
            Core.getLogger().log("WorkbookSaver: About to save workbook to output target " + target.toString());
        }
        new WorkbookSaveSession(this.workbook, target).save();
        if (InternalCore.DEBUG_WORKBOOK_SAVE) {
            Core.getLogger().log("WorkbookSaver: Finished saving workbook to output target " + target.toString());
        }
    }

    private static class WorkbookSaveSession {
        private final WorkbookImpl workbook;
        private final IOutputTarget target;
        private Set<String> savedEntries = new HashSet<String>();
        private TransformerFactory transformerFactory = null;

        public WorkbookSaveSession(WorkbookImpl workbook, IOutputTarget target) {
            this.workbook = workbook;
            this.target = target;
        }

        public synchronized void save() throws IOException, CoreException {
            try {
                try {
                    try {
                        this.saveMeta();
                    }
                    finally {
                        try {
                            this.saveContent();
                        }
                        finally {
                            try {
                                this.saveMarkerSheet();
                            }
                            finally {
                                try {
                                    this.saveStyleSheet();
                                }
                                finally {
                                    try {
                                        this.saveComments();
                                    }
                                    finally {
                                        try {
                                            if (!this.workbook.isSkipRevisionsWhenSaving()) {
                                                this.saveRevisions();
                                            }
                                        }
                                        finally {
                                            try {
                                                this.copyOtherStaff();
                                            }
                                            finally {
                                                this.saveManifest();
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                finally {
                    this.clearEncryptionData();
                }
            }
            finally {
                if (this.target instanceof ICloseableOutputTarget) {
                    ((ICloseableOutputTarget)this.target).close();
                }
            }
        }

        private void saveManifest() throws IOException, CoreException {
            this.saveDOM(this.workbook.getManifest(), this.target, "META-INF/manifest.xml");
        }

        private void saveStyleSheet() throws IOException, CoreException {
            StyleSheetImpl styleSheet = this.workbook.getStyleSheet();
            if (!styleSheet.isEmpty()) {
                this.saveDOM(styleSheet, this.target, "styles.xml");
            }
        }

        private void saveMarkerSheet() throws IOException, CoreException {
            MarkerSheetImpl markerSheet = this.workbook.getMarkerSheet();
            if (!markerSheet.isEmpty()) {
                this.saveDOM(markerSheet, this.target, "markers/markerSheet.xml");
            }
        }

        private void saveComments() throws IOException, CoreException {
        }

        private void saveRevisions() throws IOException, CoreException {
            Iterator<Element> sheets = DOMUtils.childElementIterByTag(this.workbook.getWorkbookElement(), "sheet");
            while (sheets.hasNext()) {
                Element sheetEle = sheets.next();
                String sheetId = sheetEle.getAttribute("id");
                IRevisionManager manager = this.workbook.getRevisionRepository().getRevisionManager(sheetId, "application/vnd.xmind.sheet");
                String path = "Revisions/" + sheetId + "/" + "revisions.xml";
                this.saveDOM(manager, this.target, path);
            }
        }

        private void saveContent() throws IOException, CoreException {
            this.saveDOM(this.workbook, this.target, "content.xml");
        }

        private void saveMeta() throws IOException, CoreException {
            MetaImpl meta = this.workbook.getMeta();
            this.saveDOM(meta, this.target, "meta.xml");
        }

        private void copyOtherStaff() throws IOException, CoreException {
            IInputSource source = this.workbook.getTempStorage().getInputSource();
            ManifestImpl manifest = this.workbook.getManifest();
            for (IFileEntry entry : manifest.getFileEntries()) {
                String entryPath;
                if (entry.isDirectory() || !this.shouldSaveEntry(entryPath = entry.getPath())) continue;
                this.copyEntry(source, this.target, entryPath);
                this.markSaved(entryPath);
            }
        }

        private synchronized void copyEntry(IInputSource source, IOutputTarget target, String entryPath) throws IOException, CoreException {
            InputStream in = this.getInputStream(source, entryPath);
            if (in == null) {
                Core.getLogger().log("Save workbook: failed to copy entry, input stream not avaiable: " + entryPath);
                return;
            }
            try {
                long time = source.getEntryTime(entryPath);
                if (time >= 0L) {
                    target.setEntryTime(entryPath, time);
                }
                OutputStream out = this.getOutputStream(target, entryPath);
                try {
                    int numBytes;
                    byte[] byteBuffer = new byte[4096];
                    while ((numBytes = in.read(byteBuffer)) > 0) {
                        out.write(byteBuffer, 0, numBytes);
                    }
                    this.recordChecksum(entryPath, out);
                }
                finally {
                    out.close();
                }
            }
            finally {
                in.close();
            }
        }

        private boolean shouldSaveEntry(String entryPath) {
            return entryPath != null && !"".equals(entryPath) && !"META-INF/manifest.xml".equals(entryPath) && !this.hasBeenSaved(entryPath) && (!this.workbook.isSkipRevisionsWhenSaving() || !entryPath.startsWith("Revisions/"));
        }

        private void clearEncryptionData() {
            for (IFileEntry entry : this.workbook.getManifest().getFileEntries()) {
                entry.deleteEncryptionData();
            }
        }

        private void saveDOM(IAdaptable domAdapter, IOutputTarget target, String entryPath) throws IOException, CoreException {
            Transformer transformer;
            Node node = domAdapter.getAdapter(Node.class);
            if (node == null) {
                Core.getLogger().log("SaveWorkbook: No DOM node available for entry: " + entryPath);
                return;
            }
            if (this.transformerFactory == null) {
                try {
                    this.transformerFactory = TransformerFactory.newInstance();
                }
                catch (TransformerFactoryConfigurationError error) {
                    throw new CoreException(15, "Failed to obtain XML transformer factory.", error);
                }
            }
            try {
                transformer = this.transformerFactory.newTransformer();
            }
            catch (TransformerConfigurationException error) {
                throw new CoreException(15, "Failed to create XML transformer for DOM entry '" + entryPath + "'.", error);
            }
            OutputStream out = this.getOutputStream(target, entryPath);
            try {
                try {
                    transformer.transform(new DOMSource(node), new StreamResult(out));
                }
                catch (TransformerException e) {
                    throw new IOException(e.getLocalizedMessage(), e);
                }
            }
            finally {
                out.close();
            }
            this.recordChecksum(entryPath, out);
            this.markSaved(entryPath);
        }

        private void recordChecksum(String entryPath, Object checksumProvider) throws IOException {
            String checksum;
            IEncryptionData encData;
            if (checksumProvider instanceof IChecksumStream && (encData = this.workbook.getManifest().getEncryptionData(entryPath)) != null && encData.getChecksumType() != null && (checksum = ((IChecksumStream)checksumProvider).getChecksum()) != null) {
                encData.setAttribute(checksum, "checksum");
            }
        }

        private InputStream getInputStream(IInputSource source, String entryPath) {
            if (source.hasEntry(entryPath)) {
                return source.getEntryStream(entryPath);
            }
            return null;
        }

        private OutputStream getOutputStream(IOutputTarget target, String entryPath) throws IOException, CoreException {
            OutputStream out = target.openEntryStream(entryPath);
            String password = this.workbook.getPassword();
            if (password == null) {
                return out;
            }
            IFileEntry entry = this.workbook.getManifest().getFileEntry(entryPath);
            if (entry == null) {
                return out;
            }
            if (this.ignoresEncryption(entry, entryPath)) {
                return out;
            }
            IEncryptionData encData = entry.createEncryptionData();
            return Crypto.creatOutputStream(out, true, encData, password);
        }

        private boolean ignoresEncryption(IFileEntry entry, String entryPath) {
            return "META-INF/manifest.xml".equals(entryPath) || ((FileEntryImpl)entry).isIgnoreEncryption();
        }

        private boolean hasBeenSaved(String entryPath) {
            return this.savedEntries.contains(entryPath);
        }

        private void markSaved(String entryPath) {
            this.savedEntries.add(entryPath);
        }
    }
}

