/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.spec;

import java.math.BigInteger;
import java.security.spec.ECFieldF2m;
import java.security.spec.ECFieldFp;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;
import org.bouncycastle.math.ec.ECAlgorithms;
import org.bouncycastle.math.ec.ECCurve;

public class ECNamedCurveSpec
extends ECParameterSpec {
    private String name;

    private static EllipticCurve convertCurve(ECCurve curve, byte[] seed) {
        if (ECAlgorithms.isFpCurve(curve)) {
            return new EllipticCurve(new ECFieldFp(curve.getField().getCharacteristic()), curve.getA().toBigInteger(), curve.getB().toBigInteger(), seed);
        }
        ECCurve.F2m curveF2m = (ECCurve.F2m)curve;
        if (curveF2m.isTrinomial()) {
            int[] ks = new int[]{curveF2m.getK1()};
            return new EllipticCurve(new ECFieldF2m(curveF2m.getM(), ks), curve.getA().toBigInteger(), curve.getB().toBigInteger(), seed);
        }
        int[] ks = new int[]{curveF2m.getK3(), curveF2m.getK2(), curveF2m.getK1()};
        return new EllipticCurve(new ECFieldF2m(curveF2m.getM(), ks), curve.getA().toBigInteger(), curve.getB().toBigInteger(), seed);
    }

    private static ECPoint convertPoint(org.bouncycastle.math.ec.ECPoint g) {
        g = g.normalize();
        return new ECPoint(g.getAffineXCoord().toBigInteger(), g.getAffineYCoord().toBigInteger());
    }

    public ECNamedCurveSpec(String name, ECCurve curve, org.bouncycastle.math.ec.ECPoint g, BigInteger n) {
        super(ECNamedCurveSpec.convertCurve(curve, null), ECNamedCurveSpec.convertPoint(g), n, 1);
        this.name = name;
    }

    public ECNamedCurveSpec(String name, EllipticCurve curve, ECPoint g, BigInteger n) {
        super(curve, g, n, 1);
        this.name = name;
    }

    public ECNamedCurveSpec(String name, ECCurve curve, org.bouncycastle.math.ec.ECPoint g, BigInteger n, BigInteger h) {
        super(ECNamedCurveSpec.convertCurve(curve, null), ECNamedCurveSpec.convertPoint(g), n, h.intValue());
        this.name = name;
    }

    public ECNamedCurveSpec(String name, EllipticCurve curve, ECPoint g, BigInteger n, BigInteger h) {
        super(curve, g, n, h.intValue());
        this.name = name;
    }

    public ECNamedCurveSpec(String name, ECCurve curve, org.bouncycastle.math.ec.ECPoint g, BigInteger n, BigInteger h, byte[] seed) {
        super(ECNamedCurveSpec.convertCurve(curve, seed), ECNamedCurveSpec.convertPoint(g), n, h.intValue());
        this.name = name;
    }

    public String getName() {
        return this.name;
    }
}

