/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.math.ec;

import java.math.BigInteger;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.math.ec.FixedPointPreCompInfo;
import org.bouncycastle.math.ec.PreCompInfo;

public class FixedPointUtil {
    public static final String PRECOMP_NAME = "bc_fixed_point";

    public static int getCombSize(ECCurve c) {
        BigInteger order = c.getOrder();
        return order == null ? c.getFieldSize() + 1 : order.bitLength();
    }

    public static FixedPointPreCompInfo getFixedPointPreCompInfo(PreCompInfo preCompInfo) {
        if (preCompInfo != null && preCompInfo instanceof FixedPointPreCompInfo) {
            return (FixedPointPreCompInfo)preCompInfo;
        }
        return new FixedPointPreCompInfo();
    }

    public static FixedPointPreCompInfo precompute(ECPoint p, int minWidth) {
        ECCurve c = p.getCurve();
        int n = 1 << minWidth;
        FixedPointPreCompInfo info = FixedPointUtil.getFixedPointPreCompInfo(c.getPreCompInfo(p, PRECOMP_NAME));
        ECPoint[] lookupTable = info.getPreComp();
        if (lookupTable == null || lookupTable.length < n) {
            int bits = FixedPointUtil.getCombSize(c);
            int d = (bits + minWidth - 1) / minWidth;
            ECPoint[] pow2Table = new ECPoint[minWidth];
            pow2Table[0] = p;
            int i = 1;
            while (i < minWidth) {
                pow2Table[i] = pow2Table[i - 1].timesPow2(d);
                ++i;
            }
            c.normalizeAll(pow2Table);
            lookupTable = new ECPoint[n];
            lookupTable[0] = c.getInfinity();
            int bit = minWidth - 1;
            while (bit >= 0) {
                int step;
                ECPoint pow2 = pow2Table[bit];
                int i2 = step = 1 << bit;
                while (i2 < n) {
                    lookupTable[i2] = lookupTable[i2 - step].add(pow2);
                    i2 += step << 1;
                }
                --bit;
            }
            c.normalizeAll(lookupTable);
            info.setPreComp(lookupTable);
            info.setWidth(minWidth);
            c.setPreCompInfo(p, PRECOMP_NAME, info);
        }
        return info;
    }
}

