/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.spreadsheet.decorations;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.widgets.Display;
import org.xmind.gef.draw2d.IDecoratedFigure;
import org.xmind.gef.draw2d.decoration.AbstractDecoration;
import org.xmind.gef.draw2d.decoration.ICorneredDecoration;
import org.xmind.gef.draw2d.decoration.IDecoration;
import org.xmind.gef.draw2d.geometry.PrecisionLine;
import org.xmind.gef.draw2d.geometry.PrecisionRectangle;
import org.xmind.gef.graphicalpolicy.IStructure;
import org.xmind.gef.graphicalpolicy.IStyleSelector;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.gef.part.IPart;
import org.xmind.ui.branch.IInsertion;
import org.xmind.ui.decorations.IBranchDecoration;
import org.xmind.ui.decorations.ITopicDecoration;
import org.xmind.ui.internal.spreadsheet.structures.Chart2;
import org.xmind.ui.internal.spreadsheet.structures.Column2;
import org.xmind.ui.internal.spreadsheet.structures.Row2;
import org.xmind.ui.internal.spreadsheet.structures.RowHead;
import org.xmind.ui.internal.spreadsheet.structures.SpreadsheetColumnStructure;
import org.xmind.ui.mindmap.IBranchPart;
import org.xmind.ui.mindmap.ITitleTextPart;
import org.xmind.ui.mindmap.ITopicPart;
import org.xmind.ui.resources.ColorUtils;
import org.xmind.ui.style.StyleUtils;
import org.xmind.ui.util.MindMapUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpreadsheetBranchDecoration2
extends AbstractDecoration
implements IBranchDecoration {
    private static final Rectangle CLIP_RECT = new Rectangle();
    private static final int INSERTION_ALPHA = 96;
    private IBranchPart branch;
    private PrecisionRectangle bounds;
    private List<Block> blocks;
    private List<PrecisionLine> lines;
    private PrecisionRectangle insertedCellBounds;
    private List<Text> rowHeads;

    public SpreadsheetBranchDecoration2(IBranchPart branch, String id) {
        super(id);
        this.branch = branch;
    }

    public void validate(IFigure figure) {
        super.validate(figure);
        IStyleSelector ss = StyleUtils.getStyleSelector((IGraphicalPart)this.branch);
        String decorationId = StyleUtils.getString((IGraphicalPart)this.branch, (IStyleSelector)ss, (String)"shape-class", null);
        int lineWidth = StyleUtils.getInteger((IGraphicalPart)this.branch, (IStyleSelector)ss, (String)"line-width", (String)decorationId, (int)1);
        double halfLineWidth1 = (double)lineWidth / 2.0;
        double halfLineWidth2 = (double)lineWidth - halfLineWidth1;
        this.bounds = new PrecisionRectangle(this.branch.getFigure().getBounds()).shrink((double)lineWidth, (double)lineWidth);
        double left = this.bounds.x;
        double right = this.bounds.right();
        double top = this.bounds.y;
        double bottom = this.bounds.bottom();
        Chart2 chart = this.getChart();
        if (chart != null) {
            int titleHeight = chart.getTitleAreaHeight();
            top += (double)titleHeight;
            boolean ignoreFirstLine = !chart.hasRows();
            IInsertion ins = (IInsertion)MindMapUtils.getCache((IPart)this.branch, (String)"org.xmind.ui.branchCache.insertion");
            int insWidth = ins == null ? 0 : ins.getSize().width + chart.getMajorSpacing();
            int numCols = chart.getNumColumns();
            int numRows = numCols > 0 ? chart.getNumRows() : 0;
            int numLines = Math.max(0, numRows) + Math.max(0, numCols);
            if (ins != null) {
                ++numLines;
            }
            if (numLines > 0) {
                Block block;
                double rowHeadWidth;
                double rowHeadLeft;
                this.lines = new ArrayList<PrecisionLine>(numLines);
                int majorSpacing = chart.getMajorSpacing();
                int minorSpacing = chart.getMinorSpacing();
                double x = left;
                double y = top + (double)minorSpacing;
                this.addHorizontalLine(left, right, top + halfLineWidth2);
                if (chart.hasRows()) {
                    ignoreFirstLine = false;
                    rowHeadLeft = x + (double)lineWidth;
                    rowHeadWidth = chart.getRowHeadWidth() + chart.getMajorSpacing();
                    x += rowHeadWidth + (double)lineWidth;
                    if (chart.hasRows()) {
                        y += (double)chart.getColHeadHeight();
                    }
                } else {
                    this.addVerticalLine(x += (double)(majorSpacing + lineWidth), top, bottom);
                    rowHeadLeft = 0.0;
                    rowHeadWidth = 0.0;
                }
                RowHead insertionRowHead = null;
                boolean insertionInColumn = false;
                int i = 0;
                while (i < numCols) {
                    Column2 col = chart.getColumn(i);
                    if (insertionRowHead == null && (insertionRowHead = (RowHead)MindMapUtils.getCache((IPart)col.getHead(), (String)"org.xmind.ui.spreadsheet.cache.insertionRowHead")) != null) {
                        insertionInColumn = true;
                        this.insertedCellBounds = new PrecisionRectangle();
                    }
                    if (!ignoreFirstLine) {
                        this.addVerticalLine(x, top, bottom);
                        if (insertionInColumn) {
                            this.insertedCellBounds.x = x + halfLineWidth1;
                        }
                    }
                    ignoreFirstLine = false;
                    int colWidth = i == numCols - 1 && ins == null ? (int)Math.ceil(right - x) : col.getHead().getFigure().getBounds().width + minorSpacing;
                    if (ins != null && i == ins.getIndex()) {
                        block = this.addBlock(null, new PrecisionRectangle(x, top, (double)colWidth, bottom - top));
                        block.alpha = 96;
                        this.addVerticalLine(x += (double)insWidth, top, bottom);
                        x += (double)lineWidth;
                        ins = null;
                    }
                    this.addBlock((IGraphicalPart)col.getHead(), new PrecisionRectangle(x, top, (double)colWidth, bottom - top));
                    x += (double)colWidth;
                    if (insertionInColumn) {
                        this.insertedCellBounds.width = x + halfLineWidth1 - this.insertedCellBounds.x;
                        insertionInColumn = false;
                    }
                    ++i;
                }
                if (ins != null && ins.getIndex() == numCols) {
                    this.addVerticalLine(x + halfLineWidth1, top, bottom);
                    Block block2 = this.addBlock(null, new PrecisionRectangle(x, top, (double)((int)Math.ceil(right - x)), top - bottom));
                    block2.alpha = 96;
                }
                IInsertion rowIns = (IInsertion)MindMapUtils.getCache((IPart)this.branch, (String)"org.xmind.ui.spreadsheet.cache.rowInsertion");
                int i2 = 0;
                while (i2 < numRows) {
                    boolean insertionInRow;
                    if (rowIns != null && rowIns.getIndex() == i2) {
                        int rowInsHeight = rowIns.getSize().height + lineWidth;
                        block = this.addBlock(null, new PrecisionRectangle(left, y + halfLineWidth1, right - left, (double)rowInsHeight));
                        block.alpha = 96;
                        this.addHorizontalLine(left, right, y + halfLineWidth1);
                        y += (double)rowInsHeight;
                    }
                    Row2 row = chart.getRow(i2);
                    RowHead rowHead = row.getHead();
                    boolean bl = insertionInRow = insertionRowHead != null && insertionRowHead.equals(rowHead) && this.insertedCellBounds != null;
                    if (insertionInRow) {
                        this.insertedCellBounds.y = y + halfLineWidth1;
                    }
                    this.addHorizontalLine(left, right, y);
                    double rowHeight = row.getPrefHeight() + minorSpacing;
                    PrecisionRectangle rowHeadBounds = new PrecisionRectangle(rowHeadLeft, y + (double)lineWidth, rowHeadWidth, rowHeight);
                    String text = rowHead.toString();
                    Dimension size = rowHead.getPrefSize();
                    Text rowHeadText = this.addRowHeadText(rowHeadBounds, text, this.center(rowHeadBounds, size.width, size.height));
                    rowHeadText.font = rowHead.getFont();
                    y += (double)lineWidth + rowHeight;
                    if (insertionInRow) {
                        this.insertedCellBounds.height = i2 == numRows - 1 ? bottom - this.insertedCellBounds.y : y + halfLineWidth1 - this.insertedCellBounds.y;
                    }
                    ++i2;
                }
                if (rowIns != null && rowIns.getIndex() == numRows) {
                    this.addHorizontalLine(left, right, y + halfLineWidth1);
                    int rowInsHeight = rowIns.getSize().height + minorSpacing + lineWidth;
                    Block block3 = this.addBlock(null, new PrecisionRectangle(left, y, right - left, (double)rowInsHeight));
                    block3.alpha = 96;
                }
            }
        }
    }

    private Point center(PrecisionRectangle bounds, int width, int height) {
        double x = bounds.x + (bounds.width - (double)width) / 2.0;
        double y = bounds.y + (bounds.height - (double)height) / 2.0;
        return new Point((int)x, (int)y);
    }

    List<Block> getBlocks() {
        return this.blocks;
    }

    private Block addBlock(IGraphicalPart part, PrecisionRectangle bounds) {
        if (this.blocks == null) {
            this.blocks = new ArrayList<Block>();
        }
        Block block = new Block(bounds, part);
        this.blocks.add(block);
        return block;
    }

    private Text addRowHeadText(PrecisionRectangle bounds, String text, Point textLocation) {
        if (this.rowHeads == null) {
            this.rowHeads = new ArrayList<Text>();
        }
        Text rowHeadText = new Text(bounds, text, textLocation);
        this.rowHeads.add(rowHeadText);
        return rowHeadText;
    }

    private void addHorizontalLine(double x1, double x2, double y) {
        this.lines.add(new PrecisionLine(x1, y, x2, y));
    }

    private void addVerticalLine(double x, double y1, double y2) {
        this.lines.add(new PrecisionLine(x, y1, x, y2));
    }

    protected int getMinorSpacing() {
        return StyleUtils.getInteger((IGraphicalPart)this.branch, (IStyleSelector)StyleUtils.getStyleSelector((IGraphicalPart)this.branch), (String)"spacing-minor", (int)5);
    }

    protected int getMajorSpacing() {
        return StyleUtils.getMajorSpacing((IGraphicalPart)this.branch, (int)5);
    }

    private Chart2 getChart() {
        IStructure sa = this.branch.getBranchPolicy().getStructure((IGraphicalPart)this.branch);
        if (sa instanceof SpreadsheetColumnStructure) {
            return ((SpreadsheetColumnStructure)sa).getChart(this.branch);
        }
        return null;
    }

    private ITopicDecoration getTopicDecoration() {
        IDecoration decoration;
        IFigure topicFigure = this.getTopicFigure();
        if (topicFigure instanceof IDecoratedFigure && (decoration = ((IDecoratedFigure)topicFigure).getDecoration()) instanceof ITopicDecoration) {
            return (ITopicDecoration)decoration;
        }
        return null;
    }

    private IFigure getTopicFigure() {
        ITopicPart topicPart = this.branch.getTopicPart();
        return topicPart == null ? null : topicPart.getFigure();
    }

    public void invalidate() {
        super.invalidate();
        this.bounds = null;
        this.rowHeads = null;
        this.blocks = null;
        this.lines = null;
        this.insertedCellBounds = null;
    }

    private Color getTextColor() {
        ITitleTextPart title;
        ITopicPart topicPart = this.branch.getTopicPart();
        if (topicPart != null && (title = topicPart.getTitle()) != null) {
            return title.getFigure().getForegroundColor();
        }
        return null;
    }

    protected void performPaint(IFigure figure, Graphics graphics) {
        int corner;
        Color fillColor;
        int fillAlpha;
        graphics.setAntialias(1);
        ITopicDecoration topicDecoration = this.getTopicDecoration();
        if (topicDecoration != null) {
            fillAlpha = topicDecoration.getFillAlpha();
            fillColor = topicDecoration.getFillColor();
            corner = this.getCornerSize(topicDecoration);
        } else {
            fillColor = null;
            fillAlpha = 255;
            corner = 0;
        }
        if (this.bounds != null) {
            graphics.pushState();
            int alpha = this.getAlpha() * fillAlpha / 255;
            org.xmind.gef.draw2d.graphics.Path path = new org.xmind.gef.draw2d.graphics.Path((Device)Display.getCurrent());
            this.addOutline(path, this.bounds, corner);
            try {
                if (fillColor != null) {
                    graphics.setAlpha(alpha);
                    graphics.setBackgroundColor(fillColor);
                    graphics.fillPath((Path)path);
                    graphics.restoreState();
                }
                if (this.blocks != null && !this.blocks.isEmpty()) {
                    for (Block block : this.blocks) {
                        block.paint(graphics, path, alpha, graphics.getClip(CLIP_RECT));
                    }
                }
                if (this.rowHeads != null && !this.rowHeads.isEmpty()) {
                    Color textColor = this.getTextColor();
                    for (Text head : this.rowHeads) {
                        graphics.setTextAntialias(1);
                        graphics.setForegroundColor(textColor);
                        head.paint(graphics, graphics.getClip(CLIP_RECT));
                    }
                }
            }
            finally {
                path.dispose();
                graphics.popState();
            }
        }
    }

    private void addOutline(org.xmind.gef.draw2d.graphics.Path path, PrecisionRectangle bounds, int corner) {
        if (corner == 0) {
            path.addRectangle(bounds);
        } else {
            path.addRoundedRectangle(bounds, (float)corner);
        }
    }

    private int getCornerSize(ITopicDecoration topicDecoration) {
        int corner = topicDecoration instanceof ICorneredDecoration ? ((ICorneredDecoration)topicDecoration).getCornerSize() : 0;
        return corner;
    }

    public void paintAboveChildren(IFigure figure, Graphics graphics) {
        if (!this.isVisible()) {
            return;
        }
        this.checkValidation(figure);
        ITopicDecoration topicDecoration = this.getTopicDecoration();
        if (topicDecoration == null) {
            return;
        }
        Color lineColor = topicDecoration.getLineColor();
        if (lineColor == null) {
            return;
        }
        int lineAlpha = topicDecoration.getLineAlpha();
        int lineWidth = topicDecoration.getLineWidth();
        int lineStyle = topicDecoration.getLineStyle();
        int corner = 2;
        graphics.setAntialias(1);
        if (this.bounds != null || this.lines != null && !this.lines.isEmpty() || this.insertedCellBounds != null) {
            graphics.setAlpha(this.getAlpha() * lineAlpha / 255);
            graphics.setLineWidth(lineWidth);
            graphics.setLineStyle(lineStyle);
            graphics.setForegroundColor(lineColor);
            org.xmind.gef.draw2d.graphics.Path path = new org.xmind.gef.draw2d.graphics.Path((Device)Display.getCurrent());
            if (this.bounds != null) {
                this.addOutline(path, this.bounds, corner);
            }
            if (this.lines != null && !this.lines.isEmpty()) {
                for (PrecisionLine line : this.lines) {
                    path.moveTo(line.getOrigin());
                    path.lineTo(line.getTerminus());
                }
            }
            graphics.drawPath((Path)path);
            path.dispose();
            if (this.insertedCellBounds != null) {
                graphics.setAlpha(128);
                graphics.setLineWidth(lineWidth + 2);
                graphics.setForegroundColor(ColorUtils.getColor((String)"#f00000"));
                path = new org.xmind.gef.draw2d.graphics.Path((Device)Display.getCurrent());
                path.addRectangle(this.insertedCellBounds);
                graphics.drawPath((Path)path);
                path.dispose();
            }
        }
    }

    static class Block {
        PrecisionRectangle bounds;
        IGraphicalPart part;
        int alpha = 255;

        public Block(PrecisionRectangle bounds, IGraphicalPart part) {
            this.bounds = bounds;
            this.part = part;
        }

        public void paint(Graphics graphics, org.xmind.gef.draw2d.graphics.Path path, int alpha, Rectangle clipRect) {
            if (!this.bounds.intersects(clipRect)) {
                return;
            }
            Color fillColor = this.getFillColor();
            if (fillColor == null) {
                return;
            }
            graphics.clipRect(this.bounds.toDraw2DRectangle());
            graphics.setBackgroundColor(fillColor);
            graphics.setAlpha(alpha * this.alpha / 255);
            graphics.fillPath((Path)path);
            graphics.restoreState();
        }

        private Color getFillColor() {
            if (this.part == null) {
                return ColorConstants.gray;
            }
            IStyleSelector ss = StyleUtils.getStyleSelector((IGraphicalPart)this.part);
            String decorationId = StyleUtils.getString((IGraphicalPart)this.part, (IStyleSelector)ss, (String)"shape-class", null);
            return StyleUtils.getColor((IGraphicalPart)this.part, (IStyleSelector)ss, (String)"svg:fill", (String)decorationId, null);
        }
    }

    private static class Text {
        PrecisionRectangle bounds;
        String text;
        Font font;
        Point textLocation;

        public Text(PrecisionRectangle bounds, String text, Point textLocation) {
            this.bounds = bounds;
            this.text = text;
            this.textLocation = textLocation;
        }

        public void paint(Graphics graphics, Rectangle clipRect) {
            if (!this.bounds.intersects(clipRect)) {
                return;
            }
            graphics.clipRect(this.bounds.toDraw2DRectangle());
            if (this.font != null) {
                graphics.setFont(this.font);
            }
            graphics.drawText(this.text, this.textLocation);
            graphics.restoreState();
        }
    }
}

