/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.command.transfer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.xmind.core.command.Command;
import org.xmind.core.command.ICommand;
import org.xmind.core.command.ICommandService;
import org.xmind.core.command.IReturnValueConsumer;
import org.xmind.core.command.ReturnValue;
import org.xmind.core.command.arguments.Attributes;
import org.xmind.core.command.binary.IBinaryStore;
import org.xmind.core.command.transfer.ChunkReader;
import org.xmind.core.command.transfer.ChunkWriter;
import org.xmind.core.command.transfer.CommandTransferUtil;
import org.xmind.core.internal.command.remote.Messages;
import org.xmind.core.internal.command.remote.RemoteCommandPlugin;

public class IncomingCommandHandler {
    private static final String DEBUG_OPTION = "/debug/incomingCommandHandler";
    private static boolean DEBUGGING = RemoteCommandPlugin.getDefault().isDebugging("/debug/incomingCommandHandler");
    private Object remoteLocation = "(unknown location)";
    private String pluginId = "org.xmind.core.command.remote";

    public void setRemoteLocation(Object location) {
        if (location == null) {
            location = "(unknown location)";
        }
        this.remoteLocation = location;
    }

    public Object getRemoteLocation() {
        return this.remoteLocation;
    }

    public void setPluginId(String pluginId) {
        if (pluginId == null) {
            pluginId = "org.xmind.core.command.remote";
        }
        this.pluginId = pluginId;
    }

    public String getPluginId() {
        return this.pluginId;
    }

    public IStatus handleIncomingCommand(IProgressMonitor monitor, InputStream input, OutputStream output) {
        ChunkReader reader = new ChunkReader(input);
        try {
            IStatus iStatus;
            ChunkWriter writer = new ChunkWriter(output);
            try {
                iStatus = this.handleIncomingCommand(monitor, reader, writer);
            }
            catch (Throwable throwable) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    RemoteCommandPlugin.log(null, e);
                }
                throw throwable;
            }
            try {
                writer.close();
            }
            catch (IOException e) {
                RemoteCommandPlugin.log(null, e);
            }
            return iStatus;
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {
                RemoteCommandPlugin.log(null, e);
            }
        }
    }

    public IStatus handleIncomingCommand(IProgressMonitor monitor, ChunkReader reader, ChunkWriter writer) {
        ICommand command;
        monitor.beginTask(null, 100);
        monitor.subTask(Messages.IncomingCommandHandler_ReadCommand);
        SubProgressMonitor readMonitor = new SubProgressMonitor(monitor, 10);
        try {
            command = this.readCommand((IProgressMonitor)readMonitor, reader);
        }
        catch (Throwable e) {
            return this.createReadingErrorStatus(e);
        }
        if (command == null || monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        readMonitor.done();
        try {
            monitor.subTask(NLS.bind((String)Messages.IncomingCommandHandler_ExcuteCommand, (Object)command));
            SubProgressMonitor executeMonitor = new SubProgressMonitor(monitor, 90);
            IStatus returnValue = this.executeCommand((IProgressMonitor)executeMonitor, command, writer);
            if (returnValue != null && !returnValue.isOK()) {
                IStatus iStatus = returnValue;
                return iStatus;
            }
            if (monitor.isCanceled()) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            executeMonitor.done();
            monitor.done();
            IStatus iStatus = returnValue;
            return iStatus;
        }
        finally {
            IBinaryStore binaryStore = command.getBinaryStore();
            if (binaryStore != null) {
                binaryStore.clear();
            }
        }
    }

    private ICommand readCommand(IProgressMonitor monitor, ChunkReader reader) throws IOException {
        String uri;
        monitor.beginTask(null, 100);
        if (DEBUGGING) {
            System.out.println("Start reading command from " + this.remoteLocation);
        }
        if ((uri = reader.readText()) == null) {
            return null;
        }
        if (DEBUGGING) {
            System.out.println("Request received: " + uri);
        }
        if (monitor.isCanceled()) {
            return null;
        }
        monitor.worked(50);
        String argumentType = reader.readText();
        if (monitor.isCanceled()) {
            return null;
        }
        IBinaryStore files = null;
        SubProgressMonitor filesMonitor = new SubProgressMonitor(monitor, 40);
        if ("[FILES]".equals(argumentType)) {
            files = CommandTransferUtil.readFiles((IProgressMonitor)filesMonitor, reader);
            if (DEBUGGING) {
                System.out.println("Files received: " + files);
            }
        }
        if (monitor.isCanceled()) {
            return null;
        }
        filesMonitor.done();
        Command command = Command.parseURI((String)uri, (IBinaryStore)files);
        if (monitor.isCanceled()) {
            return null;
        }
        monitor.done();
        return command;
    }

    private IStatus executeCommand(IProgressMonitor monitor, ICommand command, final ChunkWriter writer) {
        ICommandService commandService = RemoteCommandPlugin.getDefault().getCommandService();
        if (commandService == null) {
            try {
                this.writeReturnValue(monitor, (IStatus)new Status(4, this.getPluginId(), "No command handling service available."), writer);
            }
            catch (IOException e) {
                RemoteCommandPlugin.log(null, e);
            }
            return new Status(2, this.getPluginId(), "No command handling service available.");
        }
        if (monitor.isCanceled()) {
            try {
                this.writeReturnValue(monitor, Status.CANCEL_STATUS, writer);
            }
            catch (IOException e) {
                RemoteCommandPlugin.log(null, e);
            }
            return Status.CANCEL_STATUS;
        }
        IStatus returnValue = commandService.execute(monitor, command, new IReturnValueConsumer(){

            public IStatus consumeReturnValue(IProgressMonitor monitor, IStatus returnValue) {
                try {
                    IncomingCommandHandler.this.writeReturnValue(monitor, returnValue, writer);
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    return Status.OK_STATUS;
                }
                catch (Throwable e) {
                    return IncomingCommandHandler.this.createWritingErrorStatus(e);
                }
            }
        });
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        monitor.done();
        return returnValue;
    }

    private void writeReturnValue(IProgressMonitor monitor, IStatus returnValue, ChunkWriter writer) throws IOException {
        if (DEBUGGING) {
            System.out.println("Command executed: " + returnValue);
        }
        monitor.beginTask(null, 100);
        monitor.subTask(Messages.IncomingCommandHandler_WriteReponseBack);
        writer.writeText(String.valueOf(returnValue.getSeverity()));
        monitor.worked(10);
        writer.writeText(returnValue.getPlugin() == null ? "" : returnValue.getPlugin());
        monitor.worked(10);
        writer.writeText(String.valueOf(returnValue.getCode()));
        monitor.worked(10);
        writer.writeText(returnValue.getMessage());
        monitor.worked(10);
        SubProgressMonitor writeValueMonitor = new SubProgressMonitor(monitor, 40);
        this.writeValue((IProgressMonitor)writeValueMonitor, writer, returnValue);
        if (writeValueMonitor.isCanceled()) {
            return;
        }
        writeValueMonitor.done();
        writer.writeText("");
        monitor.worked(10);
        writer.flush();
        monitor.worked(10);
        monitor.done();
    }

    private void writeValue(IProgressMonitor monitor, ChunkWriter writer, IStatus returnValue) throws IOException {
        if (returnValue.isOK() && returnValue instanceof ReturnValue) {
            Object value = ((ReturnValue)returnValue).getValue();
            if (value instanceof Attributes) {
                Attributes attrs = (Attributes)value;
                monitor.beginTask(null, attrs.size());
                writer.writeText("[PROPERTIES]");
                Iterator names = attrs.keys();
                while (names.hasNext()) {
                    String name = (String)names.next();
                    writer.writeText(CommandTransferUtil.encode(name));
                    writer.writeText(CommandTransferUtil.encode(attrs.getString(name, "")));
                    monitor.worked(1);
                }
            } else if (value instanceof String[]) {
                String[] strings = (String[])value;
                monitor.beginTask(null, strings.length);
                writer.writeText("[VALUES]");
                int i = 0;
                while (i < strings.length) {
                    writer.writeText(CommandTransferUtil.encode(strings[i]));
                    monitor.worked(1);
                    ++i;
                }
            } else if (value instanceof IBinaryStore) {
                IBinaryStore files = (IBinaryStore)value;
                writer.writeText("[FILES]");
                CommandTransferUtil.writeFiles(monitor, files, writer);
            }
        }
    }

    protected IStatus createReadingErrorStatus(Throwable e) {
        return new Status(4, this.getPluginId(), null, e);
    }

    protected IStatus createWritingErrorStatus(Throwable e) {
        return new Status(4, this.getPluginId(), null, e);
    }
}

