/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.net.internal;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;

public class EncodingUtils {
    public static final String DEFAULT_ENCODING = "UTF-8";
    public static final String LATIN1 = "ISO-8859-1";
    private static final char[] intToBase64 = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};

    private EncodingUtils() {
    }

    public static String urlEncode(Object object) {
        String text = object == null ? "" : String.valueOf(object);
        try {
            return URLEncoder.encode(text, DEFAULT_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            throw EncodingUtils.wrapEncodingException(e, DEFAULT_ENCODING);
        }
    }

    public static String urlDecode(String text) {
        if (text == null) {
            return "";
        }
        try {
            return URLDecoder.decode(text, DEFAULT_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            throw EncodingUtils.wrapEncodingException(e, DEFAULT_ENCODING);
        }
    }

    public static String format(String pattern, Object ... values) {
        Object[] encodedValues = new Object[values.length];
        int i = 0;
        while (i < values.length) {
            encodedValues[i] = EncodingUtils.urlEncode(values[i]);
            ++i;
        }
        return String.format(pattern, encodedValues);
    }

    public static byte[] toDefaultBytes(String str) {
        return EncodingUtils.toBytes(str, DEFAULT_ENCODING);
    }

    public static String toDefaultString(byte[] bytes) {
        return EncodingUtils.toString(bytes, DEFAULT_ENCODING);
    }

    public static byte[] toAsciiBytes(String str) {
        return EncodingUtils.toBytes(str, LATIN1);
    }

    public static String toAsciiString(byte[] bytes) {
        return EncodingUtils.toString(bytes, LATIN1);
    }

    private static byte[] toBytes(String str, String charsetName) {
        try {
            return str.getBytes(charsetName);
        }
        catch (UnsupportedEncodingException e) {
            throw EncodingUtils.wrapEncodingException(e, charsetName);
        }
    }

    private static String toString(byte[] bytes, String charsetName) {
        try {
            return new String(bytes, charsetName);
        }
        catch (UnsupportedEncodingException e) {
            throw EncodingUtils.wrapEncodingException(e, charsetName);
        }
    }

    public static AssertionError wrapEncodingException(UnsupportedEncodingException e, String charsetName) {
        return new AssertionError(String.format("Encoding not supported: %s", charsetName), e);
    }

    public static char[] base64Encode(byte[] a) {
        int aLen = a.length;
        int numFullGroups = aLen / 3;
        int numBytesInPartialGroup = aLen - 3 * numFullGroups;
        int resultLen = 4 * ((aLen + 2) / 3);
        char[] result = new char[resultLen];
        char[] intToAlpha = intToBase64;
        int inCursor = 0;
        int outCursor = 0;
        int i = 0;
        while (i < numFullGroups) {
            int byte0 = a[inCursor++] & 0xFF;
            int byte1 = a[inCursor++] & 0xFF;
            int byte2 = a[inCursor++] & 0xFF;
            result[outCursor++] = intToAlpha[byte0 >> 2];
            result[outCursor++] = intToAlpha[byte0 << 4 & 0x3F | byte1 >> 4];
            result[outCursor++] = intToAlpha[byte1 << 2 & 0x3F | byte2 >> 6];
            result[outCursor++] = intToAlpha[byte2 & 0x3F];
            ++i;
        }
        if (numBytesInPartialGroup != 0) {
            int byte0 = a[inCursor++] & 0xFF;
            result[outCursor++] = intToAlpha[byte0 >> 2];
            if (numBytesInPartialGroup == 1) {
                result[outCursor++] = intToAlpha[byte0 << 4 & 0x3F];
                result[outCursor++] = 61;
                result[outCursor++] = 61;
            } else {
                int byte1 = a[inCursor++] & 0xFF;
                result[outCursor++] = intToAlpha[byte0 << 4 & 0x3F | byte1 >> 4];
                result[outCursor++] = intToAlpha[byte1 << 2 & 0x3F];
                result[outCursor++] = 61;
            }
        }
        return result;
    }
}

