/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.meggy;

import java.util.Iterator;
import net.xmind.verify.ui.VerifyUI20141031;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.xmind.core.INamed;
import org.xmind.core.ITitled;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.gef.ui.editor.IGraphicalEditorPage;
import org.xmind.ui.internal.meggy.Messages;
import org.xmind.ui.search.SearchEngine;

public class SearchHandler
extends AbstractHandler {
    private static final String SEP = " ";

    public Object execute(final ExecutionEvent event) throws ExecutionException {
        VerifyUI20141031.runAction20141031((String)"SearchInWeb", (String)Messages.SearchInWebAction_name, (int)3, (Runnable)new Runnable(){

            public void run() {
                SearchHandler.this.search(event);
                VerifyUI20141031.getUsageDataCollector().increase("SearchInWebCount");
            }
        }, null);
        return null;
    }

    private void search(ExecutionEvent event) {
        IEditorPart editor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        if (!(editor instanceof IGraphicalEditor)) {
            return;
        }
        IGraphicalEditorPage page = ((IGraphicalEditor)editor).getActivePageInstance();
        if (page == null) {
            return;
        }
        ISelectionProvider provider = page.getSelectionProvider();
        if (provider == null) {
            return;
        }
        ISelection selection = provider.getSelection();
        String searchTerms = this.createSearchTerms(selection);
        if (searchTerms == null || "".equals(searchTerms)) {
            return;
        }
        SearchEngine.getDefault().search(searchTerms);
    }

    private String createSearchTerms(ISelection selection) {
        if (!(selection instanceof IStructuredSelection) || selection.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        Iterator it = ((IStructuredSelection)selection).iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (o instanceof ITitled) {
                sb.append(((ITitled)o).getTitleText());
                if (!it.hasNext()) continue;
                sb.append(SEP);
                continue;
            }
            if (!(o instanceof INamed)) continue;
            sb.append(((INamed)o).getName());
            if (!it.hasNext()) continue;
            sb.append(SEP);
        }
        return sb.toString();
    }
}

