/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.commands;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.ui.ISourceProvider;
import org.xmind.core.ITopic;
import org.xmind.core.ITopicExtension;
import org.xmind.core.ITopicExtensionElement;
import org.xmind.gef.command.ModifyCommand;
import org.xmind.ui.internal.MindMapUIPlugin;

public class ModifyTopicStructureCommand
extends ModifyCommand {
    private static final String STRUCTUREID_UNBALANCED = "org.xmind.ui.map.unbalanced";
    private static final String EXTENTION_UNBALANCEDSTRUCTURE = "org.xmind.ui.map.unbalanced";
    private static final String EXTENTIONELEMENT_RIGHTNUMBER = "right-number";
    private static final String INVALID_RIGHT_NUMBER = "-1";
    private Map<ITopicExtension, String> extToRightNum = new HashMap<ITopicExtension, String>();

    public ModifyTopicStructureCommand(ITopic source, String newStructureClass) {
        super((Object)source, (Object)newStructureClass);
        ITopicExtension topicExtension = source.getExtension("org.xmind.ui.map.unbalanced");
        if (topicExtension != null) {
            String rightNum = ((ITopicExtensionElement)topicExtension.getContent().getCreatedChild(EXTENTIONELEMENT_RIGHTNUMBER)).getTextContent();
            this.extToRightNum.put(topicExtension, rightNum);
        }
    }

    public ModifyTopicStructureCommand(Collection<ITopic> sources, String newStructureClass) {
        super(sources, (Object)newStructureClass);
        for (ITopic topic : sources) {
            ITopicExtension extension = topic.getExtension("org.xmind.ui.map.unbalanced");
            if (extension == null) continue;
            String rightNum = ((ITopicExtensionElement)extension.getContent().getCreatedChild(EXTENTIONELEMENT_RIGHTNUMBER)).getTextContent();
            this.extToRightNum.put(extension, rightNum);
        }
    }

    public ModifyTopicStructureCommand(ISourceProvider sourceProvider, String newStructureClass) {
        super((Object)sourceProvider, (Object)newStructureClass);
    }

    protected Object getValue(Object source) {
        if (source instanceof ITopic) {
            return ((ITopic)source).getStructureClass();
        }
        return null;
    }

    protected void setValue(Object source, Object value) {
        if (source instanceof ITopic) {
            ITopic topic = (ITopic)source;
            if (value == null || value instanceof String) {
                boolean has;
                ITopicExtension extension;
                String oldStructure = topic.getStructureClass();
                if ("org.xmind.ui.map.unbalanced".equals(oldStructure)) {
                    extension = topic.createExtension("org.xmind.ui.map.unbalanced");
                    ITopicExtensionElement rightNum = (ITopicExtensionElement)extension.getContent().getCreatedChild(EXTENTIONELEMENT_RIGHTNUMBER);
                    rightNum.setTextContent(INVALID_RIGHT_NUMBER);
                } else if ("org.xmind.ui.map.unbalanced".equals(value) && (has = this.extToRightNum.containsKey(extension = topic.createExtension("org.xmind.ui.map.unbalanced")))) {
                    String rightNum = this.extToRightNum.get(extension);
                    ((ITopicExtensionElement)extension.getContent().getCreatedChild(EXTENTIONELEMENT_RIGHTNUMBER)).setTextContent(rightNum);
                }
                if (value != null) {
                    String vs = value.toString();
                    String ID = vs.replaceAll("\\.", "_");
                    MindMapUIPlugin.getDefault().getUsageDataCollector().increase(String.format("Structure/TypeCount/%s", ID));
                }
                topic.setStructureClass((String)value);
            }
        }
    }

    public void execute() {
        MindMapUIPlugin.getDefault().getUsageDataCollector().increase("ModifyStructureCount");
        super.execute();
    }
}

