/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.branch;

import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.xmind.ui.util.Logger;

public class UnmodifiableProperty {
    private IConfigurationElement element;
    private String primaryKey;
    private String secondaryKey;
    private Expression condition;

    public UnmodifiableProperty(IConfigurationElement element) throws CoreException {
        this.element = element;
        this.primaryKey = element.getAttribute("primaryKey");
        if (this.primaryKey == null) {
            throw new CoreException((IStatus)new Status(4, element.getNamespaceIdentifier(), 0, "Invalid extension (missing primary key): " + element, null));
        }
        this.secondaryKey = element.getAttribute("secondaryKey");
        this.initializeEnablement();
    }

    private void initializeEnablement() {
        IConfigurationElement[] children = this.element.getChildren("enablement");
        if (children.length == 0) {
            return;
        }
        try {
            this.condition = ExpressionConverter.getDefault().perform(children[0]);
        }
        catch (CoreException e) {
            Logger.log(e, "Failed to convert expression: " + children[0]);
        }
    }

    public String getPrimaryKey() {
        return this.primaryKey;
    }

    public String getSecondaryKey() {
        return this.secondaryKey;
    }

    boolean isApplicableTo(IEvaluationContext context) {
        if (this.condition == null) {
            return false;
        }
        try {
            EvaluationResult result = this.condition.evaluate(context);
            return result == EvaluationResult.TRUE;
        }
        catch (CoreException e) {
            Logger.log(e, "Evaluation failed: " + context);
            return false;
        }
    }
}

