/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.editpolicies;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.xmind.gef.Request;
import org.xmind.gef.graphicalpolicy.IStructure;
import org.xmind.gef.part.IPart;
import org.xmind.ui.branch.INavigableBranchStructureExtension;
import org.xmind.ui.internal.editpolicies.MindMapNavigablePolicyBase;
import org.xmind.ui.internal.editpolicies.PositionSearcher;
import org.xmind.ui.mindmap.IBranchPart;
import org.xmind.ui.mindmap.ISheetPart;
import org.xmind.ui.mindmap.ITopicPart;
import org.xmind.ui.util.MindMapUtils;

public class TopicNavigablePolicy
extends MindMapNavigablePolicyBase {
    private boolean ignoreCache = true;

    public boolean understands(String requestType) {
        return super.understands(requestType) || "navigate_child".equals(requestType) || "navigate_sibling".equals(requestType);
    }

    public void handle(Request request) {
        String reqType = request.getType();
        if ("navigate_child".equals(reqType)) {
            this.navChild(request);
        } else if ("navigate_sibling".equals(reqType)) {
            this.navSibling(request);
        } else {
            super.handle(request);
        }
    }

    private void navChild(Request request) {
        ITopicPart childTopicPart;
        IBranchPart child;
        ITopicPart topicPart;
        IBranchPart branch;
        IPart source = request.getPrimaryTarget();
        if (source instanceof ITopicPart && (branch = (topicPart = (ITopicPart)source).getOwnerBranch()) != null && (child = this.findFirstChild(branch)) != null && (childTopicPart = child.getTopicPart()) != null) {
            this.setNavigationResult(request, Arrays.asList(childTopicPart));
        }
    }

    private void navSibling(Request request) {
        ITopicPart topicPart;
        IBranchPart branch;
        IPart source = request.getPrimaryTarget();
        if (source instanceof ITopicPart && (branch = (topicPart = (ITopicPart)source).getOwnerBranch()) != null) {
            IBranchPart sibling;
            IBranchPart child;
            if (branch.isCentral() && (child = this.findFirstChild(branch)) != null) {
                this.setNavigationResult(request, Arrays.asList(child.getTopicPart()));
            }
            if ((sibling = this.findSucceedingSiblingOrAncestor(branch)) != branch) {
                this.setNavigationResult(request, Arrays.asList(sibling.getTopicPart()));
            }
        }
    }

    @Override
    protected IPart findNewNavParts(Request request, String navType, List<IPart> sources) {
        IPart navPart;
        IBranchPart branch;
        ITopicPart topicPart = MindMapUtils.findTopicPart(request.getPrimaryTarget());
        if (topicPart != null && (branch = topicPart.getOwnerBranch()) != null && (navPart = this.findNavPart(branch, navType)) != null && navPart.getStatus().isActive()) {
            return navPart;
        }
        return null;
    }

    private IPart findNavPart(IBranchPart branch, String navType) {
        IStructure structure = branch.getBranchPolicy().getStructure(branch);
        if (structure instanceof INavigableBranchStructureExtension) {
            IPart navPart = ((INavigableBranchStructureExtension)structure).calcNavigation(branch, navType);
            if (navPart == null) {
                IBranchPart parent = branch.getParentBranch();
                if (parent != null) {
                    IStructure parentStructure = parent.getBranchPolicy().getStructure(parent);
                    if (parentStructure instanceof INavigableBranchStructureExtension) {
                        navPart = ((INavigableBranchStructureExtension)parentStructure).calcChildNavigation(parent, branch, navType, false);
                    }
                } else {
                    navPart = this.calcNavThroughFloatingAndCentral(branch, navType);
                }
                if (navPart == null) {
                    this.ignoreCache = true;
                    navPart = this.calcNavByPosition(branch, navType);
                }
            }
            return navPart;
        }
        return null;
    }

    @Override
    protected void setNavCaches(List<IPart> sources, IPart target, String navType) {
        this.ignoreCache = false;
    }

    private IPart calcNavThroughFloatingAndCentral(IBranchPart branch, String navType) {
        return this.calcNavByPosition(branch, navType);
    }

    private IPart calcNavByPosition(IBranchPart branch, String navType) {
        return new PositionSearcher(branch, navType).search();
    }

    protected void findSequentialNavParts(Request request, String navType, IPart sequenceStart, List<IPart> sources, List<IPart> result) {
        ITopicPart startTopic = MindMapUtils.findTopicPart(sequenceStart);
        if (startTopic != null) {
            ITopicPart sourceTopic = MindMapUtils.findTopicPart(request.getPrimaryTarget());
            if (sourceTopic != null && this.isSibling(sourceTopic, startTopic)) {
                IBranchPart startBranch = startTopic.getOwnerBranch();
                IBranchPart sourceBranch = sourceTopic.getOwnerBranch();
                IBranchPart sourceParentBranch = sourceBranch.getParentBranch();
                if (sourceParentBranch != null) {
                    IStructure parentStructure = sourceParentBranch.getBranchPolicy().getStructure(sourceParentBranch);
                    if (parentStructure instanceof INavigableBranchStructureExtension) {
                        INavigableBranchStructureExtension ext = (INavigableBranchStructureExtension)parentStructure;
                        IPart endPart = ext.calcChildNavigation(sourceParentBranch, sourceBranch, navType, true);
                        IBranchPart endBranch = MindMapUtils.findBranch(endPart);
                        if (endBranch == null) {
                            endBranch = sourceBranch;
                        }
                        ArrayList<IBranchPart> list = new ArrayList<IBranchPart>();
                        ext.calcSequentialNavigation(sourceParentBranch, startBranch, endBranch, list);
                        for (IBranchPart branch : list) {
                            result.add((IPart)branch.getTopicPart());
                        }
                        request.setResult("newFocus", (Object)endBranch.getTopicPart());
                    }
                } else {
                    this.addSeqPartsFromFloatingAndCentral(navType, sourceBranch, startBranch, result);
                }
            }
            if (!result.contains(startTopic)) {
                result.add((IPart)startTopic);
            }
        } else {
            super.findSequentialNavParts(request, navType, sequenceStart, sources, result);
        }
    }

    private void addSeqPartsFromFloatingAndCentral(String navType, IBranchPart sourceBranch, IBranchPart startBranch, List<IPart> result) {
    }

    private boolean isSibling(ITopicPart t1, ITopicPart t2) {
        IBranchPart b1 = t1.getOwnerBranch();
        IBranchPart b2 = t2.getOwnerBranch();
        if (b1 != null && b2 != null) {
            return b1.getParentBranch() == b2.getParentBranch();
        }
        return false;
    }

    protected IPart findNextOrPrev(IPart source, boolean nextOrPrev) {
        if (source != null) {
            return this.findNextOrPrevTopic(source, nextOrPrev);
        }
        return super.findNextOrPrev(source, nextOrPrev);
    }

    private IPart findNextOrPrevTopic(IPart current, boolean nextOrPrev) {
        IBranchPart branch;
        if (current instanceof ITopicPart && (branch = ((ITopicPart)current).getOwnerBranch()) != null) {
            IBranchPart result;
            if (nextOrPrev) {
                result = this.findFirstChild(branch);
                if (result == null) {
                    result = this.findSucceedingSiblingOrAncestor(branch);
                }
            } else {
                result = this.findPrecedingBranch(branch);
            }
            if (result != null) {
                return result.getTopicPart();
            }
        }
        return current;
    }

    private IBranchPart findFirstChild(IBranchPart current) {
        List<IBranchPart> subBranches = current.getSubBranches();
        if (!subBranches.isEmpty()) {
            return subBranches.get(0);
        }
        subBranches = current.getSummaryBranches();
        if (!subBranches.isEmpty()) {
            return subBranches.get(0);
        }
        return null;
    }

    private IBranchPart findSucceedingSiblingOrAncestor(IBranchPart current) {
        IBranchPart parent = current.getParentBranch();
        if (parent != null) {
            List<IBranchPart> branches = parent.getSubBranches();
            int index = branches.indexOf(current);
            if (index >= 0 && index < branches.size() - 1) {
                return branches.get(index + 1);
            }
            int lastBranchIndex = branches.size() - 1;
            branches = parent.getSummaryBranches();
            if (branches.size() > 0 && index == lastBranchIndex) {
                return branches.get(0);
            }
            index = branches.indexOf(current);
            if (index >= 0 && index < branches.size() - 1) {
                return branches.get(index + 1);
            }
            return this.findSucceedingSiblingOrAncestor(parent);
        }
        if (current.getParent() instanceof ISheetPart) {
            ISheetPart sheet = (ISheetPart)current.getParent();
            List<IBranchPart> floatingBranches = sheet.getFloatingBranches();
            if (current == sheet.getCentralBranch()) {
                if (!floatingBranches.isEmpty()) {
                    return floatingBranches.get(0);
                }
            } else {
                int index = floatingBranches.indexOf(current);
                if (index >= 0) {
                    if (index < floatingBranches.size() - 1) {
                        IBranchPart floatBranch = floatingBranches.get(index + 1);
                        return floatBranch;
                    }
                    return sheet.getCentralBranch();
                }
            }
        }
        return current;
    }

    private IBranchPart findPrecedingBranch(IBranchPart current) {
        IBranchPart parent = current.getParentBranch();
        if (parent != null) {
            List<IBranchPart> branches = parent.getSubBranches();
            int index = branches.indexOf(current);
            if (index > 0) {
                return this.findLastDescendant(branches.get(index - 1));
            }
            int lastBranchIndex = branches.size() - 1;
            branches = parent.getSummaryBranches();
            index = branches.indexOf(current);
            if (index == 0) {
                return parent.getSubBranches().get(lastBranchIndex);
            }
            if (index > 0) {
                return this.findLastDescendant(branches.get(index - 1));
            }
            return parent;
        }
        if (current.getParent() instanceof ISheetPart) {
            ISheetPart sheet = (ISheetPart)current.getParent();
            List<IBranchPart> floatingBranches = sheet.getFloatingBranches();
            if (current == sheet.getCentralBranch()) {
                if (!floatingBranches.isEmpty()) {
                    IBranchPart lastFloating = floatingBranches.get(floatingBranches.size() - 1);
                    return this.findLastDescendant(lastFloating);
                }
                return this.findLastDescendant(current);
            }
            if (floatingBranches.contains(current)) {
                int index = floatingBranches.indexOf(current);
                if (index == 0) {
                    return this.findLastDescendant(sheet.getCentralBranch());
                }
                return this.findLastDescendant(floatingBranches.get(index - 1));
            }
        }
        return current;
    }

    private IBranchPart findLastDescendant(IBranchPart branch) {
        List<IBranchPart> summaryBranches = branch.getSummaryBranches();
        if (!summaryBranches.isEmpty()) {
            return this.findLastDescendant(summaryBranches.get(summaryBranches.size() - 1));
        }
        List<IBranchPart> subBranches = branch.getSubBranches();
        if (!subBranches.isEmpty()) {
            return this.findLastDescendant(subBranches.get(subBranches.size() - 1));
        }
        return branch;
    }
}

