/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.mindmap;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Image;
import org.xmind.core.IImage;
import org.xmind.core.ITopic;
import org.xmind.core.event.CoreEvent;
import org.xmind.core.event.ICoreEventRegister;
import org.xmind.core.util.HyperlinkUtils;
import org.xmind.gef.IDecorator;
import org.xmind.gef.Request;
import org.xmind.gef.draw2d.SizeableImageFigure;
import org.xmind.gef.part.IPart;
import org.xmind.gef.part.IRequestHandler;
import org.xmind.gef.policy.IEditPolicy;
import org.xmind.gef.policy.NullEditPolicy;
import org.xmind.gef.service.IFeedback;
import org.xmind.gef.util.GEFUtils;
import org.xmind.ui.internal.AttachmentImageDescriptor;
import org.xmind.ui.internal.mindmap.ImageDecorator;
import org.xmind.ui.internal.mindmap.ImageDownloader;
import org.xmind.ui.internal.mindmap.ImageFeedback;
import org.xmind.ui.internal.mindmap.ImageSelectionHelper;
import org.xmind.ui.internal.mindmap.MindMapPartBase;
import org.xmind.ui.internal.mindmap.TopicPart;
import org.xmind.ui.mindmap.IImagePart;
import org.xmind.ui.mindmap.ISelectionFeedbackHelper;
import org.xmind.ui.mindmap.ITopicPart;
import org.xmind.ui.resources.ImageReference;

public class ImagePart
extends MindMapPartBase
implements IImagePart {
    private static final String FILE_PROTOCOL = "file";
    private ImageDescriptor imageDescriptor = null;
    private ImageReference imageRef = null;
    private String imageURL = null;
    private Runnable imageUpdater = null;

    public ImagePart() {
        this.setDecorator((IDecorator)ImageDecorator.getInstance());
    }

    protected IFigure createFigure() {
        return new SizeableImageFigure();
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        return this.imageDescriptor;
    }

    protected synchronized void setImageDescriptor(ImageDescriptor imageDescriptor) {
        if (imageDescriptor == this.imageDescriptor || imageDescriptor != null && imageDescriptor.equals(this.imageDescriptor)) {
            return;
        }
        ImageReference oldImageRef = this.imageRef;
        this.imageDescriptor = imageDescriptor;
        if (oldImageRef != null) {
            oldImageRef.dispose();
        }
        this.imageRef = this.imageDescriptor == null ? null : new ImageReference(this.imageDescriptor, true);
    }

    @Override
    public Image getImage() {
        if (this.imageRef != null && !this.imageRef.isDisposed()) {
            return this.imageRef.getImage();
        }
        return null;
    }

    public SizeableImageFigure getImageFigure() {
        return (SizeableImageFigure)super.getFigure();
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isAssignableFrom(ITopic.class)) {
            return this.getTopic();
        }
        if (adapter == ITopicPart.class) {
            return this.getTopicPart();
        }
        if (adapter == IImage.class) {
            return this.getImageModel();
        }
        if (adapter == Image.class) {
            return this.getImage();
        }
        return super.getAdapter(adapter);
    }

    public void setModel(Object model) {
        super.setModel(model);
        this.updateImageDescriptor();
    }

    @Override
    protected void onDeactivated() {
        this.getImageFigure().setImage(null);
        this.setImageURL(null);
        if (this.imageRef != null) {
            this.imageRef.dispose();
            this.imageRef = null;
        }
        super.onDeactivated();
    }

    @Override
    public IImage getImageModel() {
        return (IImage)super.getRealModel();
    }

    protected void register() {
        this.registerModel(this.getImageModel());
        super.register();
    }

    protected void unregister() {
        super.unregister();
        this.unregisterModel(this.getImageModel());
    }

    @Override
    public ITopic getTopic() {
        return this.getImageModel().getParent();
    }

    @Override
    public ITopicPart getTopicPart() {
        if (this.getParent() instanceof ITopicPart) {
            return (ITopicPart)this.getParent();
        }
        return null;
    }

    public void setParent(IPart parent) {
        TopicPart topicPart;
        if (this.getParent() instanceof TopicPart && (topicPart = (TopicPart)this.getParent()).getImagePart() == this) {
            topicPart.setImagePart(null);
        }
        super.setParent(parent);
        if (this.getParent() instanceof TopicPart) {
            topicPart = (TopicPart)this.getParent();
            topicPart.setImagePart(this);
        }
    }

    @Override
    protected void registerCoreEvents(Object source, ICoreEventRegister register) {
        super.registerCoreEvents(source, register);
        register.register("imageAlignment");
        register.register("imageHeight");
        register.register("imageSource");
        register.register("imageWidth");
    }

    @Override
    public void handleCoreEvent(CoreEvent event) {
        String type = event.getType();
        if ("imageAlignment".equals(type)) {
            this.getFigure().revalidate();
        } else if ("imageHeight".equals(type) || "imageWidth".equals(type)) {
            this.update();
        } else if ("imageSource".equals(type)) {
            this.updateImageDescriptor();
            this.update();
        } else {
            super.handleCoreEvent(event);
        }
    }

    private void updateImageDescriptor() {
        IImage imageModel = this.getImageModel();
        String source = imageModel.getSource();
        if (source != null) {
            if (HyperlinkUtils.isAttachmentURL((String)source)) {
                this.setImageURL(null);
                String path = HyperlinkUtils.toAttachmentPath((String)source);
                this.setImageDescriptor(AttachmentImageDescriptor.createFromEntryPath(imageModel.getOwnedWorkbook(), path));
                this.setToolTip(null);
            } else {
                URL url = this.checkFileURL(source);
                if (url != null) {
                    this.setImageURL(null);
                    this.setImageDescriptor(ImageDescriptor.createFromURL((URL)url));
                    this.setToolTip(url.getPath());
                } else {
                    this.setImageURL(source);
                }
            }
        } else {
            this.setImageURL(null);
            this.setImageDescriptor(null);
            this.setToolTip(null);
        }
    }

    private URL checkFileURL(String source) {
        try {
            URL url = new URL(source);
            if (FILE_PROTOCOL.equalsIgnoreCase(url.getProtocol())) {
                return url;
            }
        }
        catch (MalformedURLException malformedURLException) {}
        return null;
    }

    private void setImageURL(String newURL) {
        if (newURL == this.imageURL || newURL != null && newURL.equals(this.imageURL)) {
            return;
        }
        String oldImageURL = this.imageURL;
        this.imageURL = newURL;
        ImageDownloader.getInstance().unregister(oldImageURL, this.getImageUpdater());
        if (this.imageURL != null) {
            ImageDownloader.getInstance().register(this.imageURL, this.getImageUpdater());
            this.setImageDescriptor(ImageDownloader.getInstance().getImage(this.imageURL));
            IStatus status = ImageDownloader.getInstance().getStatus(this.imageURL);
            if (status.getSeverity() == 0) {
                this.setToolTip(this.imageURL);
            } else {
                this.setToolTip(status.getMessage());
            }
        }
    }

    private Runnable getImageUpdater() {
        if (this.imageUpdater == null) {
            this.imageUpdater = new Runnable(){

                @Override
                public void run() {
                    if (ImagePart.this.imageURL == null) {
                        return;
                    }
                    ImagePart.this.setImageDescriptor(ImageDownloader.getInstance().getImage(ImagePart.this.imageURL));
                    IStatus status = ImageDownloader.getInstance().getStatus(ImagePart.this.imageURL);
                    if (status.getSeverity() == 0) {
                        ImagePart.this.setToolTip(ImagePart.this.imageURL);
                    } else {
                        ImagePart.this.setToolTip(status.getMessage());
                    }
                    ImagePart.this.update();
                }
            };
        }
        return this.imageUpdater;
    }

    private void setToolTip(String message) {
        this.getFigure().setToolTip((IFigure)(message == null ? null : new Label(message)));
    }

    protected void declareEditPolicies(IRequestHandler reqHandler) {
        super.declareEditPolicies(reqHandler);
        reqHandler.installEditPolicy("selectable role", (IEditPolicy)NullEditPolicy.getInstance());
        reqHandler.installEditPolicy("deletable role", "org.xmind.ui.editPolicy.deletable");
        reqHandler.installEditPolicy("movable role", "org.xmind.ui.editPolicy.imageMovable");
    }

    @Override
    protected IFeedback createFeedback() {
        return new ImageFeedback(this);
    }

    @Override
    protected ISelectionFeedbackHelper createSelectionFeedbackHelper() {
        return new ImageSelectionHelper();
    }

    public boolean containsPoint(Point position) {
        return super.containsPoint(position) || this.getSelectionOrientation(position) != 0;
    }

    public Cursor getCursor(Point pos) {
        int orientation = this.getSelectionOrientation(pos);
        if (orientation != 0) {
            return GEFUtils.getPositionCursor((int)orientation);
        }
        return super.getCursor(pos);
    }

    private int getSelectionOrientation(Point point) {
        if (this.getStatus().isPreSelected() || this.getStatus().isSelected()) {
            return ((ImageFeedback)this.getFeedback()).getOrientation(point);
        }
        return 0;
    }

    public void handleRequest(Request request, String role) {
        String type = request.getType();
        if ("paste".equals(type)) {
            request.setPrimaryTarget((IPart)this.getTopicPart());
            ArrayList<ITopicPart> parts = new ArrayList<ITopicPart>();
            parts.add(this.getTopicPart());
            request.setTargets(parts);
        }
        super.handleRequest(request, role);
    }
}

