/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.tools;

import java.util.Arrays;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.xmind.core.ITitled;
import org.xmind.gef.IViewer;
import org.xmind.gef.Request;
import org.xmind.gef.part.IGraphicalEditPart;
import org.xmind.gef.part.IPart;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.texteditor.FloatingTextEditor;
import org.xmind.ui.tools.MindMapEditToolBase;
import org.xmind.ui.util.MindMapUtils;

public class SheetTitleEditTool
extends MindMapEditToolBase {
    private Composite textEditorParent = null;
    private Rectangle textEditorBounds = null;

    @Override
    protected String getInitialText(IPart source) {
        ITitled titled;
        if (source != null && (titled = MindMapUIPlugin.getAdapter(MindMapUtils.getRealModel(source), ITitled.class)) != null) {
            return titled.getTitleText();
        }
        return null;
    }

    @Override
    protected Request createTextRequest(IPart source, IDocument document) {
        IGraphicalEditPart sourcePart = this.getSource();
        if (sourcePart == null) {
            return null;
        }
        String newValue = document.get();
        if (newValue == null || "".equals(newValue)) {
            return null;
        }
        return new Request("modify").setViewer((IViewer)this.getTargetViewer()).setParameter("text", (Object)newValue).setTargets(Arrays.asList(sourcePart));
    }

    public void setTextEditorParameters(Composite parent, Rectangle bounds) {
        this.textEditorParent = parent;
        this.textEditorBounds = bounds;
    }

    protected FloatingTextEditor createEditor() {
        int style = 0xA00 | (this.isMultilineAllowed() ? 2 : 4);
        style = this.isWrapAllowed() ? (style |= 0x40) : (style |= 0x100);
        Composite parent = this.textEditorParent == null ? this.getTargetViewer().getCanvas() : this.textEditorParent;
        FloatingTextEditor editor = new FloatingTextEditor(parent, style);
        if (this.textEditorBounds != null) {
            editor.setInitialLocation(new Point(this.textEditorBounds.x, this.textEditorBounds.y));
            editor.setInitialSize(new Point(this.textEditorBounds.width, this.textEditorBounds.height));
        }
        return editor;
    }

    protected boolean shouldUpdateSelectionOnEdit(IGraphicalEditPart newSource, Request request) {
        return false;
    }
}

