/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.styleeditor;

import java.beans.PropertyChangeEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.xmind.ui.internal.styleeditor.StyleEditModel;
import org.xmind.ui.internal.styleeditor.StyleEditorMessages;
import org.xmind.ui.properties.IPropertyDescriptor;

public class StylePropertyChangeOperation
extends AbstractOperation {
    private final StyleEditModel model;
    private final String propertyName;
    private final String oldValue;
    private final String newValue;
    private final String propagationId;

    public StylePropertyChangeOperation(StyleEditModel model, String propertyName, String oldValue, String newValue, String propagationId) {
        super(StylePropertyChangeOperation.generateOperationLabel(model, propertyName));
        this.model = model;
        this.propertyName = propertyName;
        this.oldValue = oldValue;
        this.newValue = newValue;
        this.propagationId = propagationId;
        this.addContext(model.getUndoContext());
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.performPropertyChange(this.newValue, this.propagationId);
        return Status.OK_STATUS;
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.performPropertyChange(this.newValue, null);
        return Status.OK_STATUS;
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.performPropertyChange(this.oldValue, null);
        return Status.OK_STATUS;
    }

    private void performPropertyChange(String value, String propagationId) {
        String oldValue = this.model.doGetPropertyValue(this.propertyName);
        this.model.doSetPropertyValue(this.propertyName, value);
        PropertyChangeEvent event = new PropertyChangeEvent(this.model, this.propertyName, oldValue, value);
        if (propagationId != null) {
            event.setPropagationId(propagationId);
        }
        this.model.firePropertyChange(event);
    }

    private static String generateOperationLabel(StyleEditModel model, String propertyName) {
        IPropertyDescriptor[] iPropertyDescriptorArray = model.getPropertyDescriptors();
        int n = iPropertyDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPropertyDescriptor desc = iPropertyDescriptorArray[n2];
            if (propertyName.equals(desc.getId())) {
                return NLS.bind((String)StyleEditorMessages.StylePropertyChangeOperation_ModifyStyleProperty_actionName_withPropertyName, (Object)desc.getDisplayName());
            }
            ++n2;
        }
        return StyleEditorMessages.StylePropertyChangeOperation_ModifyStyleProperty_actionName;
    }
}

