/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.brainstorm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.internal.actions.CommandAction;
import org.eclipse.ui.services.IServiceLocator;
import org.xmind.core.ITopic;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.event.MouseEvent;
import org.xmind.gef.service.GraphicalViewerService;
import org.xmind.gef.ui.actions.IActionRegistry;
import org.xmind.gef.ui.actions.ISelectionAction;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.ui.actions.MindMapActionFactory;
import org.xmind.ui.brainstorm.actions.ActualSizeAction;
import org.xmind.ui.brainstorm.actions.AddMarkerAction;
import org.xmind.ui.brainstorm.actions.AlignmentMenu;
import org.xmind.ui.brainstorm.actions.CollapseAction;
import org.xmind.ui.brainstorm.actions.CollapseAllAction;
import org.xmind.ui.brainstorm.actions.CopyAction;
import org.xmind.ui.brainstorm.actions.CutAction;
import org.xmind.ui.brainstorm.actions.DeleteAction;
import org.xmind.ui.brainstorm.actions.DrillDownAction;
import org.xmind.ui.brainstorm.actions.DrillUpAction;
import org.xmind.ui.brainstorm.actions.DuplicateAction;
import org.xmind.ui.brainstorm.actions.EditCommentsAction;
import org.xmind.ui.brainstorm.actions.EditTitleAction;
import org.xmind.ui.brainstorm.actions.EditTopicLabelAction;
import org.xmind.ui.brainstorm.actions.EditTopicNotesAction;
import org.xmind.ui.brainstorm.actions.ExtendAction;
import org.xmind.ui.brainstorm.actions.ExtendAllAction;
import org.xmind.ui.brainstorm.actions.GoHomeAction;
import org.xmind.ui.brainstorm.actions.InsertAttachmentAction;
import org.xmind.ui.brainstorm.actions.InsertBoundaryAction;
import org.xmind.ui.brainstorm.actions.InsertCalloutAction;
import org.xmind.ui.brainstorm.actions.InsertFloatingTopicAction;
import org.xmind.ui.brainstorm.actions.InsertHyperlinkAction;
import org.xmind.ui.brainstorm.actions.InsertImageAction;
import org.xmind.ui.brainstorm.actions.InsertParentTopicAction;
import org.xmind.ui.brainstorm.actions.InsertRelationshipAction;
import org.xmind.ui.brainstorm.actions.InsertSubTopicAction;
import org.xmind.ui.brainstorm.actions.InsertSummaryAction;
import org.xmind.ui.brainstorm.actions.InsertTopicAction;
import org.xmind.ui.brainstorm.actions.InsertTopicBeforeAction;
import org.xmind.ui.brainstorm.actions.MarkersMenu;
import org.xmind.ui.brainstorm.actions.PasteAction;
import org.xmind.ui.brainstorm.actions.RedoAction;
import org.xmind.ui.brainstorm.actions.ResetPositionAction;
import org.xmind.ui.brainstorm.actions.SaveAction;
import org.xmind.ui.brainstorm.actions.SelectAllAction;
import org.xmind.ui.brainstorm.actions.SelectBrothersAction;
import org.xmind.ui.brainstorm.actions.SelectChildrenAction;
import org.xmind.ui.brainstorm.actions.SortMenu;
import org.xmind.ui.brainstorm.actions.StructureMenu;
import org.xmind.ui.brainstorm.actions.TileAction;
import org.xmind.ui.brainstorm.actions.TimerAction;
import org.xmind.ui.brainstorm.actions.TraverseAction;
import org.xmind.ui.brainstorm.actions.UndoAction;
import org.xmind.ui.brainstorm.actions.ZoomInAction;
import org.xmind.ui.brainstorm.actions.ZoomOutAction;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.mindmap.ICategoryAnalyzation;
import org.xmind.ui.mindmap.ICategoryManager;
import org.xmind.ui.mindmap.MindMapUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextMenuService
extends GraphicalViewerService {
    private IGraphicalViewer viewer;
    private IGraphicalEditor sourceEditor;
    private ViewerSelectionChangedListener selectionChangedListener;
    private MenuManager manager;
    private ContentPopupContribute contentPopupContribute;
    private List<ISelectionAction> selectionActions;
    private IActionRegistry actionRegistry;
    private StructureMenu structureMenu;
    private MarkersMenu markersMenu;
    private AlignmentMenu alignMenu;
    private SortMenu sortMenu;
    private SaveAction saveAction;
    private UndoAction undoAction;
    private RedoAction redoAction;
    private CutAction cutAction;
    private CopyAction copyAction;
    private PasteAction pasteAction;
    private DeleteAction deleteAction;
    private SelectAllAction selectAllAction;
    private EditTitleAction editTitleAction;
    private EditTopicLabelAction editLabelAction;
    private EditTopicNotesAction editNotesAction;
    private EditCommentsAction editCommentsAction;
    private InsertTopicAction insertTopicAction;
    private InsertSubTopicAction insertSubTopicAction;
    private InsertTopicBeforeAction insertTopicBeforeAction;
    private InsertParentTopicAction insertParentTopicAction;
    private InsertImageAction imageAction;
    private InsertRelationshipAction relationshipAction;
    private InsertBoundaryAction boundaryAction;
    private InsertSummaryAction summaryAction;
    private InsertAttachmentAction attachmentAction;
    private InsertHyperlinkAction hyperlinkAction;
    private ResetPositionAction resetPositionAction;
    private InsertFloatingTopicAction floatingTopicAction;
    private InsertFloatingTopicAction centralFloatTopicAction;
    private DrillDownAction drillDownAction;
    private DrillUpAction drillUpAction;
    private TimerAction timerAction;
    private ZoomInAction zoomInAction;
    private ZoomOutAction zoomOutAction;
    private ActualSizeAction actualSizeAction;
    private CollapseAllAction collapseAllAction;
    private ExtendAllAction extendAllAction;
    private SelectBrothersAction selectBrotherAction;
    private SelectChildrenAction selectChildrenAction;
    private GoHomeAction goHomeAction;
    private AddMarkerAction addMarkerAction;
    private ExtendAction extendAction;
    private CollapseAction collapseAction;
    private TraverseAction traverseAction;
    private TileAction tileAction;
    private InsertCalloutAction insertCalloutAction;
    private DuplicateAction duplicateAction;
    private CommandAction openAudioNotesDialogAction;

    public ContextMenuService(IGraphicalViewer viewer, IGraphicalEditor sourceEditor) {
        super(viewer);
        this.viewer = viewer;
        this.sourceEditor = sourceEditor;
    }

    protected void activate() {
        if (this.selectionChangedListener == null) {
            this.selectionChangedListener = new ViewerSelectionChangedListener();
        }
        this.getViewer().addSelectionChangedListener((ISelectionChangedListener)this.selectionChangedListener);
        if (this.actionRegistry == null) {
            this.actionRegistry = (IActionRegistry)this.getViewer().getAdapter(IActionRegistry.class);
        }
        if (this.manager == null) {
            this.manager = new MenuManager("", "org.xmind.ui.brainstorm.menu");
        }
        if (this.contentPopupContribute == null) {
            this.contentPopupContribute = new ContentPopupContribute();
        }
        if (this.saveAction == null && this.sourceEditor instanceof ISaveablePart) {
            this.saveAction = new SaveAction((ISaveablePart)this.sourceEditor);
            this.actionRegistry.addAction((IAction)this.saveAction);
        }
        if (this.undoAction == null) {
            this.undoAction = new UndoAction(this.viewer);
            this.actionRegistry.addAction((IAction)this.undoAction);
        }
        if (this.redoAction == null) {
            this.redoAction = new RedoAction(this.viewer);
            this.actionRegistry.addAction((IAction)this.redoAction);
        }
        if (this.cutAction == null) {
            this.cutAction = new CutAction(this.viewer);
            this.addSelectionActions(this.cutAction);
            this.actionRegistry.addAction((IAction)this.cutAction);
        }
        if (this.copyAction == null) {
            this.copyAction = new CopyAction(this.viewer);
            this.addSelectionActions(this.copyAction);
            this.actionRegistry.addAction((IAction)this.copyAction);
        }
        if (this.pasteAction == null) {
            this.pasteAction = new PasteAction(this.viewer);
            this.addSelectionActions(this.pasteAction);
            this.actionRegistry.addAction((IAction)this.pasteAction);
        }
        if (this.deleteAction == null) {
            this.deleteAction = new DeleteAction(this.viewer);
            this.addSelectionActions(this.deleteAction);
            this.actionRegistry.addAction((IAction)this.deleteAction);
        }
        if (this.editTitleAction == null) {
            this.editTitleAction = new EditTitleAction(this.viewer);
            this.addSelectionActions(this.editTitleAction);
            this.actionRegistry.addAction((IAction)this.editTitleAction);
        }
        if (this.selectAllAction == null) {
            this.selectAllAction = new SelectAllAction(this.viewer);
            this.actionRegistry.addAction((IAction)this.selectAllAction);
        }
        if (this.editLabelAction == null) {
            this.editLabelAction = new EditTopicLabelAction(this.viewer);
            this.addSelectionActions(this.editLabelAction);
            this.actionRegistry.addAction((IAction)this.editLabelAction);
        }
        if (this.editNotesAction == null) {
            this.editNotesAction = new EditTopicNotesAction(this.viewer);
            this.addSelectionActions(this.editNotesAction);
            this.actionRegistry.addAction((IAction)this.editNotesAction);
        }
        if (this.editCommentsAction == null) {
            this.editCommentsAction = new EditCommentsAction(this.viewer);
            this.addSelectionActions(this.editCommentsAction);
            this.actionRegistry.addAction((IAction)this.editCommentsAction);
        }
        if (this.insertTopicAction == null) {
            this.insertTopicAction = new InsertTopicAction(this.viewer);
            this.addSelectionActions(this.insertTopicAction);
            this.actionRegistry.addAction((IAction)this.insertTopicAction);
        }
        if (this.insertSubTopicAction == null) {
            this.insertSubTopicAction = new InsertSubTopicAction(this.viewer);
            this.addSelectionActions(this.insertSubTopicAction);
            this.actionRegistry.addAction((IAction)this.insertSubTopicAction);
        }
        if (this.insertTopicBeforeAction == null) {
            this.insertTopicBeforeAction = new InsertTopicBeforeAction(this.viewer);
            this.addSelectionActions(this.insertTopicBeforeAction);
            this.actionRegistry.addAction((IAction)this.insertTopicBeforeAction);
        }
        if (this.insertParentTopicAction == null) {
            this.insertParentTopicAction = new InsertParentTopicAction(this.viewer);
            this.addSelectionActions(this.insertParentTopicAction);
            this.actionRegistry.addAction((IAction)this.insertParentTopicAction);
        }
        if (this.imageAction == null) {
            this.imageAction = new InsertImageAction(this.viewer);
            this.addSelectionActions(this.imageAction);
            this.actionRegistry.addAction((IAction)this.imageAction);
        }
        if (this.relationshipAction == null) {
            this.relationshipAction = new InsertRelationshipAction(this.viewer);
            this.actionRegistry.addAction((IAction)this.relationshipAction);
        }
        if (this.boundaryAction == null) {
            this.boundaryAction = new InsertBoundaryAction(this.viewer);
            this.addSelectionActions(this.boundaryAction);
            this.actionRegistry.addAction((IAction)this.boundaryAction);
        }
        if (this.summaryAction == null) {
            this.summaryAction = new InsertSummaryAction(this.viewer);
            this.addSelectionActions(this.summaryAction);
            this.actionRegistry.addAction((IAction)this.summaryAction);
        }
        if (this.attachmentAction == null) {
            this.attachmentAction = new InsertAttachmentAction(this.viewer);
            this.addSelectionActions(this.attachmentAction);
            this.actionRegistry.addAction((IAction)this.attachmentAction);
        }
        if (this.hyperlinkAction == null) {
            this.hyperlinkAction = new InsertHyperlinkAction(this.viewer, (IEditorPart)this.sourceEditor);
            this.addSelectionActions(this.hyperlinkAction);
            this.actionRegistry.addAction((IAction)this.hyperlinkAction);
        }
        if (this.resetPositionAction == null) {
            this.resetPositionAction = new ResetPositionAction(this.viewer);
            this.addSelectionActions(this.resetPositionAction);
            this.actionRegistry.addAction((IAction)this.resetPositionAction);
        }
        if (this.floatingTopicAction == null) {
            this.floatingTopicAction = new InsertFloatingTopicAction(this.viewer, MindMapActionFactory.INSERT_FLOATING_TOPIC.getId());
        }
        if (this.centralFloatTopicAction == null) {
            this.centralFloatTopicAction = new InsertFloatingTopicAction(this.viewer, MindMapActionFactory.INSERT_FLOATING_CENTRAL_TOPIC.getId());
        }
        if (this.drillDownAction == null) {
            this.drillDownAction = new DrillDownAction(this.viewer);
            this.addSelectionActions(this.drillDownAction);
            this.actionRegistry.addAction((IAction)this.drillDownAction);
        }
        if (this.drillUpAction == null) {
            this.drillUpAction = new DrillUpAction(this.viewer);
            this.actionRegistry.addAction((IAction)this.drillUpAction);
        }
        if (this.timerAction == null) {
            this.timerAction = new TimerAction(this.viewer);
            this.actionRegistry.addAction((IAction)this.timerAction);
        }
        if (this.zoomInAction == null) {
            this.zoomInAction = new ZoomInAction(this.viewer);
            this.actionRegistry.addAction((IAction)this.zoomInAction);
        }
        if (this.zoomOutAction == null) {
            this.zoomOutAction = new ZoomOutAction(this.viewer);
            this.actionRegistry.addAction((IAction)this.zoomOutAction);
        }
        if (this.actualSizeAction == null) {
            this.actualSizeAction = new ActualSizeAction(this.viewer);
            this.actionRegistry.addAction((IAction)this.actualSizeAction);
        }
        if (this.extendAllAction == null) {
            this.extendAllAction = new ExtendAllAction(this.viewer);
            this.addSelectionActions(this.extendAllAction);
            this.actionRegistry.addAction((IAction)this.extendAllAction);
        }
        if (this.collapseAllAction == null) {
            this.collapseAllAction = new CollapseAllAction(this.viewer);
            this.addSelectionActions(this.collapseAllAction);
            this.actionRegistry.addAction((IAction)this.collapseAllAction);
        }
        if (this.selectBrotherAction == null) {
            this.selectBrotherAction = new SelectBrothersAction(this.viewer);
            this.actionRegistry.addAction((IAction)this.selectBrotherAction);
        }
        if (this.selectChildrenAction == null) {
            this.selectChildrenAction = new SelectChildrenAction(this.viewer);
            this.actionRegistry.addAction((IAction)this.selectChildrenAction);
        }
        if (this.goHomeAction == null) {
            this.goHomeAction = new GoHomeAction(this.viewer);
            this.actionRegistry.addAction((IAction)this.goHomeAction);
        }
        if (this.addMarkerAction == null) {
            this.addMarkerAction = new AddMarkerAction(this.viewer);
            this.actionRegistry.addAction((IAction)this.addMarkerAction);
        }
        if (this.extendAction == null) {
            this.extendAction = new ExtendAction(this.viewer);
            this.actionRegistry.addAction((IAction)this.extendAction);
        }
        if (this.collapseAction == null) {
            this.collapseAction = new CollapseAction(this.viewer);
            this.actionRegistry.addAction((IAction)this.collapseAction);
        }
        if (this.traverseAction == null) {
            this.traverseAction = new TraverseAction(this.viewer);
            this.actionRegistry.addAction((IAction)this.traverseAction);
        }
        if (this.tileAction == null) {
            this.tileAction = new TileAction(this.viewer);
            this.actionRegistry.addAction((IAction)this.tileAction);
        }
        if (this.insertCalloutAction == null) {
            this.insertCalloutAction = new InsertCalloutAction(this.viewer);
            this.addSelectionActions(this.insertCalloutAction);
            this.actionRegistry.addAction((IAction)this.insertCalloutAction);
        }
        if (this.duplicateAction == null) {
            this.duplicateAction = new DuplicateAction(this.viewer);
            this.addSelectionActions(this.duplicateAction);
            this.actionRegistry.addAction((IAction)this.duplicateAction);
        }
        if (this.openAudioNotesDialogAction == null) {
            this.openAudioNotesDialogAction = new CommandAction((IServiceLocator)this.sourceEditor.getEditorSite().getWorkbenchWindow(), "org.xmind.ui.dialog.openAudioNotesDialog");
            this.actionRegistry.addAction((IAction)this.openAudioNotesDialogAction);
        }
    }

    protected void deactivate() {
        if (this.selectionChangedListener != null) {
            this.getViewer().removeSelectionChangedListener((ISelectionChangedListener)this.selectionChangedListener);
        }
    }

    protected void addSelectionActions(ISelectionAction action) {
        if (this.selectionActions == null) {
            this.selectionActions = new ArrayList<ISelectionAction>();
        }
        this.selectionActions.add(action);
    }

    private Contributor createPopupInsertMenu() {
        Contributor insertMenu = new Contributor("org.xmind.ui.brainstorm.insert", MindMapMessages.InsertMenu);
        insertMenu.add((IAction)this.insertTopicAction);
        insertMenu.add((IAction)this.insertSubTopicAction);
        insertMenu.add((IAction)this.insertTopicBeforeAction);
        insertMenu.add((IAction)this.insertParentTopicAction);
        insertMenu.add((IAction)this.insertCalloutAction);
        insertMenu.add((IContributionItem)new Separator());
        insertMenu.add((IAction)this.relationshipAction);
        insertMenu.add((IAction)this.boundaryAction);
        insertMenu.add((IAction)this.summaryAction);
        insertMenu.add((IContributionItem)new Separator());
        insertMenu.add((IAction)this.imageAction);
        insertMenu.add((IAction)this.editNotesAction);
        insertMenu.add((IAction)this.editLabelAction);
        insertMenu.add((IAction)this.editCommentsAction);
        insertMenu.add((IAction)this.hyperlinkAction);
        insertMenu.add((IAction)this.attachmentAction);
        insertMenu.add((IAction)this.openAudioNotesDialogAction);
        return insertMenu;
    }

    private StructureMenu createStructureMenu() {
        if (this.structureMenu != null) {
            this.structureMenu.dispose();
            this.structureMenu = null;
        }
        this.structureMenu = new StructureMenu(this.viewer);
        return this.structureMenu;
    }

    private MenuManager createMarkersMenu() {
        if (this.markersMenu != null) {
            this.markersMenu.dispose();
            this.markersMenu = null;
        }
        this.markersMenu = new MarkersMenu(this.viewer);
        return this.markersMenu;
    }

    private AlignmentMenu createAlignmentMenu() {
        if (this.alignMenu != null) {
            this.alignMenu.dispose();
            if (this.selectionActions != null) {
                this.selectionActions.remove((Object)this.alignMenu);
            }
            this.alignMenu = null;
        }
        this.alignMenu = new AlignmentMenu(this.viewer);
        this.addSelectionActions(this.alignMenu);
        return this.alignMenu;
    }

    private SortMenu createSortMenu() {
        if (this.sortMenu != null) {
            this.sortMenu.dispose();
            if (this.selectionActions != null) {
                this.selectionActions.remove((Object)this.sortMenu);
            }
            this.sortMenu = null;
        }
        this.sortMenu = new SortMenu(this.viewer);
        this.addSelectionActions(this.sortMenu);
        return this.sortMenu;
    }

    public boolean hanleMouseUp(MouseEvent me) {
        Control control = this.viewer.getControl();
        if (control != null && !control.isDisposed()) {
            this.manager.setRemoveAllWhenShown(true);
            this.manager.addMenuListener(new IMenuListener(){

                public void menuAboutToShow(IMenuManager manager) {
                    if (ContextMenuService.this.contentPopupContribute != null) {
                        manager.removeAll();
                    }
                    ContextMenuService.this.contentPopupContribute.applyTo(manager);
                }
            });
            Menu contextMenu = this.manager.createContextMenu(control);
            control.setMenu(contextMenu);
            contextMenu.setVisible(true);
            return true;
        }
        return false;
    }

    private void handleViewerSelectionChanged(ISelection selection) {
        ICategoryManager categoryManager = MindMapUI.getCategoryManager();
        Object[] elements = selection instanceof IStructuredSelection ? ((IStructuredSelection)selection).toArray() : null;
        ICategoryAnalyzation categories = elements == null ? null : categoryManager.analyze(elements);
        this.updateContextMenuItems(categoryManager, categories);
        this.updateSelectionActions(selection);
    }

    private void updateSelectionActions(ISelection selection) {
        if (this.selectionActions != null) {
            for (ISelectionAction action : this.selectionActions) {
                action.setSelection(selection);
            }
        }
    }

    private void updateContextMenuItems(ICategoryManager categoryManager, ICategoryAnalyzation categories) {
        if (this.contentPopupContribute != null) {
            this.contentPopupContribute.build(categoryManager, categories);
        }
    }

    public void buildSpecifiedPopupMenu(final List<IAction> actions) {
        Control control = this.viewer.getControl();
        if (control != null && !control.isDisposed()) {
            Menu contextMenu = this.manager.createContextMenu(control);
            control.setMenu(contextMenu);
            this.manager.setRemoveAllWhenShown(true);
            if (actions == null) {
                contextMenu.setVisible(false);
                return;
            }
            contextMenu.setVisible(true);
            this.manager.addMenuListener(new IMenuListener(){

                public void menuAboutToShow(IMenuManager manager) {
                    manager.removeAll();
                    for (IAction action : actions) {
                        manager.add(action);
                    }
                }
            });
        }
    }

    public void dispose() {
        if (this.manager != null) {
            this.manager.dispose();
            this.manager = null;
        }
        this.contentPopupContribute = null;
        if (this.selectionActions != null) {
            for (ISelectionAction action : this.selectionActions) {
                action.setSelection(null);
            }
            this.selectionActions.clear();
        }
        if (this.structureMenu != null) {
            this.structureMenu.dispose();
            this.structureMenu = null;
        }
        if (this.markersMenu != null) {
            this.markersMenu.dispose();
            this.markersMenu = null;
        }
        if (this.drillUpAction != null) {
            IActionRegistry actionRegistry = (IActionRegistry)this.getViewer().getAdapter(IActionRegistry.class);
            actionRegistry.dispose();
            this.drillUpAction.dispose();
            this.drillUpAction = null;
        }
        super.dispose();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ContentPopupContribute
    extends Contributor {
        public ContentPopupContribute() {
            super(null);
        }

        public void build(ICategoryManager categoryManager, ICategoryAnalyzation categories) {
            this.clear();
            if (categories == null) {
                return;
            }
            String category = categories.getMainCategory();
            if ("org.xmind.ui.topic".equals(category)) {
                ArrayList<ITopic> topics = new ArrayList<ITopic>();
                Object[] objectArray = categories.getElementsByCategory("org.xmind.ui.topic");
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object topic = objectArray[n2];
                    topics.add((ITopic)topic);
                    ++n2;
                }
                if (categories.size() > 1) {
                    this.buildMultTopicsPopupActions(topics);
                } else {
                    this.buildSingleTopicPopupActions((ITopic)topics.get(0));
                }
            } else if ("org.xmind.ui.boundary".equals(category)) {
                this.buildBoundaryPopupActions();
            } else if ("org.xmind.ui.relationship".equals(category)) {
                this.buildRelationshipPopupActions();
            } else if ("org.xmind.ui.sheet".equals(category)) {
                this.buildSheetPopupActions();
            } else if ("org.xmind.ui.image".equals(category)) {
                this.buildImagePopupActions();
            } else if ("org.xmind.ui.marker".equals(category)) {
                this.buildMarkerPopupActions();
            }
        }

        private void buildSingleTopicPopupActions(ITopic topic) {
            this.add(ContextMenuService.this.createPopupInsertMenu());
            this.add((IContributionItem)ContextMenuService.this.createMarkersMenu());
            this.add((IContributionItem)new Separator());
            this.add((IContributionItem)ContextMenuService.this.createStructureMenu());
            this.add((IContributionItem)new Separator());
            this.add((IAction)ContextMenuService.this.drillDownAction);
            this.add((IContributionItem)new Separator());
            this.add((IAction)ContextMenuService.this.undoAction);
            this.add((IAction)ContextMenuService.this.redoAction);
            this.add((IContributionItem)new Separator());
            this.add((IAction)ContextMenuService.this.cutAction);
            this.add((IAction)ContextMenuService.this.copyAction);
            this.add((IAction)ContextMenuService.this.pasteAction);
            this.add((IAction)ContextMenuService.this.duplicateAction);
            this.add((IAction)ContextMenuService.this.deleteAction);
            this.add((IContributionItem)new Separator());
            this.add((IAction)ContextMenuService.this.extendAllAction);
            this.add((IAction)ContextMenuService.this.collapseAllAction);
            this.add((IContributionItem)new Separator());
            this.add((IContributionItem)ContextMenuService.this.createSortMenu());
            if (this.isMainTopics(new ArrayList<ITopic>(Arrays.asList(topic)))) {
                this.add((IAction)ContextMenuService.this.resetPositionAction);
            }
            this.add((IContributionItem)new Separator());
            this.add((IAction)ContextMenuService.this.timerAction);
        }

        private void buildMultTopicsPopupActions(List<ITopic> topics) {
            this.add((IAction)ContextMenuService.this.insertParentTopicAction);
            this.add((IAction)ContextMenuService.this.boundaryAction);
            this.add((IAction)ContextMenuService.this.summaryAction);
            this.add((IContributionItem)ContextMenuService.this.createMarkersMenu());
            this.add((IContributionItem)new Separator());
            this.add((IContributionItem)ContextMenuService.this.createStructureMenu());
            this.add((IContributionItem)new Separator());
            this.add((IAction)ContextMenuService.this.cutAction);
            this.add((IAction)ContextMenuService.this.copyAction);
            this.add((IAction)ContextMenuService.this.pasteAction);
            this.add((IAction)ContextMenuService.this.deleteAction);
            this.add((IContributionItem)new Separator());
            this.add((IAction)ContextMenuService.this.extendAllAction);
            this.add((IAction)ContextMenuService.this.collapseAllAction);
            this.add((IContributionItem)new Separator());
            this.add((IContributionItem)ContextMenuService.this.createAlignmentMenu());
            if (this.isMainTopics(topics)) {
                this.add((IAction)ContextMenuService.this.resetPositionAction);
            }
            this.add((IContributionItem)new Separator());
            this.add((IAction)ContextMenuService.this.timerAction);
        }

        private void buildRelationshipPopupActions() {
            this.add((IAction)ContextMenuService.this.editTitleAction);
            this.add((IAction)ContextMenuService.this.insertTopicAction);
            this.add((IAction)ContextMenuService.this.deleteAction);
            this.add((IAction)ContextMenuService.this.resetPositionAction);
            this.add((IContributionItem)new Separator());
            this.add((IAction)ContextMenuService.this.timerAction);
        }

        private void buildBoundaryPopupActions() {
            this.add((IAction)ContextMenuService.this.editTitleAction);
            this.add((IContributionItem)new Separator());
            this.add((IAction)ContextMenuService.this.cutAction);
            this.add((IAction)ContextMenuService.this.copyAction);
            this.add((IAction)ContextMenuService.this.deleteAction);
            this.add((IContributionItem)new Separator());
            this.add((IAction)ContextMenuService.this.relationshipAction);
            this.add((IContributionItem)new Separator());
            this.add((IAction)ContextMenuService.this.timerAction);
        }

        private void buildSheetPopupActions() {
            this.add((IAction)ContextMenuService.this.undoAction);
            this.add((IAction)ContextMenuService.this.redoAction);
            this.add((IContributionItem)new Separator());
            this.add((IAction)ContextMenuService.this.floatingTopicAction);
            this.add((IAction)ContextMenuService.this.centralFloatTopicAction);
            this.add((IContributionItem)new Separator());
            this.add((IAction)ContextMenuService.this.drillUpAction);
            this.add((IContributionItem)new Separator());
            this.add((IAction)ContextMenuService.this.relationshipAction);
            this.add((IAction)ContextMenuService.this.boundaryAction);
            this.add((IAction)ContextMenuService.this.summaryAction);
            this.add((IContributionItem)new Separator());
            this.add((IAction)ContextMenuService.this.pasteAction);
            this.add((IContributionItem)new Separator());
            this.add((IAction)ContextMenuService.this.extendAllAction);
            this.add((IAction)ContextMenuService.this.collapseAllAction);
            this.add((IContributionItem)new Separator());
            this.add((IAction)ContextMenuService.this.tileAction);
            this.add((IContributionItem)new Separator());
            this.add((IAction)ContextMenuService.this.timerAction);
        }

        private void buildMarkerPopupActions() {
            this.add((IAction)ContextMenuService.this.cutAction);
            this.add((IAction)ContextMenuService.this.copyAction);
            this.add((IAction)ContextMenuService.this.deleteAction);
        }

        private void buildImagePopupActions() {
            this.add((IAction)ContextMenuService.this.cutAction);
            this.add((IAction)ContextMenuService.this.copyAction);
            this.add((IAction)ContextMenuService.this.deleteAction);
        }

        private boolean isMainTopics(List<ITopic> topics) {
            if (topics != null && topics.size() != 0) {
                for (ITopic topic : topics) {
                    if (topic.getParent() != null && "root".equals(topic.getParent().getType()) && "attached".equals(topic.getType())) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    }

    protected static class Contributor {
        private String id;
        private String name;
        private ImageDescriptor icon;
        private List<Object> items;

        public Contributor(String id) {
            this(id, null, null);
        }

        public Contributor(String id, String name) {
            this(id, name, null);
        }

        public Contributor(String id, String name, ImageDescriptor icon) {
            this.id = id;
            this.name = name;
            this.icon = icon;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public ImageDescriptor getIcon() {
            return this.icon;
        }

        public void setId(String id) {
            this.id = id;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setIcon(ImageDescriptor icon) {
            this.icon = icon;
        }

        public void add(IAction action) {
            this.addItem(action);
            if (action != null) {
                action.setImageDescriptor(null);
                action.setDisabledImageDescriptor(null);
            }
        }

        public void add(IContributionItem item) {
            this.addItem(item);
        }

        public void add(Contributor subContributor) {
            this.addItem(subContributor);
        }

        public void clear() {
            this.items = null;
        }

        protected void addItem(Object item) {
            if (this.items == null) {
                this.items = new ArrayList<Object>();
            }
            this.items.add(item);
        }

        public void applyTo(IMenuManager manager) {
            if (this.items == null) {
                return;
            }
            for (Object item : this.items) {
                if (item instanceof IAction) {
                    manager.add((IAction)item);
                    continue;
                }
                if (item instanceof IContributionItem) {
                    manager.add((IContributionItem)item);
                    continue;
                }
                if (!(item instanceof Contributor)) continue;
                Contributor contribute = (Contributor)item;
                String name2 = contribute.getName();
                String id2 = contribute.getId();
                ImageDescriptor icon2 = contribute.getIcon();
                MenuManager subManager = new MenuManager(name2, icon2, id2);
                contribute.applyTo((IMenuManager)subManager);
                manager.add((IContributionItem)subManager);
            }
        }
    }

    private class ViewerSelectionChangedListener
    implements ISelectionChangedListener {
        private ViewerSelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            ContextMenuService.this.handleViewerSelectionChanged(event.getSelection());
        }
    }
}

