/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.presentation;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.draw2d.IFigure;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Display;
import org.xmind.core.IRelationship;
import org.xmind.core.ITopic;
import org.xmind.gef.IViewer;
import org.xmind.gef.draw2d.ITransparentableFigure;
import org.xmind.gef.draw2d.IUseTransparency;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.gef.part.IPart;
import org.xmind.gef.service.AbstractViewerService;
import org.xmind.ui.internal.presentation.INavigationHistoryListener;
import org.xmind.ui.internal.presentation.NavigationHistory;
import org.xmind.ui.mindmap.IBoundaryPart;
import org.xmind.ui.mindmap.IBranchPart;
import org.xmind.ui.mindmap.IMindMap;
import org.xmind.ui.mindmap.IRelationshipPart;
import org.xmind.ui.mindmap.ISummaryPart;
import org.xmind.ui.mindmap.ITitleTextPart;
import org.xmind.ui.mindmap.ITopicPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NavigationHistoryService
extends AbstractViewerService
implements ISelectionChangedListener,
INavigationHistoryListener {
    private NavigationHistory history;
    private boolean changingViewer = false;
    private Set<IGraphicalPart> visibleParts = new HashSet<IGraphicalPart>();
    private ISelectionChangedListener preSelectionChangedListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            NavigationHistoryService.this.preSelect(event.getSelection());
        }
    };
    private Set<IBranchPart> preSelectedBranches = new HashSet<IBranchPart>();
    private IBranchPart visiblePreSelectedParent = null;
    private ISelection lastSelection = null;
    private boolean restoreLastSelectionOnActivate;

    public NavigationHistoryService(IViewer viewer, boolean restoreLastSelectionOnActivate) {
        super(viewer);
        this.restoreLastSelectionOnActivate = restoreLastSelectionOnActivate;
    }

    protected void preSelect(ISelection selection) {
        Boolean isLightOn = (Boolean)this.getViewer().getProperties().get("org.xmind.ui.presentation.lightOnOff");
        if (isLightOn == null || !isLightOn.booleanValue()) {
            this.clearPreSelectedBranches();
            ITopicPart topicPart = this.findTopicPart(selection);
            if (topicPart != null) {
                this.collectPreSelectedBranches(topicPart.getOwnerBranch(), this.visibleParts.contains(topicPart));
            }
            this.showPreSelectedBranches();
        }
    }

    private void showPreSelectedBranches() {
        IFigure figure;
        for (IBranchPart b : this.preSelectedBranches) {
            IFigure figure2 = b.getFigure();
            if (!(figure2 instanceof IUseTransparency)) continue;
            IUseTransparency f = (IUseTransparency)figure2;
            f.setMainAlpha(255);
            f.setSubAlpha(255);
        }
        if (this.visiblePreSelectedParent != null && (figure = this.visiblePreSelectedParent.getFigure()) instanceof IUseTransparency) {
            IUseTransparency f = (IUseTransparency)figure;
            f.setSubAlpha(255);
        }
    }

    private void collectPreSelectedBranches(IBranchPart branch, boolean first) {
        if (this.visibleParts.contains(branch)) {
            IUseTransparency f;
            IFigure figure;
            if (!first && (figure = branch.getFigure()) instanceof IUseTransparency && (f = (IUseTransparency)figure).getSubAlpha() == 0) {
                this.visiblePreSelectedParent = branch;
            }
            return;
        }
        this.preSelectedBranches.add(branch);
        IBranchPart p = branch.getParentBranch();
        if (p != null) {
            this.collectPreSelectedBranches(p, false);
        }
    }

    private void clearPreSelectedBranches() {
        IFigure figure;
        for (IBranchPart b : this.preSelectedBranches) {
            if (this.visibleParts.contains(b)) {
                if (b.getParentBranch() != this.visiblePreSelectedParent) continue;
                this.visiblePreSelectedParent = null;
                continue;
            }
            IFigure figure2 = b.getFigure();
            if (!(figure2 instanceof IUseTransparency)) continue;
            IUseTransparency f = (IUseTransparency)figure2;
            f.setMainAlpha(0);
            f.setSubAlpha(0);
        }
        this.preSelectedBranches.clear();
        if (this.visiblePreSelectedParent != null && (figure = this.visiblePreSelectedParent.getFigure()) instanceof IUseTransparency) {
            IUseTransparency f = (IUseTransparency)figure;
            f.setSubAlpha(0);
        }
        this.visiblePreSelectedParent = null;
    }

    private ITopicPart findTopicPart(ISelection selection) {
        IPart p;
        Object o;
        if (selection instanceof IStructuredSelection && (o = ((IStructuredSelection)selection).getFirstElement()) != null && (p = this.getViewer().findPart(o)) instanceof ITopicPart) {
            return (ITopicPart)p;
        }
        return null;
    }

    public NavigationHistory getHistory() {
        return this.history;
    }

    public void setHistory(NavigationHistory history) {
        if (this.history != null && this.isActive()) {
            this.history.removeNavigationHistoryListener(this);
        }
        this.history = history;
        if (this.history != null && this.isActive()) {
            this.history.addNavigationHistoryListener(this);
        }
        this.update(true);
    }

    protected void activate() {
        if (this.restoreLastSelectionOnActivate && this.lastSelection != null) {
            this.getViewer().setSelection(this.lastSelection);
        }
        this.getViewer().addSelectionChangedListener((ISelectionChangedListener)this);
        this.getViewer().addPreSelectionChangedListener(this.preSelectionChangedListener);
        if (this.history != null) {
            this.history.addNavigationHistoryListener(this);
        }
        this.update(true);
    }

    protected void deactivate() {
        this.visibleParts.clear();
        this.update(false);
        if (this.history != null) {
            this.history.removeNavigationHistoryListener(this);
        }
        this.getViewer().removePreSelectionChangedListener(this.preSelectionChangedListener);
        this.getViewer().removeSelectionChangedListener((ISelectionChangedListener)this);
    }

    public boolean prev() {
        if (this.history == null) {
            return false;
        }
        ISelection selection = this.history.prev();
        if (selection == null) {
            return false;
        }
        this.setSelection(selection);
        return true;
    }

    public boolean next() {
        if (this.history == null) {
            return false;
        }
        ISelection selection = this.history.next();
        if (selection == null) {
            return false;
        }
        this.setSelection(selection);
        return true;
    }

    private void setSelection(ISelection selection) {
        this.changingViewer = true;
        this.getViewer().setSelection(selection);
        this.changingViewer = false;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        Boolean isLightOn = (Boolean)this.getViewer().getProperties().get("org.xmind.ui.presentation.lightOnOff");
        if (isLightOn == null || !isLightOn.booleanValue()) {
            if (this.changingViewer || this.history == null) {
                return;
            }
            this.history.add(event.getSelection());
        }
    }

    private void update(final boolean historyChanged) {
        Display.getCurrent().asyncExec(new Runnable(){

            public void run() {
                if (historyChanged) {
                    NavigationHistoryService.this.collectVisibleParts();
                }
                NavigationHistoryService.this.refreshEffect((IPart)NavigationHistoryService.this.getViewer().getRootPart(), false);
            }
        });
    }

    private boolean refreshEffect(IPart part, boolean preferredVisible) {
        boolean visible;
        if (part instanceof IBranchPart) {
            int subAlpha;
            IBranchPart branch = (IBranchPart)part;
            boolean visible2 = !this.isActive() || this.visibleParts.contains(branch);
            boolean subVisible = false;
            for (IBranchPart subBranch : branch.getSubBranches()) {
                subVisible |= this.refreshEffect((IPart)subBranch, visible2);
            }
            for (IBranchPart subBranch : branch.getSummaryBranches()) {
                subVisible |= this.refreshEffect((IPart)subBranch, visible2);
            }
            for (IBoundaryPart boundary : branch.getBoundaries()) {
                subVisible |= this.refreshEffect((IPart)boundary, subVisible);
            }
            for (ISummaryPart summary : branch.getSummaries()) {
                subVisible |= this.refreshEffect((IPart)summary, subVisible);
            }
            IFigure figure = branch.getFigure();
            int n = subAlpha = subVisible ? 255 : 0;
            if (figure instanceof ITransparentableFigure) {
                int mainAlpha = visible2 || subVisible ? 255 : 0;
                ((ITransparentableFigure)figure).setMainAlpha(mainAlpha);
                ((ITransparentableFigure)figure).setSubAlpha(subAlpha);
            }
            return visible2 || subVisible;
        }
        boolean bl = visible = preferredVisible || !this.isActive() || this.visibleParts.contains(part);
        if (part instanceof IBoundaryPart || part instanceof ISummaryPart) {
            ((IGraphicalPart)part).getFigure().setVisible(visible);
            this.refreshTitle(part, visible);
        } else if (part instanceof IRelationshipPart) {
            IRelationshipPart r = (IRelationshipPart)part;
            ((IGraphicalPart)part).getFigure().setVisible(visible |= !this.isActive() || this.visibleParts.contains(r.getSourceNode()) && this.visibleParts.contains(r.getTargetNode()));
            this.refreshTitle(part, visible);
        } else {
            for (IPart c : part.getChildren()) {
                visible |= this.refreshEffect(c, preferredVisible);
            }
        }
        return visible;
    }

    private void refreshTitle(IPart part, boolean visible) {
        ITitleTextPart title = (ITitleTextPart)part.getAdapter(ITitleTextPart.class);
        if (title != null) {
            title.getFigure().setVisible(visible);
        }
    }

    private void collectVisibleParts() {
        this.visibleParts.clear();
        if (this.history != null) {
            for (ISelection s : this.history.getHistory()) {
                if (!(s instanceof IStructuredSelection)) continue;
                for (Object o : ((IStructuredSelection)s).toList()) {
                    IPart p = this.getViewer().findPart(o);
                    if (p instanceof ITopicPart) {
                        this.collectBranch(((ITopicPart)p).getOwnerBranch());
                        continue;
                    }
                    if (!(p instanceof IGraphicalPart)) continue;
                    this.visibleParts.add((IGraphicalPart)p);
                }
            }
        }
    }

    private void collectBranch(IBranchPart branch) {
        this.visibleParts.add((IGraphicalPart)branch);
        this.visibleParts.add((IGraphicalPart)branch.getTopicPart());
        IBranchPart parent = branch.getParentBranch();
        if (parent != null && !this.visibleParts.contains(parent)) {
            this.collectBranch(parent);
        }
    }

    @Override
    public void navigationHistoryChanged(NavigationHistory history) {
        Boolean isLightOn = (Boolean)this.getViewer().getProperties().get("org.xmind.ui.presentation.lightOnOff");
        if (isLightOn == null || !isLightOn.booleanValue()) {
            this.update(true);
            this.lastSelection = history.current();
        }
    }

    public void turnOnDayMode(IMindMap mindMap) {
        Set<String> topicIdsInMindmap = this.showTopic(mindMap.getCentralTopic().getAllChildren());
        for (IRelationship relationship : mindMap.getSheet().getRelationships()) {
            if (!topicIdsInMindmap.contains(relationship.getEnd1Id()) || !topicIdsInMindmap.contains(relationship.getEnd2Id())) continue;
            IRelationshipPart part = (IRelationshipPart)this.getViewer().findPart((Object)relationship);
            part.getStatus().activate();
            part.getFigure().setVisible(true);
            part.getContentPane().setVisible(true);
            this.refreshTitle((IPart)part, true);
        }
    }

    private Set<String> showTopic(List<ITopic> topics) {
        HashSet<String> topicIds = new HashSet<String>();
        for (ITopic topic : topics) {
            topicIds.add(topic.getId());
            ITopicPart part = (ITopicPart)this.getViewer().findPart((Object)topic);
            part.getFigure().setVisible(true);
            ((ITransparentableFigure)part.getFigure()).setMainAlpha(255);
            ((ITransparentableFigure)part.getFigure()).setSubAlpha(255);
            this.refreshTitle((IPart)part, true);
            IBranchPart branchPart = part.getOwnerBranch();
            branchPart.getFigure().setVisible(true);
            ((ITransparentableFigure)branchPart.getFigure()).setMainAlpha(255);
            ((ITransparentableFigure)branchPart.getFigure()).setSubAlpha(255);
            this.refreshTitle((IPart)branchPart, true);
            List subtopics = topic.getAllChildren();
            if (subtopics == null || subtopics.isEmpty()) continue;
            topicIds.addAll(this.showTopic(subtopics));
        }
        return topicIds;
    }

    public void turnOffDayMode() {
        ISelection selection;
        List<ISelection> selectionHistory = this.history.getHistory();
        if (this.getViewer() != null && (selection = this.getViewer().getSelection()) != null && !selection.equals(selectionHistory.get(selectionHistory.size() - 1))) {
            if (selectionHistory.contains(selection)) {
                this.setSelection(selection);
            } else {
                this.setSelection(selectionHistory.get(selectionHistory.size() - 1));
            }
        }
        this.update(true);
    }
}

