/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.presentation.slide;

import java.util.List;
import org.eclipse.e4.ui.di.AboutToHide;
import org.eclipse.e4.ui.di.AboutToShow;
import org.eclipse.e4.ui.model.application.ui.menu.MDirectMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuFactory;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.xmind.core.IWorkbook;
import org.xmind.gef.IViewer;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.internal.presentation.slide.PresentationStory;
import org.xmind.ui.internal.presentation.slide.PresentationStoryManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoryMenu {
    @AboutToShow
    public void aboutToShow(List<MMenuElement> items) {
        IWorkbook workbook = this.getWorkbook();
        if (workbook != null) {
            List<PresentationStory> stories = PresentationStoryManager.instance.getStories(workbook);
            for (PresentationStory story : stories) {
                String name = story.getName();
                if (name == null || "".equals(name)) continue;
                MDirectMenuItem item = MMenuFactory.INSTANCE.createDirectMenuItem();
                item.setContainerData(story.getId());
                item.setLabel(name);
                item.setContributionURI("bundleclass://org.xmind.ui.presentation/org.xmind.ui.internal.presentation.slide.StoryMenuItemHandler");
                items.add((MMenuElement)item);
            }
            if (!stories.isEmpty()) {
                items.add((MMenuElement)MMenuFactory.INSTANCE.createMenuSeparator());
            }
        }
    }

    private IWorkbook getWorkbook() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            return null;
        }
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return null;
        }
        IEditorPart editor = page.getActiveEditor();
        if (editor == null) {
            return null;
        }
        IViewer viewer = (IViewer)MindMapUIPlugin.getAdapter((Object)editor, IViewer.class);
        if (viewer == null) {
            return null;
        }
        return (IWorkbook)viewer.getAdapter(IWorkbook.class);
    }

    @AboutToHide
    public void aboutToHide(List<MMenuElement> items) {
    }
}

