/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.presentation.slide;

import java.util.Arrays;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.xmind.gef.IViewer;
import org.xmind.gef.Request;
import org.xmind.gef.part.IGraphicalEditPart;
import org.xmind.gef.part.IPart;
import org.xmind.ui.internal.presentation.slide.PresentationStory;
import org.xmind.ui.internal.presentation.slide.PresentationStoryEditCover;
import org.xmind.ui.resources.FontUtils;
import org.xmind.ui.texteditor.FloatingTextEditor;
import org.xmind.ui.texteditor.IFloatingTextEditorListener;
import org.xmind.ui.texteditor.TextEvent;
import org.xmind.ui.tools.MindMapEditToolBase;

public class StoryTitleEditTool
extends MindMapEditToolBase {
    private Label source;
    private PresentationStory story;
    private String initialText;
    private PresentationStoryEditCover cover;
    private ResourceManager resources;

    public void setTextEditorParameters(PresentationStory story, Label source, PresentationStoryEditCover cover) {
        this.story = story;
        this.source = source;
        this.initialText = story.getName();
        this.cover = cover;
        this.resources = new LocalResourceManager(JFaceResources.getResources(), (Control)source);
    }

    protected String getInitialText(IPart source) {
        return this.initialText;
    }

    protected Request createTextRequest(IPart source, IDocument document) {
        IGraphicalEditPart sourcePart = this.getSource();
        if (sourcePart == null) {
            return null;
        }
        String newValue = document.get();
        if (newValue == null || "".equals(newValue)) {
            return null;
        }
        return new Request("modify").setViewer((IViewer)this.getTargetViewer()).setParameter("text", (Object)newValue).setTargets(Arrays.asList(sourcePart));
    }

    protected FloatingTextEditor createEditor() {
        Composite parent = this.source.getParent();
        int style = 2820;
        final FloatingTextEditor editor = new FloatingTextEditor(parent, style);
        editor.addFloatingTextEditorListener((IFloatingTextEditorListener)new IFloatingTextEditorListener.Stub(){

            public void editingStarted(TextEvent e) {
                editor.getTextViewer().getTextWidget().setFont((Font)StoryTitleEditTool.this.resources.get((DeviceResourceDescriptor)FontDescriptor.createFrom((FontData[])FontUtils.relativeHeight((FontData[])StoryTitleEditTool.this.source.getFont().getFontData(), (int)-1))));
                ((GridData)((StoryTitleEditTool)StoryTitleEditTool.this).source.getLayoutData()).exclude = true;
                StoryTitleEditTool.this.source.setVisible(false);
                GridData layoutData = new GridData(4, 128, true, false);
                layoutData.heightHint = 19;
                editor.getControl().setLayoutData((Object)layoutData);
                StoryTitleEditTool.this.source.getParent().layout(true, true);
            }

            public void editingCanceled(TextEvent e) {
                ((GridData)((StoryTitleEditTool)StoryTitleEditTool.this).source.getLayoutData()).exclude = false;
                StoryTitleEditTool.this.source.setVisible(true);
                StoryTitleEditTool.this.source.getParent().layout(true, true);
            }

            public void editingFinished(TextEvent e) {
                String name = e.text;
                if (name != null && !"".equals(name)) {
                    StoryTitleEditTool.this.source.setText(name);
                }
                ((GridData)((StoryTitleEditTool)StoryTitleEditTool.this).source.getLayoutData()).exclude = false;
                StoryTitleEditTool.this.source.setVisible(true);
                StoryTitleEditTool.this.source.getParent().layout(true, true);
            }
        });
        return editor;
    }

    protected boolean shouldUpdateSelectionOnEdit(IGraphicalEditPart newSource, Request request) {
        return false;
    }

    protected void handleTextModified(IPart source, IDocument document) {
        String name;
        if (this.finishedOnMouseDown) {
            this.finishedOnMouseDown = false;
            if (this.shouldIgnoreTextChange(source, document, this.oldText)) {
                return;
            }
        }
        if ((name = document.get()) != null && !"".equals(name)) {
            this.story.setName(name);
            if (this.cover != null) {
                this.cover.refreshTitle(this.story.getName());
            }
        }
    }
}

