/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.gallery;

import org.eclipse.draw2d.AbstractBorder;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;

public class ShadowBorder
extends AbstractBorder {
    private int hDepth;
    private int vDepth;
    private int borderWidth;
    private Color shadowColor = ColorConstants.black;
    private Color borderColor = ColorConstants.black;
    private int borderAlpha = 32;
    private int shadowAlpha = 128;
    private boolean hideShadow = false;

    public ShadowBorder() {
        this(1, 3, 3);
    }

    public ShadowBorder(int borderWidth, int horizontalDepth, int verticalDepth) {
        this.borderWidth = borderWidth;
        this.hDepth = horizontalDepth;
        this.vDepth = verticalDepth;
    }

    public int getHorizontalShadowDepth() {
        return this.hDepth;
    }

    public int getBorderWidth() {
        return this.borderWidth;
    }

    public void setShadowDepths(int depth) {
        this.setHorizontalShadowDepth(depth);
        this.setVerticalShadowDepth(depth);
    }

    public void setShadowDepths(Dimension depths) {
        this.setHorizontalShadowDepth(depths.width);
        this.setVerticalShadowDepth(depths.height);
    }

    public Dimension getShadowDepths() {
        return new Dimension(this.getHorizontalShadowDepth(), this.getVerticalShadowDepth());
    }

    public int getVerticalShadowDepth() {
        return this.vDepth;
    }

    public void setHorizontalShadowDepth(int depth) {
        this.hDepth = depth;
    }

    public void setBorderWidth(int lineWidth) {
        this.borderWidth = lineWidth;
    }

    public void setVerticalShadowDepth(int depth) {
        this.vDepth = depth;
    }

    public Color getShadowColor() {
        return this.shadowColor;
    }

    public void setShadowColor(Color backColor) {
        this.shadowColor = backColor;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public int getShadowAlpha() {
        return this.shadowAlpha;
    }

    public int getBorderAlpha() {
        return this.borderAlpha;
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
    }

    public void setShadowAlpha(int shadowAlpha) {
        this.shadowAlpha = shadowAlpha;
    }

    public void setBorderAlpha(int borderAlpha) {
        this.borderAlpha = borderAlpha;
    }

    public void reverseShadow() {
        this.hDepth = -this.hDepth;
        this.vDepth = -this.vDepth;
    }

    public boolean isShadowVisible() {
        return !this.hideShadow;
    }

    public void setShadowVisible(boolean visible) {
        this.hideShadow = !visible;
    }

    public void hideShadow() {
        this.hideShadow = true;
    }

    public void showShadow() {
        this.hideShadow = false;
    }

    public Insets getInsets(IFigure figure) {
        Insets ins = new Insets();
        int hd = this.getHorizontalShadowDepth();
        if (hd > 0) {
            ins.right += hd;
        } else {
            ins.left -= hd;
        }
        int vd = this.getVerticalShadowDepth();
        if (vd > 0) {
            ins.bottom += vd;
        } else {
            ins.top -= vd;
        }
        return ins;
    }

    public void paint(IFigure figure, Graphics graphics, Insets insets) {
        Rectangle r = ShadowBorder.getPaintRectangle((IFigure)figure, (Insets)insets);
        Rectangle c = r.shrink(this.getInsets(figure));
        int left = c.x;
        int right = c.right();
        int top = c.y;
        int bottom = c.bottom();
        int hd = this.getHorizontalShadowDepth();
        int vd = this.getVerticalShadowDepth();
        int bw = this.getBorderWidth();
        int height = c.height;
        int width = c.width;
        if (this.isShadowVisible() && (hd != 0 || vd != 0)) {
            Rectangle r1 = new Rectangle(left + hd, 0, width - Math.abs(hd), Math.min(height, Math.abs(vd)));
            Rectangle r2 = new Rectangle(0, top + vd, Math.min(width, Math.abs(hd)), height);
            if (hd < 0) {
                r1.x -= hd;
            }
            r1.y = vd > 0 ? bottom : top + vd;
            int n = r2.x = hd > 0 ? right : left + hd;
            if (figure.isEnabled()) {
                graphics.setBackgroundColor(this.getShadowColor());
            } else {
                graphics.setBackgroundColor(ColorConstants.buttonLightest);
            }
            graphics.setAlpha(this.getShadowAlpha());
            if (!r1.isEmpty()) {
                graphics.fillRectangle(r1);
            }
            graphics.fillRectangle(r2);
        }
        if (bw > 0) {
            if (figure.isEnabled()) {
                graphics.setForegroundColor(this.getBorderColor());
            } else {
                graphics.setForegroundColor(ColorConstants.buttonDarker);
            }
            graphics.setAlpha(this.getBorderAlpha());
            graphics.setLineStyle(1);
            graphics.setLineWidth(bw);
            graphics.drawRectangle(left + bw / 2, top + bw / 2, width - bw, height - bw);
        }
    }
}

