/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.cathy.internal.css;

import org.eclipse.e4.ui.css.core.dom.properties.Gradient;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.swt.helpers.CSSSWTColorHelper;
import org.eclipse.e4.ui.css.swt.properties.AbstractCSSPropertySWTHandler;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.internal.forms.widgets.FormHeading;
import org.w3c.dom.css.CSSValue;

public class CSSPropertyFormHeadingHandler
extends AbstractCSSPropertySWTHandler {
    public static final CSSPropertyFormHeadingHandler INSTANCE = new CSSPropertyFormHeadingHandler();

    protected void applyCSSProperty(Control control, String property, CSSValue value, String pseudo, CSSEngine engine) throws Exception {
        if (!(control instanceof FormHeading)) {
            return;
        }
        FormHeading formHeading = (FormHeading)control;
        if ("xmind-text-background".equals(property)) {
            this.applyCSSPropertyTextBackgroud(formHeading, value, engine);
        } else if ("xmind-bottom-keyline-1-color".equals(property)) {
            Color keyline1Color = (Color)engine.convert(value, Color.class, (Object)formHeading.getDisplay());
            formHeading.putColor("org.eclipse.ui.forms.H_BOTTOM_KEYLINE1", keyline1Color);
        } else if ("xmind-bottom-keyline-2-color".equals(property)) {
            Color keyline2Color = (Color)engine.convert(value, Color.class, (Object)formHeading.getDisplay());
            formHeading.putColor("org.eclipse.ui.forms.H_BOTTOM_KEYLINE2", keyline2Color);
        }
    }

    private void applyCSSPropertyTextBackgroud(FormHeading formHeading, CSSValue value, CSSEngine engine) throws Exception {
        if (value.getCssValueType() == 2) {
            Gradient grad = (Gradient)engine.convert(value, Gradient.class, (Object)formHeading.getDisplay());
            if (grad == null) {
                return;
            }
            Color[] colors = null;
            int[] percents = null;
            if (!grad.getValues().isEmpty()) {
                colors = CSSSWTColorHelper.getSWTColors((Gradient)grad, (Display)formHeading.getDisplay(), (CSSEngine)engine);
                percents = CSSSWTColorHelper.getPercents((Gradient)grad);
            }
            formHeading.setTextBackground(colors, percents, true);
        } else if (value.getCssValueType() == 1) {
            Color color = (Color)engine.convert(value, Color.class, (Object)formHeading.getDisplay());
            formHeading.setTextBackground(new Color[]{color, color}, new int[]{100}, true);
        }
    }

    protected String retrieveCSSProperty(Control control, String property, String pseudo, CSSEngine engine) throws Exception {
        if (control instanceof FormHeading) {
            if ("xmind-bottom-keyline-1-color".equals(property)) {
                Color keyline1Color = ((FormHeading)control).getColor("org.eclipse.ui.forms.H_BOTTOM_KEYLINE1");
                return engine.convert((Object)keyline1Color, Color.class, null);
            }
            if ("xmind-bottom-keyline-2-color".equals(property)) {
                Color keyline2Color = ((FormHeading)control).getColor("org.eclipse.ui.forms.H_BOTTOM_KEYLINE2");
                return engine.convert((Object)keyline2Color, Color.class, null);
            }
        }
        return null;
    }
}

