/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.cathy.internal.dashboard;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.sql.Date;
import java.text.DateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.xmind.cathy.internal.CathyPlugin;
import org.xmind.cathy.internal.dashboard.RecentContainerLayout;
import org.xmind.gef.draw2d.SizeableImageFigure;
import org.xmind.ui.editor.IEditorHistory;
import org.xmind.ui.editor.IEditorHistoryItem;
import org.xmind.ui.gallery.IDecorationContext;
import org.xmind.ui.gallery.ILabelDecorator;
import org.xmind.ui.mindmap.MindMapUI;

public class RecentFilesLabelProvider
extends LabelProvider
implements ILabelDecorator {
    Image pinImage;
    protected static final String COLOR_NONEXISTING_WORKBOOK_COVER = "#DDDDDD";
    protected static final String COLOR_NONEXISTING_WORKBOOK_TEXT = "#CCCCCC";
    private LocalResourceManager resources;
    private IEditorHistory editorHistory;
    private Map<Object, Image> images = new HashMap<Object, Image>();

    public RecentFilesLabelProvider(Composite parent) {
        this.resources = new LocalResourceManager(JFaceResources.getResources(), (Control)parent);
        this.editorHistory = (IEditorHistory)PlatformUI.getWorkbench().getService(IEditorHistory.class);
    }

    public void clear() {
        Object[] imageArray = this.images.values().toArray();
        this.images.clear();
        Object[] objectArray = imageArray;
        int n = imageArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object image = objectArray[n2];
            ((Image)image).dispose();
            ++n2;
        }
    }

    public void dispose() {
        this.resources.dispose();
        this.clear();
        super.dispose();
    }

    public String getText(Object element) {
        if (!(element instanceof URI)) {
            return super.getText(element);
        }
        URI uri = (URI)element;
        IEditorHistoryItem item = this.editorHistory.getItem(uri);
        if (item != null) {
            String name = item.getName();
            Assert.isTrue((name != null ? 1 : 0) != 0);
            StringBuffer buf = new StringBuffer();
            if (name.length() > 20) {
                name = String.valueOf(name.substring(0, 20)) + "...";
            }
            buf.append(name);
            return buf.toString();
        }
        return uri.toString();
    }

    public Image getImage(Object element) {
        if (element instanceof URI) {
            URI uri = (URI)element;
            Image image = this.images.get(uri);
            if (image != null && !image.isDisposed()) {
                return image;
            }
            image = this.getImageByThumb(uri);
            if (image != null && !image.isDisposed()) {
                this.images.put(uri, image);
            }
            return image;
        }
        return this.resources.createImage(MindMapUI.getImages().get("thumbnail.png", true));
    }

    /*
     * Loose catch block
     */
    private Image getImageByThumb(URI uri) {
        block22: {
            InputStream thumbnailData;
            block21: {
                thumbnailData = null;
                thumbnailData = this.editorHistory.loadThumbnailData(uri);
                if (thumbnailData == null) break block21;
                Image image = new Image(this.resources.getDevice(), thumbnailData);
                try {
                    if (thumbnailData != null) {
                        thumbnailData.close();
                    }
                }
                catch (IOException iOException) {}
                return image;
                catch (IOException e) {
                    CathyPlugin.log(e, String.format("Failed to load preview image for recent page uri == %s", uri));
                    try {
                        if (thumbnailData != null) {
                            thumbnailData.close();
                        }
                        break block22;
                    }
                    catch (IOException iOException) {}
                    break block22;
                }
                catch (SWTException e2) {
                    CathyPlugin.log(e2, String.format("Failed to load preview image for recent page uri == %s", uri));
                    {
                        catch (Throwable throwable) {
                            try {
                                if (thumbnailData != null) {
                                    thumbnailData.close();
                                }
                            }
                            catch (IOException iOException) {}
                            throw throwable;
                        }
                    }
                    try {
                        if (thumbnailData != null) {
                            thumbnailData.close();
                        }
                        break block22;
                    }
                    catch (IOException iOException) {}
                    break block22;
                }
            }
            try {
                if (thumbnailData != null) {
                    thumbnailData.close();
                }
            }
            catch (IOException iOException) {}
        }
        return this.resources.createImage(MindMapUI.getImages().get("thumbnail.png", true));
    }

    public IFigure decorateFigure(IFigure figure, Object element, IDecorationContext context) {
        if (!(element instanceof URI)) {
            return figure;
        }
        return this.decorateFrameFigure(figure, (URI)element, context);
    }

    protected IFigure decorateFrameFigure(IFigure contentPane, URI uri, IDecorationContext context) {
        SizeableImageFigure pinIcon;
        SizeableImageFigure thumbnailFigure;
        List figures = contentPane.getChildren();
        boolean needInitFigureContent = figures.isEmpty();
        if (needInitFigureContent) {
            contentPane.setLayoutManager((LayoutManager)new RecentFrameContentLayout(context));
            thumbnailFigure = new SizeableImageFigure(this.getImage(uri));
            pinIcon = new SizeableImageFigure(this.getPinImage(uri));
            contentPane.add((IFigure)thumbnailFigure);
            contentPane.add((IFigure)pinIcon, (Object)9);
            if (context != null) {
                boolean imageConstrained = Boolean.TRUE.equals(context.getProperty("constrained", (Object)false));
                boolean imageStretched = Boolean.TRUE.equals(context.getProperty("stretched", (Object)false));
                thumbnailFigure.setConstrained(imageConstrained);
                thumbnailFigure.setStretched(imageStretched);
            }
        } else {
            thumbnailFigure = (SizeableImageFigure)figures.get(0);
            pinIcon = (SizeableImageFigure)figures.get(1);
        }
        thumbnailFigure.setImage(this.getImage(uri));
        pinIcon.setImage(this.getPinImage(uri));
        return contentPane;
    }

    private Image getPinImage(URI uri) {
        boolean isPin = this.editorHistory.isPinned(uri);
        return isPin ? this.getPinImage() : null;
    }

    private Image getPinImage() {
        ImageDescriptor desc;
        if (this.pinImage == null && (desc = MindMapUI.getImages().get("pin.png", true)) != null) {
            try {
                this.pinImage = this.resources.createImage(desc);
            }
            catch (Throwable throwable) {}
        }
        return this.pinImage;
    }

    public String getSubtitle(Object element) {
        if (element instanceof URI) {
            IEditorHistoryItem item = this.editorHistory.getItem((URI)element);
            long t = item.getOpenedTime();
            Date date = new Date(t);
            return DateFormat.getDateTimeInstance(2, 3).format(date);
        }
        Date newDate = new Date(System.currentTimeMillis());
        return DateFormat.getDateTimeInstance(2, 3).format(newDate);
    }

    protected static class RecentFrameContentLayout
    extends RecentContainerLayout {
        private IDecorationContext context;

        public RecentFrameContentLayout(IDecorationContext context) {
            this.context = context;
        }

        @Override
        protected Dimension calculatePreferredSize(IFigure figure, int wHint, int hHint) {
            if (this.context != null) {
                Insets insets = figure.getInsets();
                Dimension contentSize = (Dimension)this.context.getProperty("org.xmind.ui.gallery.frameContentSize", null);
                if (contentSize != null) {
                    return new Dimension(contentSize.width + insets.getWidth(), contentSize.height + insets.getHeight());
                }
            }
            return super.calculatePreferredSize(figure, wHint, hHint);
        }
    }
}

