/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.cathy.internal.renderer;

import org.eclipse.draw2d.TextUtilities;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.workbench.renderers.swt.StackRenderer;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.xmind.cathy.internal.CathyPlugin;
import org.xmind.cathy.internal.WorkbenchMessages;
import org.xmind.ui.internal.utils.CommandUtils;
import org.xmind.ui.resources.ColorUtils;

public class XEditorStackRenderer
extends StackRenderer {
    private static final int CORNER = 5;
    private ResourceManager resources;
    private Rectangle buttonBounds;
    private Color buttonBackground;

    public Object createWidget(MUIElement element, Object parent) {
        final CTabFolder ctf = (CTabFolder)super.createWidget(element, parent);
        this.resources = new LocalResourceManager(JFaceResources.getResources(), (Control)ctf);
        this.buttonBackground = (Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)(Util.isMac() ? "#ffffff" : "#e1e1e1")));
        ctf.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (!XEditorStackRenderer.this.isNullEditorState(ctf)) {
                    return;
                }
                if (e.display.getActiveShell() == ctf.getShell()) {
                    ctf.setFocus();
                }
                GC gc = e.gc;
                boolean oldAdvanced = gc.getAdvanced();
                int oldAntialias = gc.getAntialias();
                try {
                    gc.setAdvanced(true);
                    gc.setAntialias(1);
                    Rectangle clientArea = ctf.getClientArea();
                    Image image = (Image)XEditorStackRenderer.this.resources.get((DeviceResourceDescriptor)CathyPlugin.imageDescriptorFromPlugin((String)"org.xmind.cathy", (String)"icons/views/null_editor_tip.png"));
                    Point imageSize = new Point(image.getBounds().width, image.getBounds().height);
                    Dimension textExtents = TextUtilities.INSTANCE.getTextExtents(WorkbenchMessages.XStackRenderer_BottomArea_Add_button, gc.getFont());
                    Point buttonSize = new Point(Math.max(128, textExtents.width + 10), Util.isMac() ? 21 : 25);
                    Point imagePos = new Point(clientArea.x + (clientArea.width - imageSize.x) / 2, clientArea.y + (clientArea.height - (imageSize.y + 40 + buttonSize.y)) / 2);
                    gc.drawImage(image, imagePos.x, imagePos.y);
                    Point buttonPos = new Point(clientArea.x + (clientArea.width - buttonSize.x) / 2, imagePos.y + image.getBounds().height + 40);
                    XEditorStackRenderer.this.buttonBounds = new Rectangle(buttonPos.x, buttonPos.y, buttonSize.x, buttonSize.y);
                    XEditorStackRenderer.this.drawButton(gc, XEditorStackRenderer.this.buttonBounds);
                    Point textPos = new Point(((XEditorStackRenderer)XEditorStackRenderer.this).buttonBounds.x + (((XEditorStackRenderer)XEditorStackRenderer.this).buttonBounds.width - textExtents.width) / 2, ((XEditorStackRenderer)XEditorStackRenderer.this).buttonBounds.y + (((XEditorStackRenderer)XEditorStackRenderer.this).buttonBounds.height - textExtents.height) / 2);
                    gc.setBackground(XEditorStackRenderer.this.buttonBackground);
                    gc.setForeground((Color)XEditorStackRenderer.this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#000000")));
                    gc.drawText(WorkbenchMessages.XStackRenderer_BottomArea_Add_button, textPos.x, textPos.y);
                }
                finally {
                    gc.setAdvanced(oldAdvanced);
                    gc.setAntialias(oldAntialias);
                }
            }
        });
        ctf.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (XEditorStackRenderer.this.isNullEditorState(ctf) && XEditorStackRenderer.this.buttonBounds != null && XEditorStackRenderer.this.buttonBounds.contains(e.x, e.y)) {
                    CommandUtils.executeCommand((String)"org.xmind.ui.command.newWorkbook", (IWorkbenchWindow)PlatformUI.getWorkbench().getActiveWorkbenchWindow());
                }
            }
        });
        return ctf;
    }

    private boolean isNullEditorState(CTabFolder ctf) {
        return ctf.getItemCount() == 0;
    }

    private void drawButton(GC gc, Rectangle buttonBounds) {
        if (!Util.isMac()) {
            gc.setForeground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#f0f0f0")));
            gc.drawRectangle(buttonBounds.x - 1, buttonBounds.y - 1, buttonBounds.width + 2, buttonBounds.height + 2);
        }
        gc.setBackground(this.buttonBackground);
        gc.setForeground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#adadad")));
        if (Util.isMac()) {
            gc.fillRoundRectangle(buttonBounds.x, buttonBounds.y, buttonBounds.width, buttonBounds.height, 5, 5);
            gc.drawRoundRectangle(buttonBounds.x, buttonBounds.y, buttonBounds.width, buttonBounds.height, 5, 5);
        } else {
            gc.fillRectangle(buttonBounds);
            gc.drawRectangle(buttonBounds);
        }
    }
}

