/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.draw2d.decoration;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.widgets.Display;
import org.xmind.gef.draw2d.decoration.AbstractConnectionDecoration;
import org.xmind.gef.draw2d.decoration.IConnectionDecorationEx;
import org.xmind.gef.draw2d.geometry.PrecisionRectangle;
import org.xmind.gef.draw2d.graphics.GraphicsUtils;

public abstract class PathConnectionDecoration
extends AbstractConnectionDecoration
implements IConnectionDecorationEx {
    protected PathConnectionDecoration() {
    }

    protected PathConnectionDecoration(String id) {
        super(id);
    }

    protected boolean usesFill() {
        return false;
    }

    protected void drawLine(IFigure figure, Graphics graphics) {
        if (this.usesFill()) {
            Color bg = graphics.getBackgroundColor();
            graphics.setBackgroundColor(graphics.getForegroundColor());
            org.xmind.gef.draw2d.graphics.Path shape = new org.xmind.gef.draw2d.graphics.Path((Device)Display.getCurrent());
            this.route(figure, shape);
            this.paintPath(figure, graphics, shape, true);
            shape.dispose();
            graphics.setBackgroundColor(bg);
        } else {
            org.xmind.gef.draw2d.graphics.Path shape = new org.xmind.gef.draw2d.graphics.Path((Device)Display.getCurrent());
            this.route(figure, shape);
            this.paintPath(figure, graphics, shape, false);
            shape.dispose();
        }
    }

    protected void paintPath(IFigure figure, Graphics graphics, org.xmind.gef.draw2d.graphics.Path path, boolean fill) {
        if (fill) {
            graphics.fillPath((Path)path);
        } else if (this.getLineWidth() > 0) {
            graphics.drawPath((Path)path);
        }
    }

    protected abstract void route(IFigure var1, org.xmind.gef.draw2d.graphics.Path var2);

    public boolean containsPoint(IFigure figure, int x, int y) {
        this.checkValidation(figure);
        GC gc = GraphicsUtils.getAdvanced().getGC();
        gc.setLineWidth(this.getLineWidthForChecking());
        org.xmind.gef.draw2d.graphics.Path shape = new org.xmind.gef.draw2d.graphics.Path((Device)Display.getCurrent());
        this.route(figure, shape);
        boolean usesFill = this.usesFill();
        boolean ret = shape.contains(x, y, gc, !usesFill);
        if (!ret && usesFill && this.checkOutline(figure)) {
            ret = shape.contains(x, y, gc, true);
        }
        shape.dispose();
        return ret;
    }

    protected boolean checkOutline(IFigure figure) {
        return true;
    }

    protected int getLineWidthForChecking() {
        return this.getLineWidth();
    }

    public Rectangle getPreferredBounds(IFigure figure) {
        this.checkValidation(figure);
        org.xmind.gef.draw2d.graphics.Path shape = new org.xmind.gef.draw2d.graphics.Path((Device)Display.getCurrent());
        this.route(figure, shape);
        float[] bounds = new float[4];
        shape.getBounds(bounds);
        if (Util.isWindows()) {
            float[] autoScaleDown = DPIUtil.autoScaleDown((float[])bounds);
            bounds[0] = autoScaleDown[0];
            bounds[1] = autoScaleDown[1];
            bounds[2] = autoScaleDown[2];
            bounds[3] = autoScaleDown[3];
        }
        shape.dispose();
        return PrecisionRectangle.toDraw2DRectangle(bounds[0], bounds[1], bounds[2], bounds[3]).expand(this.getLineWidth(), this.getLineWidth());
    }
}

