/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.service;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.draw2d.geometry.Geometry;
import org.xmind.gef.draw2d.geometry.PrecisionPoint;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.gef.service.BaseRevealService;
import org.xmind.gef.service.RevealEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ZoomingAndPanningRevealService
extends BaseRevealService {
    private static final int INTERVALS = 20;
    private int duration = 200;
    private int delay = 100;
    private RevealJob job = null;
    private double cachedScale = -1.0;
    private boolean centered = false;
    private int spacing = 20;
    private boolean zoomed = false;
    private boolean animationEnabled = true;
    private boolean shouldRevealOnIntersection = true;

    protected ZoomingAndPanningRevealService(IGraphicalViewer viewer) {
        super(viewer);
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public int getDelay() {
        return this.delay;
    }

    public void setDelay(int delay) {
        this.delay = delay;
    }

    public void setCentered(boolean centered) {
        this.centered = centered;
    }

    public boolean isCentered() {
        return this.centered;
    }

    public void setSpacing(int spacing) {
        this.spacing = spacing;
    }

    public int getSpacing() {
        return this.spacing;
    }

    public void setZoomed(boolean zoomed) {
        this.zoomed = zoomed;
    }

    public void setShouldRevealOnIntersection(boolean should) {
        this.shouldRevealOnIntersection = should;
    }

    public boolean isShouldRevealOnIntersection() {
        return this.shouldRevealOnIntersection;
    }

    public boolean isZoomed() {
        return this.zoomed;
    }

    public void setAnimationEnabled(boolean animationEnabled) {
        this.animationEnabled = animationEnabled;
    }

    protected boolean isAnimationEnabled() {
        return this.animationEnabled;
    }

    @Override
    protected void activate() {
    }

    @Override
    protected void deactivate() {
    }

    @Override
    public void reveal(ISelection selection) {
        if (!this.isActive()) {
            return;
        }
        this.startReveal(selection);
    }

    protected void startReveal(ISelection selection) {
        if (this.job != null) {
            this.job.cancel();
            this.job = null;
        }
        this.cachedScale = -1.0;
        List<IGraphicalPart> toReveal = this.collectPartsToReveal(selection);
        if (toReveal != null && this.shouldReveal(toReveal)) {
            Display display = Display.getCurrent();
            this.job = new RevealJob(display, toReveal);
            display.timerExec(this.delay, (Runnable)this.job);
            this.revealingStarted(new RevealEvent(this, toReveal));
        }
    }

    protected boolean shouldReveal(List<IGraphicalPart> toReveal) {
        return !toReveal.isEmpty();
    }

    protected double calcTargetScale(List<IGraphicalPart> toReveal, Rectangle revealBounds) {
        if (!this.isZoomed()) {
            return -1.0;
        }
        if (this.cachedScale > 0.0) {
            return this.cachedScale;
        }
        Rectangle clientArea = this.getViewer().getClientArea();
        int width = revealBounds.width;
        int height = revealBounds.height;
        double scale = 2.3;
        double w = (double)width * scale;
        double h = (double)height * scale;
        double minWidth = (double)clientArea.width * 0.08;
        double minHeight = (double)clientArea.height * 0.08;
        if (w < minWidth || h < minHeight) {
            double s1 = w < minWidth ? minWidth / (double)width : scale;
            double s2 = h < minHeight ? minHeight / (double)height : scale;
            scale = Math.max(s1, s2);
            w = (double)width * scale;
            h = (double)height * scale;
        }
        double maxWidth = (double)clientArea.width * 0.6;
        double maxHeight = (double)clientArea.height * 0.6;
        if (w > maxWidth || h > maxHeight) {
            double s1 = w > maxWidth ? maxWidth / (double)width : scale;
            double s2 = h > maxHeight ? maxHeight / (double)height : scale;
            scale = Math.min(s1, s2);
        }
        this.cachedScale = scale;
        return scale;
    }

    protected PrecisionPoint calcTargetCenter(List<IGraphicalPart> toReveal, Rectangle revealBounds, double targetScale) {
        if (this.isCentered()) {
            return new PrecisionPoint(revealBounds.getCenter());
        }
        return this.calcLeastTargetCenter(toReveal, revealBounds, targetScale);
    }

    protected PrecisionPoint calcLeastTargetCenter(List<IGraphicalPart> toReveal, Rectangle revealBounds, double targetScale) {
        Rectangle clientArea = this.getViewerClientArea();
        revealBounds.expand(this.getSpacing(), this.getSpacing());
        if (this.shouldReveal(revealBounds, clientArea)) {
            int dx = 0;
            int dy = 0;
            int margin = 50;
            int offsetH = clientArea.width >> 1;
            int offsetV = clientArea.height >> 1;
            if (revealBounds.x < clientArea.x) {
                dx = revealBounds.x + offsetH - margin - this.getSpacing();
            } else if (revealBounds.right() > clientArea.right()) {
                dx = revealBounds.right() - offsetH + margin + this.getSpacing();
            }
            if (revealBounds.y < clientArea.y) {
                dy = revealBounds.y + offsetV - margin - this.getSpacing();
            } else if (revealBounds.bottom() > clientArea.bottom()) {
                dy = revealBounds.bottom() - offsetV + margin + this.getSpacing();
            }
            dx = (int)(dx == 0 ? this.getViewerCenterPoint((double)this.getViewerScale()).x : (double)dx);
            dy = (int)(dy == 0 ? this.getViewerCenterPoint((double)this.getViewerScale()).y : (double)dy);
            return this.getViewerCenterPoint(this.getViewerScale()).translate(dx, dy);
        }
        return null;
    }

    protected boolean shouldReveal(Rectangle revealBounds, Rectangle clientArea) {
        if (this.isShouldRevealOnIntersection()) {
            return !clientArea.contains(revealBounds) && !revealBounds.contains(clientArea);
        }
        return clientArea.bottom() < revealBounds.bottom() || clientArea.getTop().y > revealBounds.y || clientArea.right() < revealBounds.right() || clientArea.getLeft().x > revealBounds.x;
    }

    protected Rectangle getViewerClientArea() {
        Rectangle clientArea = this.getViewer().getClientArea();
        return this.getViewer().getZoomManager().getAntiScaled(clientArea);
    }

    protected Rectangle getRevealBounds(List<IGraphicalPart> parts) {
        Rectangle r = null;
        for (IGraphicalPart p : parts) {
            r = Geometry.union(r, this.getRevealBounds(p));
        }
        return r;
    }

    protected Rectangle getRevealBounds(IGraphicalPart p) {
        return p.getFigure().getBounds();
    }

    protected double getViewerScale() {
        return this.getViewer().getZoomManager().getScale();
    }

    protected PrecisionPoint getViewerCenterPoint(double scale) {
        return new PrecisionPoint(this.getViewer().getCenterPoint()).scale(1.0 / scale);
    }

    protected List<IGraphicalPart> collectPartsToReveal(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            ArrayList<IGraphicalPart> list = new ArrayList<IGraphicalPart>(ss.size());
            for (Object o : ss.toList()) {
                IGraphicalPart p = this.getViewer().findGraphicalPart(o);
                if (p == null || this.exclude(p)) continue;
                list.add(p);
            }
            return list;
        }
        return null;
    }

    protected boolean exclude(IGraphicalPart part) {
        return false;
    }

    protected void finishCurrentJob() {
        if (this.job != null) {
            this.job.finish();
            this.job = null;
        }
    }

    protected void cancelCurrentJob() {
        if (this.job != null) {
            this.job.cancel();
            this.job = null;
        }
    }

    protected void revealJobFinished(List<IGraphicalPart> toReveal) {
        Rectangle revealBounds = this.getRevealBounds(toReveal);
        if (revealBounds != null) {
            double targetScale = this.calcTargetScale(toReveal, revealBounds);
            PrecisionPoint targetCenter = this.calcTargetCenter(toReveal, revealBounds, targetScale);
            if (targetScale > 0.0) {
                this.getViewer().getZoomManager().setScale(targetScale);
            }
            if (targetCenter != null) {
                this.getViewer().center(targetCenter.getScaled(this.getViewerScale()).toRoundedDraw2DPoint());
            }
        }
        this.revealingFinished(new RevealEvent(this, toReveal));
    }

    protected void doStep(List<IGraphicalPart> toReveal, Rectangle revealBounds, int remainingSteps) {
        double scale = this.getViewerScale();
        PrecisionPoint center = this.getViewerCenterPoint(scale);
        double targetScale = this.calcTargetScale(toReveal, revealBounds);
        PrecisionPoint targetCenter = this.calcTargetCenter(toReveal, revealBounds, targetScale);
        if (targetScale > 0.0) {
            double remainingScale = targetScale - scale;
            double stepScale = remainingScale / (double)remainingSteps;
            this.getViewer().getZoomManager().setScale(scale += stepScale);
        }
        if (targetCenter != null) {
            double horizontalOffset = targetCenter.x - center.x;
            double verticalOffset = targetCenter.y - center.y;
            double stepX = horizontalOffset / (double)remainingSteps;
            double stepY = verticalOffset / (double)remainingSteps;
            center.x += stepX;
            center.y += stepY;
            this.getViewer().center(targetCenter.getScaled(this.getViewerScale()).toRoundedDraw2DPoint());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RevealJob
    implements Runnable {
        private Display display;
        private List<IGraphicalPart> toReveal;
        private long startTime = -1L;
        private boolean canceled = false;
        private int elapsedSteps = -1;

        public RevealJob(Display display, List<IGraphicalPart> toReveal) {
            this.display = display;
            this.toReveal = toReveal;
        }

        public void cancel() {
            boolean oldCanceled = this.canceled;
            this.setCanceled();
            if (!oldCanceled) {
                ZoomingAndPanningRevealService.this.revealingCanceled(new RevealEvent(ZoomingAndPanningRevealService.this, this.toReveal));
            }
        }

        private void setCanceled() {
            this.canceled = true;
        }

        @Override
        public void run() {
            if (this.canceled) {
                return;
            }
            Control control = ZoomingAndPanningRevealService.this.getViewer().getControl();
            if (control == null || control.isDisposed()) {
                this.setCanceled();
                return;
            }
            if (!ZoomingAndPanningRevealService.this.isAnimationEnabled()) {
                this.finish();
                return;
            }
            long currentTime = System.currentTimeMillis();
            if (this.startTime < 0L) {
                this.startTime = currentTime;
            }
            int elapsedTime = (int)(currentTime - this.startTime);
            int remainingTime = ZoomingAndPanningRevealService.this.getDuration() - elapsedTime;
            if (remainingTime <= 0) {
                this.finish();
                return;
            }
            double intervals = 20.0;
            if (this.elapsedSteps < 0) {
                this.elapsedSteps = 0;
                intervals += 10.0;
            } else {
                intervals += (double)(currentTime - this.startTime - (long)(20 * this.elapsedSteps)) / (double)this.elapsedSteps;
            }
            int remainingSteps = (int)(((double)remainingTime + intervals - 1.0) / intervals);
            if (remainingSteps <= 0) {
                this.finish();
                return;
            }
            Rectangle revealBounds = ZoomingAndPanningRevealService.this.getRevealBounds(this.toReveal);
            if (revealBounds == null) {
                this.cancel();
                return;
            }
            ZoomingAndPanningRevealService.this.doStep(this.toReveal, revealBounds, remainingSteps);
            this.display.timerExec(20, (Runnable)this);
            ++this.elapsedSteps;
        }

        public void finish() {
            this.setCanceled();
            ZoomingAndPanningRevealService.this.revealJobFinished(this.toReveal);
        }
    }
}

