/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.util.SafeRunnable;
import org.xmind.gef.util.IEventDispatcher;

public class EventListenerSupport {
    private Map<Object, List<Object>> map = new HashMap<Object, List<Object>>();

    public void addListener(Object type, Object listener) {
        List<Object> list = this.map.get(type);
        if (list == null) {
            list = new ArrayList<Object>();
            this.map.put(type, list);
        }
        list.add(listener);
    }

    public void removeListener(Object type, Object listener) {
        List<Object> list = this.map.get(type);
        if (list != null) {
            list.remove(listener);
            if (list.isEmpty()) {
                this.map.remove(type);
            }
        }
    }

    public void clear(Object type) {
        this.map.remove(type);
    }

    public void clearAll() {
        this.map.clear();
    }

    public boolean isEmpty(Object type) {
        List<Object> list = this.map.get(type);
        return list == null || list.isEmpty();
    }

    public void fireEvent(Object type, final IEventDispatcher dispatcher) {
        List<Object> list = this.map.get(type);
        if (list != null && !list.isEmpty()) {
            Object[] listeners = list.toArray();
            int i = 0;
            while (i < listeners.length) {
                final Object listener = listeners[i];
                SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                    public void run() throws Exception {
                        dispatcher.dispatch(listener);
                    }
                });
                ++i;
            }
        }
    }
}

