/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.presentation;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.xmind.ui.internal.presentation.Button;

public class Slider {
    private static final Rectangle RECT = new Rectangle();
    private int id;
    private Button slideway;
    private Button button;
    private Point hotSpot;
    private float value = 0.0f;

    public Slider(int id, Button button, Button slideway) {
        this(id, button, slideway, null);
    }

    public Slider(int id, Button button, Button slideway, Point hotSpot) {
        this.id = id;
        this.slideway = slideway;
        this.button = button;
        if (hotSpot != null) {
            this.hotSpot = new Point(hotSpot);
        } else {
            Dimension size = button.getPreferredSize();
            this.hotSpot = new Point(size.width / 2, size.height / 2);
        }
    }

    public int getId() {
        return this.id;
    }

    public Button getButton() {
        return this.button;
    }

    public float getValue() {
        return this.value;
    }

    public void setValue(float value) {
        this.value = value;
    }

    public Button getSliderWay() {
        return this.slideway;
    }

    public float calcValue(Point pos) {
        if (pos.x <= this.slideway.getBounds().x) {
            return 0.0f;
        }
        if (pos.x >= this.slideway.getBounds().right()) {
            return 1.0f;
        }
        return (float)Math.abs(pos.x - this.slideway.getBounds().x) / (float)Math.abs(this.slideway.getBounds().width);
    }

    public void layout(Rectangle parentBounds) {
        RECT.setSize(this.button.getPreferredSize());
        RECT.setLocation(this.slideway.getBounds().x, this.slideway.getBounds().y);
        RECT.translate((int)((float)this.slideway.getBounds().width * this.value), this.slideway.getBounds().height / 2);
        RECT.translate(-this.hotSpot.x, -this.hotSpot.y);
        this.button.setBounds(RECT);
    }
}

