/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.presentation.slide;

import java.util.List;
import org.xmind.core.IWorkbook;
import org.xmind.gef.command.SourceCommand;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.ui.internal.editor.IEditorLayout;
import org.xmind.ui.internal.editor.IEditorLayoutManager;
import org.xmind.ui.internal.presentation.slide.PresentationEditorLayout;
import org.xmind.ui.internal.presentation.slide.PresentationStory;
import org.xmind.ui.internal.presentation.slide.PresentationStoryManager;

public class DeleteStoryCommand
extends SourceCommand {
    private PresentationStory story;
    private int oldIndex = -1;
    private IGraphicalEditor editor;
    private IEditorLayoutManager layoutManager;

    public DeleteStoryCommand(PresentationStory story, IGraphicalEditor editor) {
        super((Object)story);
        this.story = story;
        this.editor = editor;
        this.layoutManager = (IEditorLayoutManager)editor.getAdapter(IEditorLayoutManager.class);
    }

    public void redo() {
        IWorkbook wb = this.story.getOwnedWorkbook();
        if (this.oldIndex < 0) {
            this.oldIndex = PresentationStoryManager.instance.getStories(wb).indexOf(this.story);
        }
        PresentationStoryManager.instance.deleteStory(wb, this.story);
        List<PresentationStory> stories = PresentationStoryManager.instance.getStories(wb);
        if (stories.size() > 0) {
            IEditorLayout currentEditorLayout = this.layoutManager.getActiveLayout();
            if (currentEditorLayout instanceof PresentationEditorLayout) {
                PresentationEditorLayout layout = (PresentationEditorLayout)currentEditorLayout;
                layout.setCurrentStory(stories.get(0));
            } else {
                this.layoutManager.restoreDefault();
            }
        } else {
            this.layoutManager.restoreDefault();
        }
        super.redo();
    }

    public void undo() {
        IWorkbook wb = this.story.getOwnedWorkbook();
        PresentationStoryManager.instance.addStory(wb, this.story, this.oldIndex);
        IEditorLayout currentEditorLayout = this.layoutManager.getActiveLayout();
        if (currentEditorLayout instanceof PresentationEditorLayout) {
            PresentationEditorLayout layout = (PresentationEditorLayout)currentEditorLayout;
            layout.setCurrentStory(this.story);
        } else {
            this.layoutManager.restoreDefault();
            PresentationEditorLayout layout = new PresentationEditorLayout(this.layoutManager, this.story, this.editor);
            layout.setSelectionProvider(this.editor.getSite().getSelectionProvider());
            this.layoutManager.setActiveLayout((IEditorLayout)layout);
        }
        super.undo();
    }
}

