/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.presentation.slide;

import com.aspose.slides.AsposeLicenseException;
import com.aspose.slides.License;
import com.aspose.slides.Link;
import com.aspose.slides.Paragraph;
import com.aspose.slides.ParagraphCollection;
import com.aspose.slides.Picture;
import com.aspose.slides.Placeholder;
import com.aspose.slides.Portion;
import com.aspose.slides.PortionCollection;
import com.aspose.slides.Presentation;
import com.aspose.slides.PresentationEx;
import com.aspose.slides.Slide;
import com.aspose.slides.TextHolder;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.xmind.core.Core;
import org.xmind.core.util.FileUtils;
import org.xmind.ui.internal.aspose.AsposePlugin;
import org.xmind.ui.internal.presentation.slide.PresentationSlide;
import org.xmind.ui.internal.presentation.slide.PresentationStory;
import org.xmind.ui.internal.presentation.slide.SlidePreviewGenerator;
import org.xmind.ui.wizards.ExportPart;
import org.xmind.ui.wizards.Exporter;
import org.xmind.ui.wizards.IExportPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PPTExporter
extends Exporter {
    public static final int PPT_97_2003 = 1;
    public static final int PPT_2007 = 2;
    public static final int ODP = 3;
    private static final String TEMP_PATH = "export/ppt/";
    private static final String PPTX_FILE_NAME = ".pptx";
    private static final int LAYOUT_TITLE = 1;
    private static final int LAYOUT_TEXT = 2;
    private static final int IMAGE_WIDTH = 1080;
    private static final int IMAGE_HEIGHT = 600;
    private String targetPath;
    private int version;
    private Presentation pres;
    private PresentationEx presx;
    private int slideCount = 0;
    private List<PresentationStory> stories;
    private Display display;

    public PPTExporter(List<PresentationStory> stories, String targetPath, int version, Display display) {
        super(null, null);
        this.targetPath = targetPath;
        this.version = version;
        this.stories = new ArrayList<PresentationStory>(stories);
        this.display = display;
    }

    public void init() {
        for (PresentationStory story : this.stories) {
            if (story == null || story.getSlidesSize() <= 0) continue;
            this.appendTitle(story.getName());
            this.appendStory(story);
        }
    }

    private void appendTitle(String name) {
        SlidePart slidePart = this.appendSlide(1);
        this.append((IExportPart)new TitlePart(name, slidePart));
    }

    private void appendStory(PresentationStory story) {
        if (story == null || story.getSlidesSize() == 0) {
            return;
        }
        for (PresentationSlide slide : story.getSlides()) {
            this.appendPresentationSlide(slide);
        }
    }

    private void appendPresentationSlide(PresentationSlide slide) {
        SlidePart slidePart = this.appendSlide(2);
        String imagePath = this.generateImage(slide);
        this.append((IExportPart)new ImagePart(imagePath, slidePart));
    }

    private String generateImage(final PresentationSlide slide) {
        final String path = this.createTempPath();
        FileUtils.ensureFileParent((File)new File(path));
        final boolean[] finish = new boolean[1];
        this.display.asyncExec(new Runnable(){

            public void run() {
                SlidePreviewGenerator.generate(slide, 1080, 600, path);
                finish[0] = true;
            }
        });
        while (!finish[0]) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return path;
    }

    private String createTempPath() {
        String tempPath = Core.getWorkspace().getTempFile("slide_ppt/" + UUID.randomUUID().toString() + ".png");
        return tempPath;
    }

    private SlidePart appendSlide(int layout) {
        SlidePart slidePart = new SlidePart(++this.slideCount, layout);
        this.append((IExportPart)slidePart);
        return slidePart;
    }

    public void start(Display display, Shell shell) throws InvocationTargetException {
        super.start(display, shell);
        this.setLicense();
        try {
            this.pres = new Presentation();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Locale.setDefault(new Locale("en"));
            this.pres = new Presentation();
        }
        this.removeFirstSlide();
    }

    private void setLicense() {
        try {
            new License().setLicense((InputStream)new ByteArrayInputStream(AsposePlugin.getAsposeLicense()));
        }
        catch (AsposeLicenseException e) {
            e.printStackTrace();
        }
    }

    private void removeFirstSlide() {
        if (this.pres != null) {
            Slide slide = this.pres.getSlides().get_Item(0);
            this.pres.getSlides().remove(slide);
        }
    }

    protected void write(IProgressMonitor monitor, IExportPart part) throws InvocationTargetException, InterruptedException {
        if (part instanceof PPTExportPart) {
            ((PPTExportPart)part).write(this.pres);
        }
    }

    public void end() throws InvocationTargetException {
        this.pres.write(this.targetPath);
        super.end();
    }

    private String getTempPath(String id) {
        return String.valueOf(Core.getWorkspace().getTempDir(TEMP_PATH)) + id;
    }

    private static class ImagePart
    extends PPTExportPart {
        private String path;
        private SlidePart slide;

        public ImagePart(String path, SlidePart slide) {
            this.path = path;
            this.slide = slide;
        }

        protected void write() {
            if (this.path != null) {
                Dimension size = new Dimension(1080, 600);
                this.picture(this.slide.getSlide(), this.path, 1, size);
                new File(this.path).delete();
            }
        }
    }

    private static abstract class PPTExportPart
    extends ExportPart {
        protected Presentation pres;
        protected static final int SHAPE_TITLE_POSITION = 0;
        protected static final int SHAPE_BODY_POSITION = 1;

        public PPTExportPart() {
            super(null, null);
        }

        public PPTExporter getExporter() {
            return (PPTExporter)super.getExporter();
        }

        public void write(Presentation pres) {
            this.pres = pres;
            this.write();
        }

        protected abstract void write();

        protected void setHyperlink(TextHolder holder, String text, String hyperlink) {
            Link link = holder.getLinks().addLink();
            link.setBegin(holder.getText().indexOf(text));
            link.setEnd(link.getBegin() + text.length());
            link.setExternalHyperlink(hyperlink);
        }

        protected void picture(Slide slide, String imagePath, int position, Dimension dimen) {
            Picture pic = null;
            try {
                pic = new Picture(this.pres, imagePath);
            }
            catch (Exception exception) {
                return;
            }
            int picId = this.pres.getPictures().add(pic);
            TextHolder holder = (TextHolder)slide.getPlaceholders().get_Item(position);
            this.minimizePlaceholder(slide.getPlaceholders().get_Item(1 - position));
            dimen = this.pictureFillShape(holder, dimen);
            int slideWidth = slide.getBackground().getWidth();
            int slideHeight = slide.getBackground().getHeight();
            int picFrameWidth = slideWidth / 2 - dimen.width / 2;
            int picFrameHeight = slideHeight / 2 - dimen.height / 2;
            slide.getShapes().addPictureFrame(picId, picFrameWidth, picFrameHeight, dimen.width, dimen.height);
        }

        private Dimension pictureFillShape(TextHolder holder, Dimension dimen) {
            int dimenWidth = dimen.width;
            int dimenHeight = dimen.height;
            int holderWidth = holder.getWidth();
            int holderHeight = holder.getHeight();
            double scale = dimenWidth > dimenHeight ? this.getpictureScale(holderWidth, dimenWidth) : this.getpictureScale(holderHeight, dimenHeight);
            dimen.setWidth((int)((double)dimenWidth * scale));
            dimen.setHeight((int)((double)dimenHeight * scale));
            this.pictureResize(holder, dimen);
            return dimen;
        }

        private double getpictureScale(int shapeSize, int imgSize) {
            return this.getDivide(shapeSize, imgSize);
        }

        private Dimension pictureResize(TextHolder holder, Dimension dimen) {
            double scale;
            if (dimen.width() > holder.getWidth()) {
                scale = this.getDivide(holder.getWidth(), dimen.width());
                dimen.setWidth((int)((double)dimen.width() * scale));
                dimen.setHeight((int)((double)dimen.height() * scale));
            }
            if (dimen.height() > holder.getHeight()) {
                scale = this.getDivide(holder.getHeight(), dimen.height());
                dimen.setWidth((int)((double)dimen.width() * scale));
                dimen.setHeight((int)((double)dimen.height() * scale));
            }
            return dimen;
        }

        private double getDivide(int value01, int value02) {
            BigDecimal val01 = new BigDecimal(value01);
            BigDecimal val02 = new BigDecimal(value02);
            return val01.divide(val02, 10, 1).doubleValue();
        }

        protected void minimizePlaceholder(Placeholder placeholder) {
            placeholder.setWidth(0);
            placeholder.setHeight(0);
            placeholder.setX(0);
            placeholder.setY(0);
        }
    }

    protected static abstract class ShapePart
    extends PPTExportPart {
        private SlidePart slide;
        private TextHolder textHolder;

        public ShapePart(SlidePart slide) {
            this.slide = slide;
        }

        protected TextHolder getTextHolder(int position) {
            TextHolder holder = (TextHolder)this.pres.getSlideByPosition(this.slide.getSlideIndex()).getPlaceholders().get_Item(position);
            return holder;
        }

        protected void fitShapeToText(TextHolder holder, int defaultHeight, int position) {
            double aveFontSize = 0.0;
            ParagraphCollection paras = holder.getParagraphs();
            try {
                while (defaultHeight < holder.getHeight()) {
                    int paraIndex = paras.getCount();
                    int i = 0;
                    while (i < paraIndex) {
                        Paragraph para = holder.getParagraphs().get_Item(i);
                        PortionCollection ports = para.getPortions();
                        int portIndex = ports.getCount();
                        int j = 0;
                        while (j < portIndex) {
                            Portion port = ports.get_Item(j);
                            short fontSize = port.getFontHeight();
                            fontSize = (short)(fontSize - 1);
                            port.setFontHeight(fontSize);
                            aveFontSize = this.averageFontSize(fontSize, aveFontSize);
                            holder.fitTextToShape();
                            ++j;
                        }
                        ++i;
                    }
                    if (!(aveFontSize < 8.0)) {
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            int slideWidth = holder.getSlide().getBackground().getWidth();
            int slideHeight = holder.getSlide().getBackground().getHeight();
            int x = slideWidth / 2 - holder.getWidth() / 2;
            int y = slideHeight / 2 - holder.getHeight() / 2;
            holder.setX(x);
            holder.setY(y);
            this.minimizePlaceholder(this.slide.getSlide().getPlaceholders().get_Item(1 - position));
        }

        protected void setText(String text, int position) {
            try {
                this.textHolder = this.getTextHolder(position);
                int defaultHeight = this.textHolder.getHeight();
                this.textHolder.setText(text);
                this.fitShapeToText(defaultHeight, position);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private void fitShapeToText(int defaultHeight, int position) {
            this.textHolder.setWrapText(true);
            this.textHolder.setFitShapeToText(true);
            this.fitShapeToText(this.textHolder, defaultHeight, position);
        }

        private double averageFontSize(int fontSize, double aveFontSize) {
            if (aveFontSize == 0.0) {
                return fontSize;
            }
            return (aveFontSize + (double)fontSize) / 2.0;
        }
    }

    protected static class SlidePart
    extends PPTExportPart {
        private int slideIndex;
        private int layout;

        public SlidePart(int slideIndex, int layout) {
            this.slideIndex = slideIndex;
            this.layout = layout;
        }

        public int getSlideIndex() {
            return this.slideIndex;
        }

        protected void write() {
            if (this.layout == 1) {
                this.pres.addTitleSlide();
            } else if (this.layout == 2) {
                this.pres.addBodySlide();
            }
        }

        public Slide getSlide() {
            return this.pres.getSlideByPosition(this.slideIndex);
        }
    }

    private static class TitlePart
    extends ShapePart {
        private String title;

        public TitlePart(String title, SlidePart slide) {
            super(slide);
            this.title = title;
        }

        protected void write() {
            this.setText(this.title, 0);
        }
    }
}

